/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util.bbcode.node;

import net.malisis.core.util.bbcode.node.BBNode;
import net.malisis.core.util.bbcode.render.BBRenderElement;

public class BBTextNode
extends BBNode {
    private StringBuilder text = new StringBuilder();
    private int index;

    public BBTextNode(String txt) {
        super("");
        this.text.append(txt);
        this.standAlone = true;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void shiftIndex(int amount) {
        this.index += amount;
    }

    public String getText() {
        return this.text.toString();
    }

    @Override
    public boolean hasTextNode() {
        return this.text.length() > 0;
    }

    public void append(String txt) {
        this.text.append(txt);
    }

    public boolean isInRange(int position) {
        return position - this.index >= 0 && position - this.index <= this.text.length();
    }

    public boolean isInRange(int start, int end) {
        return start - this.index < this.text.length() && end - this.index >= 0;
    }

    public int insert(int position, String txt) {
        if (!this.isInRange(position)) {
            return 0;
        }
        int p = position - this.index;
        this.text.insert(p, txt);
        return txt.length();
    }

    public String delete(int start, int end) {
        if (!this.isInRange(start, end)) {
            return "";
        }
        int s = start - this.index;
        int e = end - this.index;
        if (s < 0) {
            s = 0;
        }
        if (e > this.text.length()) {
            e = this.text.length();
        }
        String ret = this.text.substring(s, e);
        this.text.delete(s, e);
        return ret;
    }

    public BBTextNode[] split(int position) {
        int p = position - this.index;
        if (p < 0) {
            p = 0;
        }
        BBTextNode tn1 = new BBTextNode(this.text.substring(0, p));
        tn1.setIndex(this.index);
        BBTextNode tn2 = new BBTextNode(this.text.substring(p));
        tn2.setIndex(this.index + p);
        return new BBTextNode[]{tn1, tn2};
    }

    @Override
    public BBTextNode copy() {
        return new BBTextNode(this.text.toString());
    }

    @Override
    public void clean() {
        if (this.parent != null && this.text.length() < 0) {
            this.parent.remove(this);
        }
    }

    @Override
    public void apply(BBRenderElement element) {
        element.text = this.text.toString();
    }

    @Override
    public String toRawString() {
        return this.text.toString();
    }

    @Override
    public String toBBString() {
        return this.text.toString();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " : (" + this.index + ") " + this.text.toString();
    }
}

