/*
 * Decompiled with CFR 0.152.
 */
package sky_orchards;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import sky_orchards.blocks.BlockOreAmber;
import sky_orchards.blocks.BlockOreLeaves;
import sky_orchards.blocks.BlockOreLog;
import sky_orchards.blocks.BlockOreSapling;
import sky_orchards.blocks.EnumWood;
import sky_orchards.blocks.OreAmberBlockStateMapper;
import sky_orchards.blocks.OreLeafBlockStateMapper;
import sky_orchards.blocks.OreLogBlockStateMapper;
import sky_orchards.blocks.OreSaplingBlockStateMapper;

public class ModBlocks {
    public static final List<Block> BLOCKS = new LinkedList<Block>();
    public static final List<ItemBlock> ITEM_BLOCKS = new ArrayList<ItemBlock>();

    public static void init() {
        try {
            for (Field field : ModBlocks.class.getDeclaredFields()) {
                Object obj = field.get(null);
                if (!(obj instanceof Block)) continue;
                Block block = (Block)obj;
                String name = field.getName().toLowerCase(Locale.ENGLISH);
                ModBlocks.registerBlock(name, block);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        EnumWood.initBlocks();
    }

    public static void registerBlock(String name, Block block) {
        BLOCKS.add(block);
        if (block instanceof BlockOreLog) {
            ((Block)block.setRegistryName("sky_orchards", name)).func_149663_c("sky_orchards.ore_log");
        }
        if (block instanceof BlockOreSapling) {
            ((Block)block.setRegistryName("sky_orchards", name)).func_149663_c("sky_orchards.ore_sapling");
        }
        if (block instanceof BlockOreLeaves) {
            ((Block)block.setRegistryName("sky_orchards", name)).func_149663_c("sky_orchards.ore_leaves");
        }
        if (block instanceof BlockOreAmber) {
            ((Block)block.setRegistryName("sky_orchards", name)).func_149663_c("sky_orchards.ore_amber");
        }
        ItemBlock item = new ItemBlock(block){

            public String func_77653_i(ItemStack stack) {
                return new TextComponentTranslation(this.func_77657_g(stack), new Object[0]).func_150254_d();
            }
        };
        ITEM_BLOCKS.add(item);
        if (item.func_179223_d() instanceof BlockOreLog) {
            ((Item)item.setRegistryName("sky_orchards", name)).func_77655_b("sky_orchards.ore_log");
        }
        if (item.func_179223_d() instanceof BlockOreLeaves) {
            ((Item)item.setRegistryName("sky_orchards", name)).func_77655_b("sky_orchards.ore_leaves");
        }
        if (item.func_179223_d() instanceof BlockOreSapling) {
            ((Item)item.setRegistryName("sky_orchards", name)).func_77655_b("sky_orchards.ore_sapling");
        }
        if (item.func_179223_d() instanceof BlockOreAmber) {
            ((Item)item.setRegistryName("sky_orchards", name)).func_77655_b("sky_orchards.ore_amber");
        }
    }

    @Mod.EventBusSubscriber(modid="sky_orchards")
    public static class RegistrationHandlerBlocks {
        @SubscribeEvent
        public static void registerBlocks(RegistryEvent.Register<Block> event) {
            ModBlocks.init();
            IForgeRegistry registry = event.getRegistry();
            for (Block block : BLOCKS) {
                registry.register((IForgeRegistryEntry)block);
            }
        }

        @SubscribeEvent
        public static void registerItemBlocks(RegistryEvent.Register<Item> event) {
            IForgeRegistry registry = event.getRegistry();
            for (ItemBlock item : ITEM_BLOCKS) {
                registry.register((IForgeRegistryEntry)item);
            }
        }

        @SideOnly(value=Side.CLIENT)
        @SubscribeEvent
        public static void registerModels(ModelRegistryEvent event) {
            for (Block block : BLOCKS) {
                if (block instanceof BlockOreLog) {
                    ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)new OreLogBlockStateMapper());
                }
                if (block instanceof BlockOreSapling) {
                    ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)new OreSaplingBlockStateMapper());
                }
                if (block instanceof BlockOreLeaves) {
                    ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)new OreLeafBlockStateMapper());
                }
                if (!(block instanceof BlockOreAmber)) continue;
                ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)new OreAmberBlockStateMapper());
            }
            for (ItemBlock item : ITEM_BLOCKS) {
                ResourceLocation name = item.getRegistryName();
                if (item.func_179223_d() instanceof BlockOreLog) {
                    ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation("sky_orchards:ore_log", "inventory"));
                }
                if (item.func_179223_d() instanceof BlockOreLeaves) {
                    ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation("sky_orchards:ore_leaves", "inventory"));
                }
                if (item.func_179223_d() instanceof BlockOreSapling) {
                    ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation("sky_orchards:ore_sapling", "inventory"));
                }
                if (!(item.func_179223_d() instanceof BlockOreAmber)) continue;
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation("sky_orchards:ore_amber", "inventory"));
            }
        }
    }
}

