/*
 * Decompiled with CFR 0.152.
 */
package sky_orchards;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sky_orchards.ModBlocks;
import sky_orchards.ModItems;
import sky_orchards.blocks.IOreTreeColouredBlock;
import sky_orchards.items.IOreTreeColouredItem;

@Mod.EventBusSubscriber(modid="sky_orchards")
public class ModColours {
    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void registerBlockColourHandlers(ColorHandlerEvent.Block event) {
        BlockColors blockColors = event.getBlockColors();
        IBlockColor oreBlockTintColourHandler = (state, blockAccess, pos, tintIndex) -> {
            if (state.func_177230_c() instanceof IOreTreeColouredBlock) {
                return ((IOreTreeColouredBlock)state.func_177230_c()).getOreBlockLayerColour();
            }
            return -1;
        };
        for (Block block : ModBlocks.BLOCKS) {
            if (!(block instanceof IOreTreeColouredBlock)) continue;
            blockColors.func_186722_a(oreBlockTintColourHandler, new Block[]{block});
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void registerItemColourHandlers(ColorHandlerEvent.Item event) {
        BlockColors blockColors = event.getBlockColors();
        ItemColors itemColors = event.getItemColors();
        IItemColor oreItemBlockTintColourHandler = (stack, tintIndex) -> {
            IBlockState state = ((ItemBlock)stack.func_77973_b()).func_179223_d().func_176203_a(stack.func_77960_j());
            return blockColors.func_186724_a(state, null, null, tintIndex);
        };
        for (Block block : ModBlocks.BLOCKS) {
            if (!(block instanceof IOreTreeColouredBlock)) continue;
            itemColors.func_186731_a(oreItemBlockTintColourHandler, new Block[]{block});
        }
        IItemColor oreItemTintColourHandler = (stack, tintIndex) -> {
            Item item = stack.func_77973_b();
            return ((IOreTreeColouredItem)item).getOreItemLayerColour();
        };
        for (Item item : ModItems.ITEMS) {
            if (!(item instanceof IOreTreeColouredItem)) continue;
            itemColors.func_186730_a(oreItemTintColourHandler, new Item[]{item});
        }
    }
}

