/*
 * Decompiled with CFR 0.152.
 */
package sky_orchards;

import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import sky_orchards.blocks.EnumWood;
import sky_orchards.items.ItemOreAcorn;
import sky_orchards.items.ItemOreResin;

public class ModItems {
    public static final List<Item> ITEMS = new LinkedList<Item>();

    public static void init() {
        try {
            for (Field field : ModItems.class.getDeclaredFields()) {
                Object obj = field.get(null);
                if (!(obj instanceof Item)) continue;
                Item item = (Item)obj;
                String name = field.getName().toLowerCase(Locale.ENGLISH);
                ModItems.registerItem(name, item);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        EnumWood.initItems();
    }

    public static void registerItem(String name, Item item) {
        ITEMS.add(item);
        ((Item)item.setRegistryName("sky_orchards", name)).func_77655_b("sky_orchards." + name);
    }

    public static interface ISubItemsItem {
        public List<String> getModels();
    }

    @Mod.EventBusSubscriber(modid="sky_orchards")
    public static class RegistrationHandlerBlocks {
        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> event) {
            ModItems.init();
            IForgeRegistry registry = event.getRegistry();
            for (Item item : ITEMS) {
                registry.register((IForgeRegistryEntry)item);
            }
        }

        @SideOnly(value=Side.CLIENT)
        @SubscribeEvent
        public static void registerModels(ModelRegistryEvent event) {
            for (Item item : ITEMS) {
                if (item instanceof ISubItemsItem) {
                    List<String> models = ((ISubItemsItem)item).getModels();
                    for (int i = 0; i < models.size(); ++i) {
                        ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)new ModelResourceLocation("sky_orchards:" + models.get(i), "inventory"));
                    }
                    continue;
                }
                if (item instanceof ItemOreAcorn) {
                    ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation("sky_orchards:ore_acorn", "inventory"));
                    ModelLoader.setCustomModelResourceLocation((Item)item, (int)1, (ModelResourceLocation)new ModelResourceLocation("sky_orchards:ore_acorn_roasted", "inventory"));
                    continue;
                }
                if (item instanceof ItemOreResin) {
                    ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation("sky_orchards:ore_resin", "inventory"));
                    continue;
                }
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName().toString(), "inventory"));
            }
        }
    }
}

