/*
 * Decompiled with CFR 0.152.
 */
package sky_orchards.blocks;

import java.awt.Color;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sky_orchards.SkyOrchards;
import sky_orchards.blocks.EnumWood;
import sky_orchards.blocks.IOreTreeColouredBlock;

public class BlockOreLog
extends BlockLog
implements IOreTreeColouredBlock {
    private final EnumWood wood;

    public BlockOreLog(EnumWood wood) {
        this.wood = wood;
        this.func_149711_c(2.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149647_a(SkyOrchards.TAB);
        this.setHarvestLevel("axe", 0);
        Blocks.field_150480_ab.func_180686_a((Block)this, 5, 5);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176299_a, (Comparable)BlockLog.EnumAxis.Y));
    }

    public String func_149732_F() {
        return new TextComponentTranslation("tile.sky_orchards.ore_log.name", new Object[]{this.wood.getCapitalisedName()}).func_150254_d();
    }

    public String func_149739_a() {
        return new TextComponentTranslation("tile.sky_orchards.ore_log.name", new Object[]{this.wood.getCapitalisedName()}).func_150254_d();
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getOreBlockLayerColour() {
        return new Color(this.getWood().getRed(), this.getWood().getGreen(), this.getWood().getBlue()).getRGB() & 0xFFFFFF;
    }

    public EnumWood getWood() {
        return this.wood;
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState state = this.func_176223_P();
        switch (meta & 0xC) {
            case 0: {
                state = state.func_177226_a((IProperty)field_176299_a, (Comparable)BlockLog.EnumAxis.Y);
                break;
            }
            case 4: {
                state = state.func_177226_a((IProperty)field_176299_a, (Comparable)BlockLog.EnumAxis.X);
                break;
            }
            case 8: {
                state = state.func_177226_a((IProperty)field_176299_a, (Comparable)BlockLog.EnumAxis.Z);
                break;
            }
            default: {
                state = state.func_177226_a((IProperty)field_176299_a, (Comparable)BlockLog.EnumAxis.NONE);
            }
        }
        return state;
    }

    public int func_176201_c(IBlockState state) {
        int meta = 0;
        switch ((BlockLog.EnumAxis)state.func_177229_b((IProperty)field_176299_a)) {
            case X: {
                meta |= 4;
                break;
            }
            case Z: {
                meta |= 8;
                break;
            }
            case NONE: {
                meta |= 0xC;
            }
        }
        return meta;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{field_176299_a}).build();
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        Random rand = world instanceof World ? ((World)world).field_73012_v : RANDOM;
        drops.add((Object)new ItemStack(Blocks.field_150364_r.func_176223_P().func_177230_c()));
        for (int i = 0; i < 1 + rand.nextInt(2 + fortune); ++i) {
            drops.add((Object)new ItemStack(this.wood.getResin()));
        }
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return super.canSilkHarvest(world, pos, state, player);
    }
}

