/*
 * Decompiled with CFR 0.152.
 */
package sky_orchards.blocks;

import java.awt.Color;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenTrees;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sky_orchards.SkyOrchards;
import sky_orchards.blocks.EnumWood;
import sky_orchards.blocks.IOreTreeColouredBlock;

public class BlockOreSapling
extends BlockSapling
implements IOreTreeColouredBlock {
    private final EnumWood wood;

    public BlockOreSapling(EnumWood wood) {
        this.wood = wood;
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149647_a(SkyOrchards.TAB);
    }

    public String func_149732_F() {
        return new TextComponentTranslation("tile.sky_orchards.ore_sapling.name", new Object[]{this.wood.getCapitalisedName()}).func_150254_d();
    }

    public String func_149739_a() {
        return new TextComponentTranslation("tile.sky_orchards.ore_sapling.name", new Object[]{this.wood.getCapitalisedName()}).func_150254_d();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (tab == SkyOrchards.TAB) {
            list.add((Object)new ItemStack((Block)this));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getOreBlockLayerColour() {
        return new Color(this.wood.getRed(), this.wood.getGreen(), this.wood.getBlue()).getRGB();
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K) {
            super.func_180650_b(world, pos, state, rand);
            if (world.func_175671_l(pos.func_177984_a()) >= 9 && rand.nextInt(7) == 0) {
                this.func_176478_d(world, pos, state, rand);
            }
        }
    }

    public void func_176476_e(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!TerrainGen.saplingGrowTree((World)world, (Random)rand, (BlockPos)pos)) {
            return;
        }
        WorldGenTrees worldGen = new WorldGenTrees(true, 4, this.wood.getLog().func_176223_P(), this.wood.getLeaves().func_176223_P(), false);
        world.func_175698_g(pos);
        if (!worldGen.func_180709_b(world, rand, pos)) {
            world.func_175656_a(pos, this.func_176223_P());
        }
    }
}

