/*
 * Decompiled with CFR 0.152.
 */
package sky_orchards.configs;

import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ConfigHandler {
    public static final ConfigHandler INSTANCE = new ConfigHandler();
    public Configuration CONFIG;
    public static boolean ISLAND_SPAWNING;
    public static int ISLAND_MIN_RADIUS;
    public static int ISLAND_MAX_RADIUS;
    public static int ISLAND_CHANCE;
    public static int ACORN_DROP_CHANCE;
    public static String[] BLOCKS;
    public static String[] WORLDGEN;
    public static String[] usedCategories;

    public void loadConfig(FMLPreInitializationEvent event) {
        this.CONFIG = new Configuration(event.getSuggestedConfigurationFile());
        this.CONFIG.load();
        this.syncConfigs();
    }

    private void syncConfigs() {
        this.CONFIG.addCustomCategoryComment("Controls", "Controls Generation of Islands");
        ISLAND_SPAWNING = this.CONFIG.get("Controls", "Floating Islands Should Generate", false).getBoolean(false);
        ISLAND_MIN_RADIUS = this.CONFIG.get("Controls", "Smallest Radius Islands Should Generate", 1).getInt(1);
        ISLAND_MAX_RADIUS = this.CONFIG.get("Controls", "Largest Radius Islands Should Generate", 4).getInt(4);
        ISLAND_CHANCE = this.CONFIG.get("Controls", "(1:Amount) Chance that an Island Will Generate in Chunk", 150).getInt(150);
        this.CONFIG.addCustomCategoryComment("Blocks", "orename, modName:itemName#amount#metaData#dropChance, r, g, b");
        this.CONFIG.addCustomCategoryComment("Blocks", "For no leaf item drops 'null' or 'unused'");
        BLOCKS = this.CONFIG.getStringList("Custom Blocks", "Blocks", new String[]{"iron,null,188,153,128", "gold,null,252,238,75", "lapis,null,28,87,198", "redstone,minecraft:redstone#5#0#3,151,3,3", "diamond,null,119,206,251"}, "Something new.");
        this.CONFIG.addCustomCategoryComment("Drops", "Controls Acorn Drop Chance");
        ACORN_DROP_CHANCE = this.CONFIG.getInt("Acorn Drop Chance", "Drops", 3, 1, Integer.MAX_VALUE, "(1:Amount) Chance of Acorn being dropped when leaves are broken");
        this.CONFIG.addCustomCategoryComment("World Gen", "dimension, treeType, minGenHeight, maxGenHeight,spawnWeight, islandSurfaceBlock, islandFillerBlock. syntax is: dimInt#orename#minHeight,maxHeight#spawnWeight#modname:block,blockMeta,modname:block,blockMeta");
        WORLDGEN = this.CONFIG.getStringList("World Gen", "World Gen", new String[]{"0#iron#20,200#4#minecraft:grass,0,minecraft:dirt,0", "-1#redstone#20,100#4#minecraft:soul_sand,0,minecraft:netherrack,0"}, "Happy Birthday!");
        if (this.CONFIG.hasChanged()) {
            this.CONFIG.save();
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("sky_orchards")) {
            this.syncConfigs();
        }
    }

    static {
        usedCategories = new String[]{"Controls", "Blocks", "Drops", "World Gen"};
    }
}

