/*
 * Decompiled with CFR 0.152.
 */
package sky_orchards.world;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenTrees;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.IWorldGenerator;
import sky_orchards.blocks.EnumWood;
import sky_orchards.configs.ConfigHandler;

public class WorldGenTreeIslands
implements IWorldGenerator {
    public static DimensionManager DIM_MANAGER;
    protected int x;
    protected int z;
    protected int xx;
    protected int yy;
    protected int zz;
    protected int density;
    private static IBlockState ISLAND_FILLER;
    private static IBlockState ISLAND_TOP;
    private static EnumWood TYPE;
    private int MIN_HEIGHT;
    private int MAX_HEIGHT;

    public void generate(Random rand, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (!ConfigHandler.ISLAND_SPAWNING) {
            return;
        }
        ArrayList<String> treeTypesForDim = new ArrayList<String>();
        for (int islandTypes = 0; islandTypes < ConfigHandler.WORLDGEN.length; ++islandTypes) {
            Object[] entry = ConfigHandler.WORLDGEN[islandTypes].trim().split("#");
            if (entry.length != 5) {
                throw new IllegalArgumentException("Illegal entry found when reading Sky Orchards config file: " + ConfigHandler.WORLDGEN[islandTypes]);
            }
            if (Integer.valueOf(entry[0]).intValue() != world.field_73011_w.getDimension()) continue;
            Integer weight = Integer.valueOf((String)entry[3]);
            for (int amount = 0; amount < weight; ++amount) {
                treeTypesForDim.add(ConfigHandler.WORLDGEN[islandTypes]);
            }
        }
        if (!treeTypesForDim.isEmpty()) {
            Collections.shuffle(treeTypesForDim);
            String[] entryChosen = ((String)treeTypesForDim.get(0)).trim().split("#");
            for (EnumWood wood : EnumWood.values()) {
                if (!wood.func_176610_l().equals(entryChosen[1])) continue;
                TYPE = wood;
            }
            String[] height = entryChosen[2].trim().split(",");
            this.MIN_HEIGHT = Integer.valueOf(height[0]);
            this.MAX_HEIGHT = Integer.valueOf(height[1]);
            String[] finalBlockList = entryChosen[4].trim().split(",");
            ISLAND_TOP = ((Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(finalBlockList[0]))).func_176203_a(Integer.valueOf(finalBlockList[1]).intValue());
            ISLAND_FILLER = ((Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(finalBlockList[2]))).func_176203_a(Integer.valueOf(finalBlockList[3]).intValue());
            this.x = chunkX * 16;
            this.z = chunkZ * 16;
            BlockPos origin = new BlockPos(this.x + 16, this.MIN_HEIGHT, this.z + 16);
            this.xx = this.x + this.offsetXZ(rand);
            this.yy = rand.nextInt(this.MAX_HEIGHT + 1 - this.MIN_HEIGHT) + this.MIN_HEIGHT;
            this.zz = this.z + this.offsetXZ(rand);
            BlockPos pos = new BlockPos(this.xx, this.yy, this.zz);
            if (this.checkArea(world, origin, this.MAX_HEIGHT) && this.generate(world, rand, pos, TYPE, ISLAND_TOP, ISLAND_FILLER)) {
                return;
            }
        }
    }

    protected final int offsetXZ(Random rand) {
        return rand.nextInt(16) + 8;
    }

    public boolean generate(World world, Random rand, BlockPos pos, EnumWood type, IBlockState topBLock, IBlockState fillerBlock) {
        if (!world.func_175623_d(pos) || !world.func_180495_p(pos).func_185904_a().func_76222_j()) {
            return false;
        }
        if (rand.nextInt(ConfigHandler.ISLAND_CHANCE) != 0) {
            return false;
        }
        if (type == null) {
            return false;
        }
        int radius = rand.nextInt(ConfigHandler.ISLAND_MAX_RADIUS + 1 - ConfigHandler.ISLAND_MIN_RADIUS) + ConfigHandler.ISLAND_MIN_RADIUS;
        for (int y = 0; y < radius + 2; ++y) {
            for (int x = --radius * -1; x <= radius; ++x) {
                for (int z = radius * -1; z <= radius; ++z) {
                    double dSq = x * x + z * z;
                    if (Math.round(Math.sqrt(dSq)) > (long)radius) continue;
                    if (y == 0) {
                        world.func_180501_a(pos.func_177982_a(x, y, z), topBLock, 2);
                        continue;
                    }
                    world.func_180501_a(pos.func_177982_a(x, -y, z), fillerBlock, 2);
                }
            }
        }
        world.func_180501_a(pos, Blocks.field_150346_d.func_176223_P(), 2);
        WorldGenTrees worldgenerator = new WorldGenTrees(true, 4, type.getLog().func_176223_P(), type.getLeaves().func_176223_P(), false);
        worldgenerator.func_180709_b(world, rand, pos.func_177984_a());
        return true;
    }

    protected boolean checkArea(World world, BlockPos pos, int maxY) {
        for (int x = -16; x < 16; ++x) {
            for (int z = -16; z < 16; ++z) {
                for (int y = 0; y < maxY; ++y) {
                    if (world.func_175623_d(pos.func_177982_a(x, y, z))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    static {
        ISLAND_FILLER = Blocks.field_150346_d.func_176223_P();
        ISLAND_TOP = Blocks.field_150349_c.func_176223_P();
    }
}

