/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.bnbgamingcore.core.module;

import com.bloodnbonesgaming.bnbgamingcore.core.BNBGamingCorePlugin;
import com.bloodnbonesgaming.bnbgamingcore.core.module.IClassTransformerModule;
import com.bloodnbonesgaming.bnbgamingcore.core.util.ASMAdditionRegistry;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;
import squeek.asmhelper.com.bloodnbonesgaming.bnbgamingcore.ASMHelper;

public class ModulePerformAdditions
implements IClassTransformerModule {
    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return bytes;
        }
        Map<String, List<FieldNode>> fieldAdditions = ASMAdditionRegistry.getFieldAdditions();
        Map<String, List<MethodNode>> methodAdditions = ASMAdditionRegistry.getMethodAdditions();
        List<FieldNode> fNodes = fieldAdditions == null ? null : fieldAdditions.get(transformedName.replace(".", "/"));
        List<MethodNode> mNodes = methodAdditions == null ? null : methodAdditions.get(transformedName.replace(".", "/"));
        ClassNode cNode = ASMHelper.readClassFromBytes(bytes);
        boolean didSomething = false;
        if (fNodes != null && !fNodes.isEmpty()) {
            this.addFields(cNode, fNodes);
            didSomething = true;
        }
        if (mNodes != null && !mNodes.isEmpty()) {
            this.addMethods(cNode, mNodes);
            didSomething = true;
        }
        cNode.visitEnd();
        if (didSomething) {
            return ASMHelper.writeClassToBytes(cNode);
        }
        return bytes;
    }

    private void addFields(ClassNode node, List<FieldNode> fNodes) {
        BNBGamingCorePlugin.log.info("Found " + fNodes.size() + " fields to add to " + node.name);
        for (FieldNode fNode : fNodes) {
            fNode.accept((ClassVisitor)node);
        }
    }

    private void addMethods(ClassNode node, List<MethodNode> mNodes) {
        BNBGamingCorePlugin.log.info("Found " + mNodes.size() + " methods to add to " + node.name);
        for (MethodNode mNode : mNodes) {
            mNode.accept((ClassVisitor)node);
        }
    }

    @Override
    public String[] getClassesToTransform() {
        return new String[]{"*"};
    }

    @Override
    public String getModuleName() {
        return "performAdditionsModule";
    }

    @Override
    public boolean canBeDisabled() {
        return false;
    }

    @Override
    public void registerAdditions(ASMAdditionRegistry registry) {
    }
}

