/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.compat.crafttweaker;

import crafttweaker.api.data.DataByte;
import crafttweaker.api.data.DataByteArray;
import crafttweaker.api.data.DataDouble;
import crafttweaker.api.data.DataFloat;
import crafttweaker.api.data.DataInt;
import crafttweaker.api.data.DataIntArray;
import crafttweaker.api.data.DataList;
import crafttweaker.api.data.DataLong;
import crafttweaker.api.data.DataMap;
import crafttweaker.api.data.DataShort;
import crafttweaker.api.data.DataString;
import crafttweaker.api.data.IData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.stream.Collectors;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;

public class CraftTweakerUtils {
    public static String writeTag(NBTBase nbt) {
        return CraftTweakerUtils.from(nbt).toString();
    }

    private static IData from(NBTBase nbt) {
        if (nbt == null) {
            return null;
        }
        switch (nbt.func_74732_a()) {
            case 1: {
                return new DataByte(((NBTPrimitive)nbt).func_150290_f());
            }
            case 2: {
                return new DataShort(((NBTPrimitive)nbt).func_150289_e());
            }
            case 3: {
                return new DataInt(((NBTPrimitive)nbt).func_150287_d());
            }
            case 4: {
                return new DataLong(((NBTPrimitive)nbt).func_150291_c());
            }
            case 5: {
                return new DataFloat(((NBTPrimitive)nbt).func_150288_h());
            }
            case 6: {
                return new DataDouble(((NBTPrimitive)nbt).func_150286_g());
            }
            case 7: {
                return new DataByteArray(((NBTTagByteArray)nbt).func_150292_c(), false);
            }
            case 8: {
                return new DataString(((NBTTagString)nbt).func_150285_a_());
            }
            case 9: {
                ArrayList original = new ArrayList();
                ((NBTTagList)nbt).iterator().forEachRemaining(original::add);
                ArrayList values = new ArrayList(original.stream().map(value -> CraftTweakerUtils.from(value)).collect(Collectors.toList()));
                return new DataList(values, false);
            }
            case 10: {
                HashMap<String, IData> values = new HashMap<String, IData>();
                NBTTagCompound original = (NBTTagCompound)nbt;
                for (String key : original.func_150296_c()) {
                    values.put(key, CraftTweakerUtils.from(original.func_74781_a(key)));
                }
                return new DataMap(values, false);
            }
            case 11: {
                return new DataIntArray(((NBTTagIntArray)nbt).func_150302_c(), false);
            }
        }
        throw new RuntimeException("Unknown tag type: " + nbt.func_74732_a());
    }
}

