/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.crafting.table;

import com.blakebr0.cucumber.helper.RecipeHelper;
import com.blakebr0.cucumber.helper.StackHelper;
import com.blakebr0.extendedcrafting.config.ModConfig;
import com.blakebr0.extendedcrafting.crafting.endercrafter.IEnderCraftingRecipe;
import com.blakebr0.extendedcrafting.crafting.table.ITieredRecipe;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TableRecipeShapeless
implements IRecipe,
ITieredRecipe,
IEnderCraftingRecipe {
    protected ItemStack output = ItemStack.field_190927_a;
    protected NonNullList<Ingredient> input = NonNullList.func_191196_a();
    protected ResourceLocation group;
    protected int tier;
    protected Map<Integer, Function<ItemStack, ItemStack>> transformers;
    public int enderCrafterRecipeTimeRequired = ModConfig.confEnderTimeRequired;

    public TableRecipeShapeless(int tier, ItemStack result, Object ... recipe) {
        this.group = RecipeHelper.EMPTY_GROUP;
        this.tier = tier;
        this.output = result.func_77946_l();
        for (Object in : recipe) {
            Ingredient ing = CraftingHelper.getIngredient((Object)in);
            if (ing == null) {
                String ret = "Invalid shapeless ore recipe: ";
                for (Object tmp : recipe) {
                    ret = ret + tmp + ", ";
                }
                ret = ret + this.output;
                throw new RuntimeException(ret);
            }
            this.input.add((Object)ing);
        }
    }

    public ItemStack func_77571_b() {
        return this.output;
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        return this.output.func_77946_l();
    }

    public boolean func_77569_a(InventoryCrafting inv, World world) {
        NonNullList required = NonNullList.func_191196_a();
        required.addAll(this.input);
        if (this.tier != 0 && this.tier != this.getTierFromSize(inv.func_70302_i_())) {
            return false;
        }
        for (int x = 0; x < inv.func_70302_i_(); ++x) {
            ItemStack slot = inv.func_70301_a(x);
            if (slot.func_190926_b()) continue;
            boolean inRecipe = false;
            Iterator req = required.iterator();
            while (req.hasNext()) {
                Ingredient target = (Ingredient)req.next();
                if (!target.apply(slot)) continue;
                if (target.func_193365_a().length == 0) {
                    inRecipe = true;
                    req.remove();
                    break;
                }
                for (ItemStack stack : target.func_193365_a()) {
                    if (!StackHelper.compareTags((ItemStack)stack, (ItemStack)slot)) continue;
                    inRecipe = true;
                    req.remove();
                    break;
                }
                if (!inRecipe) continue;
                break;
            }
            if (inRecipe) continue;
            return false;
        }
        return required.isEmpty();
    }

    public NonNullList<Ingredient> func_192400_c() {
        return this.input;
    }

    public String func_193358_e() {
        return this.group == null ? "" : this.group.toString();
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= this.input.size();
    }

    public IRecipe setRegistryName(ResourceLocation name) {
        return null;
    }

    public ResourceLocation getRegistryName() {
        return null;
    }

    public Class<IRecipe> getRegistryType() {
        return null;
    }

    private int getTierFromSize(int size) {
        int tier = size < 10 ? 1 : (size < 26 && size > 9 ? 2 : (size < 50 && size > 25 ? 3 : 4));
        return tier;
    }

    @Override
    public int getTier() {
        if (this.tier > 0) {
            return this.tier;
        }
        int tier = this.input.size() < 10 ? 1 : (this.input.size() < 26 && this.input.size() > 9 ? 2 : (this.input.size() < 50 && this.input.size() > 25 ? 3 : 4));
        return tier;
    }

    @Override
    public boolean matches(IItemHandlerModifiable grid) {
        NonNullList required = NonNullList.func_191196_a();
        required.addAll(this.input);
        if (this.tier != 0 && this.tier != this.getTierFromSize(grid.getSlots())) {
            return false;
        }
        for (int x = 0; x < grid.getSlots(); ++x) {
            ItemStack slot = grid.getStackInSlot(x);
            if (slot.func_190926_b()) continue;
            boolean inRecipe = false;
            Iterator req = required.iterator();
            while (req.hasNext()) {
                if (!((Ingredient)req.next()).apply(slot)) continue;
                inRecipe = true;
                req.remove();
                break;
            }
            if (inRecipe) continue;
            return false;
        }
        return required.isEmpty();
    }

    public boolean requiresTier() {
        return this.tier > 0;
    }

    @Override
    public int getEnderCrafterTimeSeconds() {
        return this.enderCrafterRecipeTimeRequired;
    }

    public TableRecipeShapeless withTransforms(Map<Integer, Function<ItemStack, ItemStack>> transformers) {
        this.transformers = transformers;
        return this;
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        NonNullList remaining = super.func_179532_b(inv);
        if (this.transformers != null && !this.transformers.isEmpty()) {
            this.transformers.forEach((i, transformer) -> remaining.set(i.intValue(), transformer.apply(inv.func_70301_a(i.intValue()))));
        }
        return remaining;
    }
}

