/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.slabmachines.blocks;

import com.google.common.base.Predicate;
import com.mrbysco.slabmachines.SlabMachines;
import com.mrbysco.slabmachines.tileentity.compat.pitweaks.TilePiTweakFurnaceSlab;
import com.mrbysco.slabmachines.tileentity.furnace.TileFurnaceSlab;
import com.mrbysco.slabmachines.tileentity.furnace.compat.TileFastFurnaceSlab;
import com.mrbysco.slabmachines.utils.SlabUtil;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;

public class BlockFurnaceSlab
extends BlockSlab {
    public static final PropertyEnum<Variant> VARIANT = PropertyEnum.func_177709_a((String)"variant", Variant.class);
    public static final PropertyBool BURNING = PropertyBool.func_177716_a((String)"burning");
    private static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);

    public BlockFurnaceSlab() {
        super(Material.field_151576_e);
        this.func_149663_c("slabmachines:" + "furnace_slab".replaceAll("_", ""));
        this.setRegistryName("furnace_slab");
        this.func_149711_c(2.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.field_149783_u = true;
        this.func_149647_a(SlabMachines.slabTab);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)Variant.DEFAULT)).func_177226_a((IProperty)field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.BOTTOM).func_177226_a((IProperty)BURNING, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.setHarvestLevel("pickaxe", 0);
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand).func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        int id;
        if (worldIn.field_72995_K) {
            return true;
        }
        int n = id = state.func_177229_b((IProperty)field_176554_a) == BlockSlab.EnumBlockHalf.TOP ? 2 : 3;
        if (Loader.isModLoaded((String)"fastfurnace")) {
            id = state.func_177229_b((IProperty)field_176554_a) == BlockSlab.EnumBlockHalf.TOP ? 10 : 11;
        }
        playerIn.openGui((Object)SlabMachines.instance, id, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        playerIn.func_71029_a(StatList.field_188061_aa);
        return true;
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        TileFurnaceSlab te;
        if (!worldIn.field_72995_K && (te = SlabUtil.getTileSlab((IBlockAccess)worldIn, pos, (BlockSlab.EnumBlockHalf)state.func_177229_b((IProperty)BlockSlab.field_176554_a), TileFurnaceSlab.class)) != null) {
            InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)te);
            worldIn.func_175666_e(pos, (Block)this);
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        TileFurnaceSlab te = SlabUtil.getTileSlab((IBlockAccess)worldIn, pos, (BlockSlab.EnumBlockHalf)stateIn.func_177229_b((IProperty)BlockSlab.field_176554_a), TileFurnaceSlab.class);
        if (te != null && te.func_145950_i()) {
            EnumFacing enumfacing = (EnumFacing)stateIn.func_177229_b((IProperty)FACING);
            double d0 = (double)pos.func_177958_n() + 0.5;
            double y = (double)pos.func_177956_o() + rand.nextDouble() * 6.0 / 16.0;
            if (stateIn.func_177229_b((IProperty)field_176554_a) == BlockSlab.EnumBlockHalf.TOP) {
                y += 0.5;
            }
            double d2 = (double)pos.func_177952_p() + 0.5;
            double d4 = rand.nextDouble() * 0.6 - 0.3;
            if (rand.nextDouble() < 0.1) {
                worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, SoundEvents.field_187652_bv, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            }
            switch (enumfacing) {
                case WEST: {
                    worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 - 0.52, y, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                    worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 - 0.52, y, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
                case EAST: {
                    worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + 0.52, y, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                    worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 + 0.52, y, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
                case NORTH: {
                    worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + d4, y, d2 - 0.52, 0.0, 0.0, 0.0, new int[0]);
                    worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 + d4, y, d2 - 0.52, 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
                case SOUTH: {
                    worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + d4, y, d2 + 0.52, 0.0, 0.0, 0.0, new int[0]);
                    worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 + d4, y, d2 + 0.52, 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
            }
        }
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        return Container.func_178144_a((TileEntity)SlabUtil.getTileSlab((IBlockAccess)worldIn, pos, (BlockSlab.EnumBlockHalf)blockState.func_177229_b((IProperty)BlockSlab.field_176554_a), TileFurnaceSlab.class));
    }

    public Comparable<?> func_185674_a(ItemStack stack) {
        return Variant.DEFAULT;
    }

    public boolean func_176552_j() {
        return false;
    }

    public String func_150002_b(int meta) {
        return this.func_149739_a();
    }

    public IProperty<?> func_176551_l() {
        return VARIANT;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT, field_176554_a, BURNING, FACING});
    }

    public int func_176201_c(IBlockState state) {
        int meta = ((EnumFacing)state.func_177229_b((IProperty)FACING)).ordinal();
        if (state.func_177229_b((IProperty)field_176554_a) == BlockSlab.EnumBlockHalf.TOP) {
            meta |= 8;
        }
        return meta;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.field_82609_l[meta & 7];
        if (!EnumFacing.Plane.HORIZONTAL.apply(facing)) {
            facing = EnumFacing.NORTH;
        }
        boolean top = meta >> 3 == 1;
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing).func_177226_a((IProperty)field_176554_a, (Comparable)(top ? BlockSlab.EnumBlockHalf.TOP : BlockSlab.EnumBlockHalf.BOTTOM));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntityFurnace te = SlabUtil.getTileSlab(worldIn, pos, (BlockSlab.EnumBlockHalf)state.func_177229_b((IProperty)field_176554_a), TileFurnaceSlab.class);
        return te != null ? state.func_177226_a((IProperty)BURNING, (Comparable)Boolean.valueOf(te.func_145950_i())) : state;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        if (Loader.isModLoaded((String)"fastfurnace")) {
            return new TileFastFurnaceSlab();
        }
        if (Loader.isModLoaded((String)"pitweaks")) {
            return new TilePiTweakFurnaceSlab();
        }
        return new TileFurnaceSlab();
    }

    public static enum Variant implements IStringSerializable
    {
        DEFAULT;


        public String func_176610_l() {
            return "default";
        }
    }
}

