/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.slabmachines.blocks;

import com.google.common.collect.Lists;
import com.mrbysco.slabmachines.SlabMachines;
import com.mrbysco.slabmachines.tileentity.TileNoteSlab;
import com.mrbysco.slabmachines.utils.SlabUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.NoteBlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class BlockNoteblockSlab
extends BlockSlab {
    public static final PropertyEnum<Variant> VARIANT = PropertyEnum.func_177709_a((String)"variant", Variant.class);
    private static final List<SoundEvent> INSTRUMENTS = Lists.newArrayList((Object[])new SoundEvent[]{SoundEvents.field_187682_dG, SoundEvents.field_187676_dE, SoundEvents.field_187688_dI, SoundEvents.field_187685_dH, SoundEvents.field_187679_dF, SoundEvents.field_193809_ey, SoundEvents.field_193807_ew, SoundEvents.field_193810_ez, SoundEvents.field_193808_ex, SoundEvents.field_193785_eE});

    public BlockNoteblockSlab() {
        super(Material.field_151575_d);
        this.func_149663_c("slabmachines:" + "note_slab".replaceAll("_", ""));
        this.setRegistryName("note_slab");
        this.func_149711_c(2.5f);
        this.func_149672_a(SoundType.field_185848_a);
        this.field_149783_u = true;
        this.func_149647_a(SlabMachines.slabTab);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)Variant.DEFAULT)).func_177226_a((IProperty)field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.BOTTOM));
        this.setHarvestLevel("axe", 0);
    }

    public String func_150002_b(int meta) {
        return this.func_149739_a();
    }

    public boolean func_176552_j() {
        return false;
    }

    public IProperty<?> func_176551_l() {
        return VARIANT;
    }

    public Comparable<?> func_185674_a(ItemStack stack) {
        return Variant.DEFAULT;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.values()[meta]);
    }

    public int func_176201_c(IBlockState state) {
        return ((BlockSlab.EnumBlockHalf)state.func_177229_b((IProperty)field_176554_a)).ordinal();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT, field_176554_a});
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileNoteSlab te;
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (state.func_177229_b((IProperty)BlockSlab.field_176554_a) == BlockSlab.EnumBlockHalf.TOP && (te = SlabUtil.getTileSlab((IBlockAccess)worldIn, pos, BlockSlab.EnumBlockHalf.TOP, TileNoteSlab.class)) != null && te != null) {
            te.setMaterialInt(te.getMaterialIntFromBlockState(worldIn.func_180495_p(pos.func_177977_b())));
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        TileNoteSlab te = SlabUtil.getTileSlab((IBlockAccess)worldIn, pos, (BlockSlab.EnumBlockHalf)state.func_177229_b((IProperty)BlockSlab.field_176554_a), TileNoteSlab.class);
        if (te != null) {
            ItemStack stack = playerIn.func_184586_b(hand);
            if (stack.func_77973_b() instanceof ItemBlock && state.func_177229_b((IProperty)BlockSlab.field_176554_a) == BlockSlab.EnumBlockHalf.TOP) {
                IBlockState stackState = Block.func_149634_a((Item)stack.func_77973_b()).func_176223_P();
                if (te.getMaterialInt() != te.getMaterialIntFromBlockState(stackState)) {
                    te.setMaterialInt(te.getMaterialIntFromBlockState(stackState));
                }
            }
            byte old = te.field_145879_a;
            te.func_145877_a();
            if (old == te.field_145879_a) {
                return false;
            }
            te.func_175108_a(worldIn, pos);
            playerIn.func_71029_a(StatList.field_188087_U);
        }
        return true;
    }

    public void func_180649_a(World worldIn, BlockPos pos, EntityPlayer playerIn) {
        TileNoteSlab te;
        if (!worldIn.field_72995_K && (te = SlabUtil.getTileSlab((IBlockAccess)worldIn, pos, (BlockSlab.EnumBlockHalf)worldIn.func_180495_p(pos).func_177229_b((IProperty)BlockSlab.field_176554_a), TileNoteSlab.class)) != null) {
            te.func_175108_a(worldIn, pos);
            playerIn.func_71029_a(StatList.field_188086_T);
        }
    }

    public boolean func_190946_v(IBlockState state) {
        return true;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileNoteSlab();
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        boolean flag = worldIn.func_175640_z(pos);
        TileNoteSlab te = SlabUtil.getTileSlab((IBlockAccess)worldIn, pos, (BlockSlab.EnumBlockHalf)state.func_177229_b((IProperty)BlockSlab.field_176554_a), TileNoteSlab.class);
        if (te != null && te.field_145880_i != flag) {
            if (flag) {
                te.func_175108_a(worldIn, pos);
            }
            te.field_145880_i = flag;
        }
    }

    private SoundEvent getInstrument(int eventId) {
        if (eventId < 0 || eventId >= INSTRUMENTS.size()) {
            eventId = 0;
        }
        return INSTRUMENTS.get(eventId);
    }

    public boolean func_189539_a(IBlockState state, World worldIn, BlockPos pos, int id, int param) {
        NoteBlockEvent.Play e = new NoteBlockEvent.Play(worldIn, pos, state, param, id);
        if (MinecraftForge.EVENT_BUS.post((Event)e)) {
            return false;
        }
        id = e.getInstrument().ordinal();
        param = e.getVanillaNoteId();
        float f = (float)Math.pow(2.0, (double)(param - 12) / 12.0);
        worldIn.func_184133_a((EntityPlayer)null, pos, this.getInstrument(id), SoundCategory.RECORDS, 3.0f, f);
        worldIn.func_175688_a(EnumParticleTypes.NOTE, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.2, (double)pos.func_177952_p() + 0.5, (double)param / 24.0, 0.0, 0.0, new int[0]);
        return true;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_185481_k(IBlockState state) {
        return state.func_177229_b((IProperty)BlockSlab.field_176554_a) == BlockSlab.EnumBlockHalf.TOP;
    }

    public static enum Variant implements IStringSerializable
    {
        DEFAULT;


        public String func_176610_l() {
            return "default";
        }
    }
}

