/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.slabmachines.blocks.compat.tinkers;

import com.google.common.base.Predicate;
import com.mrbysco.slabmachines.SlabMachines;
import com.mrbysco.slabmachines.tileentity.compat.tinkers.TilePartChestSlab;
import com.mrbysco.slabmachines.utils.SlabUtil;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import slimeknights.mantle.inventory.BaseContainer;
import slimeknights.mantle.property.PropertyUnlistedDirection;
import slimeknights.mantle.tileentity.TileInventory;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.tools.common.block.ITinkerStationBlock;
import slimeknights.tconstruct.tools.common.tileentity.TileTinkerChest;

public class BlockPartChestSlab
extends BlockSlab
implements ITinkerStationBlock {
    public static final PropertyEnum<Variant> VARIANT = PropertyEnum.func_177709_a((String)"variant", Variant.class);
    public static final PropertyDirection FACING = new PropertyUnlistedDirection("facing", (Predicate)EnumFacing.Plane.HORIZONTAL);

    public BlockPartChestSlab() {
        super(Material.field_151575_d);
        this.func_149663_c("slabmachines:" + "part_chest_slab".replaceAll("_", ""));
        this.setRegistryName("part_chest_slab");
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.field_149783_u = true;
        this.func_149647_a(SlabMachines.slabTab);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)Variant.DEFAULT)).func_177226_a((IProperty)field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.BOTTOM).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.setHarvestLevel("axe", 0);
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public String func_150002_b(int meta) {
        return this.func_149739_a();
    }

    public boolean func_176552_j() {
        return false;
    }

    public IProperty<?> func_176551_l() {
        return VARIANT;
    }

    public Comparable<?> func_185674_a(ItemStack stack) {
        return Variant.DEFAULT;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.field_82609_l[meta & 7];
        if (!EnumFacing.Plane.HORIZONTAL.apply(facing)) {
            facing = EnumFacing.NORTH;
        }
        boolean top = meta >> 3 == 1;
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing).func_177226_a((IProperty)field_176554_a, (Comparable)(top ? BlockSlab.EnumBlockHalf.TOP : BlockSlab.EnumBlockHalf.BOTTOM));
    }

    public int func_176201_c(IBlockState state) {
        int meta = ((EnumFacing)state.func_177229_b((IProperty)FACING)).ordinal();
        if (state.func_177229_b((IProperty)field_176554_a) == BlockSlab.EnumBlockHalf.TOP) {
            meta |= 8;
        }
        return meta;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT, field_176554_a, FACING});
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand).func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        NBTTagCompound tag = TagUtil.getTagSafe((ItemStack)stack);
        TilePartChestSlab te = SlabUtil.getTileSlab((IBlockAccess)worldIn, pos, (BlockSlab.EnumBlockHalf)state.func_177229_b((IProperty)field_176554_a), TilePartChestSlab.class);
        if (te != null) {
            te.setFacing(placer.func_174811_aO().func_176734_d());
            if (tag.func_74764_b("inventory")) {
                te.readInventoryFromNBT(tag.func_74775_l("inventory"));
            }
            if (stack.func_82837_s()) {
                te.setCustomName(stack.func_82833_r());
            }
        }
    }

    public boolean openGui(EntityPlayer player, World world, BlockPos pos) {
        int id = world.func_180495_p(pos).func_177229_b((IProperty)field_176554_a) == BlockSlab.EnumBlockHalf.TOP ? 24 : 25;
        player.openGui((Object)SlabMachines.instance, id, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        if (player.field_71070_bA instanceof BaseContainer) {
            ((BaseContainer)player.field_71070_bA).syncOnOpen((EntityPlayerMP)player);
        }
        return true;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IItemHandlerModifiable itemHandler;
        ItemStack rest;
        if (playerIn.func_70093_af()) {
            return false;
        }
        TilePartChestSlab te = SlabUtil.getTileSlab((IBlockAccess)worldIn, pos, (BlockSlab.EnumBlockHalf)state.func_177229_b((IProperty)field_176554_a), TilePartChestSlab.class);
        ItemStack heldItem = playerIn.field_71071_by.func_70448_g();
        if (!heldItem.func_190926_b() && te != null && te instanceof TileTinkerChest && ((rest = ItemHandlerHelper.insertItem((IItemHandler)(itemHandler = te.getItemHandler()), (ItemStack)heldItem, (boolean)false)).func_190926_b() || rest.func_190916_E() < heldItem.func_190916_E())) {
            playerIn.field_71071_by.field_70462_a.set(playerIn.field_71071_by.field_70461_c, (Object)rest);
            return true;
        }
        if (!worldIn.field_72995_K) {
            this.openGui(playerIn, worldIn, pos);
        }
        return true;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TilePartChestSlab();
    }

    public int getGuiNumber(IBlockState state) {
        return 16;
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        TilePartChestSlab table = SlabUtil.getTileSlab((IBlockAccess)world, pos, (BlockSlab.EnumBlockHalf)world.func_180495_p(pos).func_177229_b((IProperty)field_176554_a), TilePartChestSlab.class);
        if (table != null) {
            table.setFacing(table.getFacing().func_176746_e());
            IBlockState state = world.func_180495_p(pos);
            world.func_184138_a(pos, state, state, 0);
            return true;
        }
        return false;
    }

    private void writeDataOntoItemstack(@Nonnull ItemStack item, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull IBlockState state, boolean inventorySave) {
        TilePartChestSlab te = SlabUtil.getTileSlab(world, pos, (BlockSlab.EnumBlockHalf)state.func_177229_b((IProperty)field_176554_a), TilePartChestSlab.class);
        if (te != null) {
            TilePartChestSlab table = te;
            NBTTagCompound tag = TagUtil.getTagSafe((ItemStack)item);
            if (inventorySave && this.keepInventory() && !table.isInventoryEmpty()) {
                NBTTagCompound inventoryTag = new NBTTagCompound();
                table.writeInventoryToNBT(inventoryTag);
                tag.func_74782_a("inventory", (NBTBase)inventoryTag);
                table.func_174888_l();
            }
            if (!tag.func_82582_d()) {
                item.func_77982_d(tag);
            }
        }
    }

    public void func_180653_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, float chance, int fortune) {
        if (!worldIn.field_72995_K && !worldIn.restoringBlockSnapshots) {
            List items = this.getDrops((IBlockAccess)worldIn, pos, state, fortune);
            chance = ForgeEventFactory.fireBlockHarvesting((List)items, (World)worldIn, (BlockPos)pos, (IBlockState)state, (int)fortune, (float)chance, (boolean)false, (EntityPlayer)((EntityPlayer)this.harvesters.get()));
            for (ItemStack item : items) {
                if (item.func_77973_b() != Item.func_150898_a((Block)this)) continue;
                this.writeDataOntoItemstack(item, (IBlockAccess)worldIn, pos, state, chance >= 1.0f);
            }
            TilePartChestSlab te = SlabUtil.getTileSlab((IBlockAccess)worldIn, pos, (BlockSlab.EnumBlockHalf)state.func_177229_b((IProperty)field_176554_a), TilePartChestSlab.class);
            if (te != null && te instanceof TileInventory) {
                TilePartChestSlab tileInventory = te;
                for (int i = 0; i < tileInventory.func_70302_i_(); ++i) {
                    ItemStack itemStack = tileInventory.func_70301_a(i);
                    if (itemStack.func_190926_b()) continue;
                    items.add(itemStack);
                }
                tileInventory.func_174888_l();
                if (tileInventory.func_145818_k_()) {
                    for (ItemStack item : items) {
                        if (item.func_77973_b() != Item.func_150898_a((Block)this)) continue;
                        item.func_151001_c(tileInventory.func_70005_c_());
                        item.func_82841_c(0);
                    }
                }
            }
            for (ItemStack item : items) {
                if (!(worldIn.field_73012_v.nextFloat() <= chance)) continue;
                BlockPartChestSlab.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)item);
            }
        }
    }

    public boolean removedByPlayer(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player, boolean willHarvest) {
        TilePartChestSlab te;
        this.func_176206_d(world, pos, state);
        if (willHarvest) {
            this.func_180657_a(world, player, pos, state, world.func_175625_s(pos), player.func_184614_ca());
        }
        if ((te = SlabUtil.getTileSlab((IBlockAccess)world, pos, (BlockSlab.EnumBlockHalf)state.func_177229_b((IProperty)field_176554_a), TilePartChestSlab.class)) != null && te instanceof TileInventory) {
            te.func_174888_l();
        }
        world.func_175698_g(pos);
        return false;
    }

    public ItemStack getPickBlock(@Nonnull IBlockState state, RayTraceResult target, @Nonnull World world, @Nonnull BlockPos pos, EntityPlayer player) {
        List drops = this.getDrops((IBlockAccess)world, pos, world.func_180495_p(pos), 0);
        if (drops.size() > 0) {
            ItemStack stack = (ItemStack)drops.get(0);
            this.writeDataOntoItemstack(stack, (IBlockAccess)world, pos, state, false);
            return stack;
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    private boolean keepInventory() {
        return Config.chestsKeepInventory;
    }

    public static enum Variant implements IStringSerializable
    {
        DEFAULT;


        public String func_176610_l() {
            return "default";
        }
    }
}

