/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.slabmachines.compat.waila;

import com.mrbysco.slabmachines.init.SlabBlocks;
import com.mrbysco.slabmachines.tileentity.furnace.TileFurnaceSlab;
import com.mrbysco.slabmachines.tileentity.furnace.compat.TileFastFurnaceSlab;
import java.util.List;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.api.IWailaRegistrar;
import mcp.mobius.waila.api.SpecialChars;
import mcp.mobius.waila.api.WailaPlugin;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;

@WailaPlugin
public class FurnaceDataProvider
implements IWailaDataProvider,
IWailaPlugin {
    public void register(IWailaRegistrar registrar) {
        registrar.addConfig("VanillaMC", "vanilla.furnacedisplay", true);
        FurnaceDataProvider provider = new FurnaceDataProvider();
        if (Loader.isModLoaded((String)"fastfurnace")) {
            registrar.registerBodyProvider((IWailaDataProvider)provider, TileFastFurnaceSlab.class);
            registrar.registerNBTProvider((IWailaDataProvider)provider, TileFastFurnaceSlab.class);
        } else {
            registrar.registerBodyProvider((IWailaDataProvider)provider, TileFurnaceSlab.class);
            registrar.registerNBTProvider((IWailaDataProvider)provider, TileFurnaceSlab.class);
        }
    }

    @Nonnull
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        String name;
        if (!config.getConfig("vanilla.furnacedisplay") || accessor.getBlock() != SlabBlocks.furnaceSlab) {
            return currenttip;
        }
        short cookTime = accessor.getNBTData().func_74765_d("CookTime");
        NBTTagList itemTag = accessor.getNBTData().func_150295_c("Items", 10);
        ItemStack[] inventory = new ItemStack[3];
        for (int i = 0; i < itemTag.func_74745_c(); ++i) {
            ItemStack stack;
            NBTTagCompound tagCompound = itemTag.func_150305_b(i);
            byte slot = tagCompound.func_74771_c("Slot");
            inventory[slot] = stack = new ItemStack(tagCompound);
        }
        String renderStr = "";
        if (inventory[0] != null) {
            name = inventory[0].func_77973_b().getRegistryName().toString();
            renderStr = renderStr + SpecialChars.getRenderString((String)"waila.stack", (String[])new String[]{"1", name, String.valueOf(inventory[0].func_190916_E()), String.valueOf(inventory[0].func_77952_i())});
        } else {
            renderStr = renderStr + SpecialChars.getRenderString((String)"waila.stack", (String[])new String[]{"2"});
        }
        if (inventory[1] != null) {
            name = inventory[1].func_77973_b().getRegistryName().toString();
            renderStr = renderStr + SpecialChars.getRenderString((String)"waila.stack", (String[])new String[]{"1", name, String.valueOf(inventory[1].func_190916_E()), String.valueOf(inventory[1].func_77952_i())});
        } else {
            renderStr = renderStr + SpecialChars.getRenderString((String)"waila.stack", (String[])new String[]{"2"});
        }
        renderStr = renderStr + SpecialChars.getRenderString((String)"waila.progress", (String[])new String[]{String.valueOf(cookTime), String.valueOf(200)});
        if (inventory[2] != null) {
            name = inventory[2].func_77973_b().getRegistryName().toString();
            renderStr = renderStr + SpecialChars.getRenderString((String)"waila.stack", (String[])new String[]{"1", name, String.valueOf(inventory[2].func_190916_E()), String.valueOf(inventory[2].func_77952_i())});
        } else {
            renderStr = renderStr + SpecialChars.getRenderString((String)"waila.stack", (String[])new String[]{"2"});
        }
        currenttip.add(renderStr);
        return currenttip;
    }

    @Nonnull
    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        return te.func_189515_b(tag);
    }
}

