/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.slabmachines.utils;

import java.util.Optional;
import mcmultipart.api.multipart.IMultipartTile;
import mcmultipart.api.multipart.MultipartHelper;
import mcmultipart.api.slot.EnumFaceSlot;
import mcmultipart.api.slot.IPartSlot;
import mcmultipart.util.MCMPWorldWrapper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;

public class SlabUtil {
    @Optional.Method(modid="mcmultipart")
    public static <TE extends TileEntity> TE detectSlabTileentity(World world, BlockPos pos, Class<TE> clazz) {
        TileEntity te;
        IMultipartTile theTile;
        World worldIn = world;
        if (world instanceof MCMPWorldWrapper) {
            worldIn = ((MCMPWorldWrapper)world).getActualWorld();
        }
        Optional tile = MultipartHelper.getPartTile((IBlockAccess)worldIn, (BlockPos)pos, (IPartSlot)EnumFaceSlot.UP);
        Optional tile2 = MultipartHelper.getPartTile((IBlockAccess)worldIn, (BlockPos)pos, (IPartSlot)EnumFaceSlot.DOWN);
        if (tile.isPresent()) {
            TileEntity te2;
            IMultipartTile theTile2 = tile.orElse(null);
            if (theTile2 != null && (te2 = theTile2.getTileEntity()) != null && clazz.isAssignableFrom(te2.getClass())) {
                return (TE)te2;
            }
        } else if (tile2.isPresent() && (theTile = (IMultipartTile)tile2.orElse(null)) != null && (te = theTile.getTileEntity()) != null && clazz.isAssignableFrom(te.getClass())) {
            return (TE)te;
        }
        return null;
    }

    @Optional.Method(modid="mcmultipart")
    public static <TE extends TileEntity> TE detectLeveledSlab(World world, BlockPos pos, Class<TE> clazz, BlockSlab.EnumBlockHalf half) {
        TileEntity te;
        IMultipartTile theTile;
        EnumFaceSlot slot;
        Optional tile;
        World worldIn = world;
        if (world instanceof MCMPWorldWrapper) {
            worldIn = ((MCMPWorldWrapper)world).getActualWorld();
        }
        if ((tile = MultipartHelper.getPartTile((IBlockAccess)worldIn, (BlockPos)pos, (IPartSlot)(slot = half == BlockSlab.EnumBlockHalf.BOTTOM ? EnumFaceSlot.DOWN : EnumFaceSlot.UP))).isPresent() && (theTile = (IMultipartTile)tile.orElse(null)) != null && (te = theTile.getTileEntity()) != null && clazz.isAssignableFrom(te.getClass())) {
            return (TE)te;
        }
        return null;
    }

    public static <TE extends TileEntity> TE getTileSlab(IBlockAccess world, BlockPos pos, BlockSlab.EnumBlockHalf half, Class<TE> clazz) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && clazz.isAssignableFrom(te.getClass())) {
            return (TE)te;
        }
        if (Loader.isModLoaded((String)"mcmultipart")) {
            return SlabUtil.getPartTileSlab(world, pos, half, clazz);
        }
        return null;
    }

    @Optional.Method(modid="mcmultipart")
    private static <TE extends TileEntity> TE getPartTileSlab(IBlockAccess world, BlockPos pos, BlockSlab.EnumBlockHalf half, Class<TE> clazz) {
        TileEntity te;
        EnumFaceSlot slot = half == BlockSlab.EnumBlockHalf.TOP ? EnumFaceSlot.UP : EnumFaceSlot.DOWN;
        Optional tile = MultipartHelper.getPartTile((IBlockAccess)world, (BlockPos)pos, (IPartSlot)slot);
        if (tile.isPresent() && (te = ((IMultipartTile)tile.get()).getTileEntity()) != null && clazz.isAssignableFrom(te.getClass())) {
            return (TE)te;
        }
        return null;
    }

    public static IBlockState getStateSlab(IBlockAccess world, BlockPos pos, Block block) {
        IBlockState state = world.func_180495_p(pos);
        if (state != null && state.func_177230_c() == block) {
            return state;
        }
        if (Loader.isModLoaded((String)"mcmultipart")) {
            return SlabUtil.getPartStateSlab(world, pos, block);
        }
        return null;
    }

    @Optional.Method(modid="mcmultipart")
    public static IBlockState getPartStateSlab(IBlockAccess world, BlockPos pos, Block block) {
        Optional down = MultipartHelper.getPartState((IBlockAccess)world, (BlockPos)pos, (IPartSlot)EnumFaceSlot.DOWN);
        if (down.isPresent() && ((IBlockState)down.get()).func_177230_c() == block) {
            return (IBlockState)down.get();
        }
        Optional up = MultipartHelper.getPartState((IBlockAccess)world, (BlockPos)pos, (IPartSlot)EnumFaceSlot.UP);
        if (up.isPresent() && ((IBlockState)up.get()).func_177230_c() == block) {
            return (IBlockState)up.get();
        }
        return null;
    }
}

