/*
 * Decompiled with CFR 0.152.
 */
package com.viesis.viescraft.api;

import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.util.text.translation.I18n;

public class ColorHelperVC {
    public static ArrayList<ColorName> initColorList() {
        ArrayList<ColorName> colorList = new ArrayList<ColorName>();
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.1"), 240, 248, 255));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.2"), 250, 235, 215));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.3"), 0, 255, 255));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.4"), 127, 255, 212));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.5"), 240, 255, 255));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.6"), 245, 245, 220));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.7"), 255, 228, 196));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.8"), 0, 0, 0));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.9"), 255, 235, 205));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.10"), 0, 0, 255));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.11"), 138, 43, 226));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.12"), 165, 42, 42));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.13"), 222, 184, 135));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.14"), 95, 158, 160));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.15"), 127, 255, 0));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.16"), 210, 105, 30));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.17"), 255, 127, 80));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.18"), 100, 149, 237));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.19"), 255, 248, 220));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.20"), 220, 20, 60));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.21"), 0, 255, 255));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.22"), 0, 0, 139));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.23"), 0, 139, 139));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.24"), 184, 134, 11));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.25"), 169, 169, 169));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.26"), 0, 100, 0));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.27"), 189, 183, 107));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.28"), 139, 0, 139));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.29"), 85, 107, 47));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.30"), 255, 140, 0));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.31"), 153, 50, 204));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.32"), 139, 0, 0));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.33"), 233, 150, 122));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.34"), 143, 188, 143));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.35"), 72, 61, 139));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.36"), 47, 79, 79));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.37"), 0, 206, 209));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.38"), 148, 0, 211));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.39"), 255, 20, 147));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.40"), 0, 191, 255));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.41"), 105, 105, 105));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.42"), 30, 144, 255));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.43"), 178, 34, 34));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.44"), 255, 250, 240));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.45"), 34, 139, 34));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.46"), 255, 0, 255));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.47"), 220, 220, 220));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.48"), 248, 248, 255));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.49"), 255, 215, 0));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.50"), 218, 165, 32));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.51"), 128, 128, 128));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.52"), 0, 128, 0));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.53"), 173, 255, 47));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.54"), 240, 255, 240));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.55"), 255, 105, 180));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.56"), 205, 92, 92));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.57"), 75, 0, 130));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.58"), 255, 255, 240));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.59"), 240, 230, 140));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.60"), 230, 230, 250));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.61"), 255, 240, 245));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.62"), 124, 252, 0));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.63"), 255, 250, 205));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.64"), 173, 216, 230));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.65"), 240, 128, 128));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.66"), 224, 255, 255));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.67"), 250, 250, 210));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.68"), 211, 211, 211));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.69"), 144, 238, 144));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.70"), 255, 182, 193));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.71"), 255, 160, 122));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.72"), 32, 178, 170));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.73"), 135, 206, 250));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.74"), 119, 136, 153));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.75"), 176, 196, 222));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.76"), 255, 255, 224));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.77"), 0, 255, 0));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.78"), 50, 205, 50));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.79"), 250, 240, 230));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.80"), 255, 0, 255));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.81"), 128, 0, 0));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.82"), 102, 205, 170));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.83"), 0, 0, 205));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.84"), 186, 85, 211));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.85"), 147, 112, 219));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.86"), 60, 179, 113));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.87"), 123, 104, 238));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.88"), 0, 250, 154));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.89"), 72, 209, 204));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.90"), 199, 21, 133));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.91"), 25, 25, 112));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.92"), 245, 255, 250));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.93"), 255, 228, 225));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.94"), 255, 228, 181));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.95"), 255, 222, 173));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.96"), 0, 0, 128));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.97"), 253, 245, 230));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.98"), 128, 128, 0));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.99"), 107, 142, 35));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.100"), 255, 165, 0));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.101"), 255, 69, 0));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.102"), 218, 112, 214));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.103"), 238, 232, 170));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.104"), 152, 251, 152));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.105"), 175, 238, 238));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.106"), 219, 112, 147));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.107"), 255, 239, 213));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.108"), 255, 218, 185));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.109"), 205, 133, 63));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.110"), 255, 192, 203));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.111"), 221, 160, 221));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.112"), 176, 224, 230));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.113"), 128, 0, 128));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.114"), 255, 0, 0));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.115"), 188, 143, 143));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.116"), 65, 105, 225));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.117"), 139, 69, 19));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.118"), 250, 128, 114));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.119"), 244, 164, 96));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.120"), 46, 139, 87));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.121"), 255, 245, 238));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.122"), 160, 82, 45));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.123"), 192, 192, 192));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.124"), 135, 206, 235));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.125"), 106, 90, 205));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.126"), 112, 128, 144));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.127"), 255, 250, 250));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.128"), 0, 255, 127));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.129"), 70, 130, 180));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.130"), 210, 180, 140));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.131"), 0, 128, 128));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.132"), 216, 191, 216));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.133"), 255, 99, 71));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.134"), 64, 224, 208));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.135"), 238, 130, 238));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.136"), 245, 222, 179));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.137"), 255, 255, 255));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.138"), 245, 245, 245));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.139"), 255, 255, 0));
        colorList.add(new ColorName(I18n.func_74838_a((String)"vc.item.color.140"), 154, 205, 50));
        return colorList;
    }

    public static String getColorNameFromRgb(float r, float g, float b) {
        ArrayList<ColorName> colorList = ColorHelperVC.initColorList();
        ColorName closestMatch = null;
        int minMSE = Integer.MAX_VALUE;
        for (ColorName c : colorList) {
            int mse = c.computeMSE(r, g, b);
            if (mse >= minMSE) continue;
            minMSE = mse;
            closestMatch = c;
        }
        if (closestMatch != null) {
            return closestMatch.getName();
        }
        return "No matched color name.";
    }

    public String getColorNameFromHex(int hexColor) {
        int r = (hexColor & 0xFF0000) >> 16;
        int g = (hexColor & 0xFF00) >> 8;
        int b = hexColor & 0xFF;
        return ColorHelperVC.getColorNameFromRgb(r, g, b);
    }

    public int colorToHex(Color c) {
        return Integer.decode("0x" + Integer.toHexString(c.getRGB()).substring(2));
    }

    public String getColorNameFromColor(Color color) {
        return ColorHelperVC.getColorNameFromRgb(color.getRed(), color.getGreen(), color.getBlue());
    }

    public static class ColorName {
        public int r;
        public int g;
        public int b;
        public String name;

        public ColorName(String name, int r, int g, int b) {
            this.r = r;
            this.g = g;
            this.b = b;
            this.name = name;
        }

        public int computeMSE(float r2, float g2, float b2) {
            return (int)(((r2 - (float)this.r) * (r2 - (float)this.r) + (g2 - (float)this.g) * (g2 - (float)this.g) + (b2 - (float)this.b) * (b2 - (float)this.b)) / 3.0f);
        }

        public int getR() {
            return this.r;
        }

        public int getG() {
            return this.g;
        }

        public int getB() {
            return this.b;
        }

        public String getName() {
            return this.name;
        }
    }
}

