/*
 * Decompiled with CFR 0.152.
 */
package com.viesis.viescraft.client.gui.airship;

import com.viesis.viescraft.api.EnumsVC;
import com.viesis.viescraft.api.References;
import com.viesis.viescraft.common.entity.airships.EntityAirshipBaseVC;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class GuiAirshipHUD
extends Gui {
    private final Minecraft mc = Minecraft.func_71410_x();
    private static FontRenderer fontRenderer;
    private static final ResourceLocation HUD_TEXTURE;
    private final int hudWidth;
    private final int hudHeight;
    private final int fieldWidth;
    private float speedMod;
    private boolean isAirship;
    private EntityAirshipBaseVC airship;

    public GuiAirshipHUD() {
        this.hudWidth = 182;
        this.hudHeight = 40;
        fontRenderer = this.mc.field_71466_p;
        this.fieldWidth = fontRenderer.func_78256_a("000.0") / 2;
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onRenderAirshipBar(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            GuiIngameForge.renderFood = true;
            this.isAirship = this.mc.field_71439_g.func_184187_bx() instanceof EntityAirshipBaseVC;
            if (this.isAirship) {
                this.airship = (EntityAirshipBaseVC)Minecraft.func_71410_x().field_71439_g.func_184187_bx();
                GlStateManager.func_179091_B();
                GlStateManager.func_179147_l();
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                GlStateManager.func_179123_a();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179140_f();
                GlStateManager.func_179141_d();
                GlStateManager.func_179147_l();
                Minecraft.func_71410_x().func_110434_K().func_110577_a(HUD_TEXTURE);
                ScaledResolution sr = new ScaledResolution(this.mc);
                int hudX = sr.func_78326_a() / 2 - this.hudWidth / 2;
                int hudY = 2;
                int textX = hudX + 30;
                int textY = hudY + 22;
                boolean ledX = true;
                this.func_73729_b(hudX, hudY, 0, 0, this.hudWidth, this.hudHeight + 2);
                if (this.airship.getModuleActiveSlot1() == EnumsVC.ModuleType.INFINITE_FUEL_LESSER.getMetadata() || this.airship.getModuleActiveSlot1() == EnumsVC.ModuleType.INFINITE_FUEL_NORMAL.getMetadata() || this.airship.getModuleActiveSlot1() == EnumsVC.ModuleType.INFINITE_FUEL_GREATER.getMetadata()) {
                    this.func_73729_b(hudX + 36, hudY + 31, 36, 72, hudX, 6);
                } else {
                    int fuelbarwidth1 = (int)((float)this.airship.getStoredFuel() / (float)this.airship.getStoredFuelTotal() * 110.0f);
                    this.func_73729_b(hudX + 36, hudY + 31, 36, 59, fuelbarwidth1, 6);
                }
                if (this.airship.getModuleActiveSlot1() == EnumsVC.ModuleType.INFINITE_FUEL_LESSER.getMetadata() || this.airship.getModuleActiveSlot1() == EnumsVC.ModuleType.INFINITE_FUEL_NORMAL.getMetadata() || this.airship.getModuleActiveSlot1() == EnumsVC.ModuleType.INFINITE_FUEL_GREATER.getMetadata()) {
                    this.func_73729_b(hudX + 2, hudY + 14, 2, 66, 177, 6);
                } else {
                    int fuelbarwidth2 = (int)((float)this.airship.getFuelItemStackSizePowered() / 64.0f * 178.0f);
                    this.func_73729_b(hudX + 2, hudY + 14, 2, 53, fuelbarwidth2, 6);
                }
                if (this.airship.getStoredFuel() >= 1) {
                    this.func_73729_b(hudX + 16, hudY, 16, 44, 150, 7);
                }
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)(hudX + 85), (float)(hudY + 2), (float)0.0f);
                GlStateManager.func_179139_a((double)1.5, (double)1.5, (double)1.5);
                if (this.airship.getModuleActiveSlot1() > 0) {
                    this.drawModuleIcon(this.airship.getModuleActiveSlot1());
                }
                GlStateManager.func_179121_F();
                if (this.airship.getModuleActiveSlot1() > 0) {
                    this.func_73729_b(hudX + 83, hudY + 0, 0, 224, 16, 16);
                }
                this.renderHUDAltitude(hudX, hudY);
                this.renderHUDFuelTimer(hudX, hudY);
                GlStateManager.func_179099_b();
            }
        }
    }

    private void drawModuleIcon(int metaIn) {
        if (metaIn == EnumsVC.ModuleType.ALTITUDE_LESSER.getMetadata()) {
            this.func_73729_b(0, 0, 0, 248, 8, 8);
        }
        if (metaIn == EnumsVC.ModuleType.ALTITUDE_NORMAL.getMetadata()) {
            this.func_73729_b(0, 0, 8, 248, 8, 8);
        }
        if (metaIn == EnumsVC.ModuleType.ALTITUDE_GREATER.getMetadata()) {
            this.func_73729_b(0, 0, 16, 248, 8, 8);
        }
        if (metaIn == EnumsVC.ModuleType.SPEED_LESSER.getMetadata()) {
            this.func_73729_b(0, 0, 24, 248, 8, 8);
        }
        if (metaIn == EnumsVC.ModuleType.SPEED_NORMAL.getMetadata()) {
            this.func_73729_b(0, 0, 32, 248, 8, 8);
        }
        if (metaIn == EnumsVC.ModuleType.SPEED_GREATER.getMetadata()) {
            this.func_73729_b(0, 0, 40, 248, 8, 8);
        }
        if (metaIn == EnumsVC.ModuleType.STORAGE_LESSER.getMetadata()) {
            this.func_73729_b(0, 0, 48, 248, 8, 8);
        }
        if (metaIn == EnumsVC.ModuleType.STORAGE_NORMAL.getMetadata()) {
            this.func_73729_b(0, 0, 56, 248, 8, 8);
        }
        if (metaIn == EnumsVC.ModuleType.STORAGE_GREATER.getMetadata()) {
            this.func_73729_b(0, 0, 64, 248, 8, 8);
        }
        if (metaIn == EnumsVC.ModuleType.FUEL_LESSER.getMetadata()) {
            this.func_73729_b(0, 0, 72, 248, 8, 8);
        }
        if (metaIn == EnumsVC.ModuleType.FUEL_NORMAL.getMetadata()) {
            this.func_73729_b(0, 0, 80, 248, 8, 8);
        }
        if (metaIn == EnumsVC.ModuleType.FUEL_GREATER.getMetadata()) {
            this.func_73729_b(0, 0, 88, 248, 8, 8);
        }
        if (metaIn == EnumsVC.ModuleType.MUSIC_LESSER.getMetadata()) {
            this.func_73729_b(0, 0, 96, 248, 8, 8);
        }
        if (metaIn == EnumsVC.ModuleType.MUSIC_NORMAL.getMetadata()) {
            this.func_73729_b(0, 0, 104, 248, 8, 8);
        }
        if (metaIn == EnumsVC.ModuleType.MUSIC_GREATER.getMetadata()) {
            this.func_73729_b(0, 0, 112, 248, 8, 8);
        }
        if (metaIn == EnumsVC.ModuleType.CRUISE_LESSER.getMetadata()) {
            this.func_73729_b(0, 0, 120, 248, 8, 8);
        }
        if (metaIn == EnumsVC.ModuleType.CRUISE_NORMAL.getMetadata()) {
            this.func_73729_b(0, 0, 128, 248, 8, 8);
        }
        if (metaIn == EnumsVC.ModuleType.CRUISE_GREATER.getMetadata()) {
            this.func_73729_b(0, 0, 136, 248, 8, 8);
        }
        if (metaIn == EnumsVC.ModuleType.WATER_LESSER.getMetadata()) {
            this.func_73729_b(0, 0, 144, 248, 8, 8);
        }
        if (metaIn == EnumsVC.ModuleType.WATER_NORMAL.getMetadata()) {
            this.func_73729_b(0, 0, 152, 248, 8, 8);
        }
        if (metaIn == EnumsVC.ModuleType.WATER_GREATER.getMetadata()) {
            this.func_73729_b(0, 0, 160, 248, 8, 8);
        }
        if (metaIn == EnumsVC.ModuleType.INFINITE_FUEL_LESSER.getMetadata()) {
            this.func_73729_b(0, 0, 168, 248, 8, 8);
        }
        if (metaIn == EnumsVC.ModuleType.INFINITE_FUEL_NORMAL.getMetadata()) {
            this.func_73729_b(0, 0, 176, 248, 8, 8);
        }
        if (metaIn == EnumsVC.ModuleType.INFINITE_FUEL_GREATER.getMetadata()) {
            this.func_73729_b(0, 0, 184, 248, 8, 8);
        }
        if (metaIn == EnumsVC.ModuleType.BOMB_LESSER.getMetadata()) {
            this.func_73729_b(0, 0, 192, 248, 8, 8);
        }
        if (metaIn == EnumsVC.ModuleType.BOMB_NORMAL.getMetadata()) {
            this.func_73729_b(0, 0, 200, 248, 8, 8);
        }
        if (metaIn == EnumsVC.ModuleType.BOMB_GREATER.getMetadata()) {
            this.func_73729_b(0, 0, 208, 248, 8, 8);
        }
    }

    private void renderHUDAltitude(int hudXIn, int hudYIn) {
        if (this.airship.getModuleActiveSlot1() == EnumsVC.ModuleType.ALTITUDE_LESSER.getMetadata() || this.airship.getModuleActiveSlot1() == EnumsVC.ModuleType.ALTITUDE_NORMAL.getMetadata() || this.airship.getModuleActiveSlot1() == EnumsVC.ModuleType.ALTITUDE_GREATER.getMetadata()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(hudXIn + 74), (float)(hudYIn + 6), (float)0.0f);
            GlStateManager.func_179139_a((double)0.75, (double)0.75, (double)0.75);
            this.func_73732_a(fontRenderer, Integer.toString(this.airship.func_180425_c().func_177956_o()), 0, 0, 60155);
            GlStateManager.func_179121_F();
        } else if (this.airship.func_180425_c().func_177956_o() >= EnumsVC.MainTierBalloon.byId(this.airship.getMainTierBalloon()).getMaxAltitude() - 5) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(hudXIn + 74), (float)(hudYIn + 6), (float)0.0f);
            GlStateManager.func_179139_a((double)0.75, (double)0.75, (double)0.75);
            this.func_73732_a(fontRenderer, Integer.toString(this.airship.func_180425_c().func_177956_o()), 0, 0, 0xFF0000);
            GlStateManager.func_179121_F();
        } else if (this.airship.func_180425_c().func_177956_o() >= EnumsVC.MainTierBalloon.byId(this.airship.getMainTierBalloon()).getMaxAltitude() - 15) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(hudXIn + 74), (float)(hudYIn + 6), (float)0.0f);
            GlStateManager.func_179139_a((double)0.75, (double)0.75, (double)0.75);
            this.func_73732_a(fontRenderer, Integer.toString(this.airship.func_180425_c().func_177956_o()), 0, 0, 0xF6FF00);
            GlStateManager.func_179121_F();
        } else {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(hudXIn + 74), (float)(hudYIn + 6), (float)0.0f);
            GlStateManager.func_179139_a((double)0.75, (double)0.75, (double)0.75);
            this.func_73732_a(fontRenderer, Integer.toString(this.airship.func_180425_c().func_177956_o()), 0, 0, 196352);
            GlStateManager.func_179121_F();
        }
        if (this.airship.getModuleActiveSlot1() == EnumsVC.ModuleType.ALTITUDE_LESSER.getMetadata() || this.airship.getModuleActiveSlot1() == EnumsVC.ModuleType.ALTITUDE_NORMAL.getMetadata() || this.airship.getModuleActiveSlot1() == EnumsVC.ModuleType.ALTITUDE_GREATER.getMetadata()) {
            if (this.airship.getModuleActiveSlot1() == EnumsVC.ModuleType.ALTITUDE_LESSER.getMetadata()) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)((double)hudXIn + 108.5), (double)(hudYIn + 6), (double)0.0);
                GlStateManager.func_179139_a((double)0.75, (double)0.75, (double)0.75);
                this.func_73732_a(fontRenderer, "225", 0, 0, 60155);
                GlStateManager.func_179121_F();
            } else if (this.airship.getModuleActiveSlot1() == EnumsVC.ModuleType.ALTITUDE_NORMAL.getMetadata()) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)((double)hudXIn + 108.5), (double)(hudYIn + 6), (double)0.0);
                GlStateManager.func_179139_a((double)0.75, (double)0.75, (double)0.75);
                this.func_73732_a(fontRenderer, "250", 0, 0, 60155);
                GlStateManager.func_179121_F();
            } else if (this.airship.getModuleActiveSlot1() == EnumsVC.ModuleType.ALTITUDE_GREATER.getMetadata()) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)((double)hudXIn + 108.5), (double)(hudYIn + 6), (double)0.0);
                GlStateManager.func_179139_a((double)0.75, (double)0.75, (double)0.75);
                this.func_73732_a(fontRenderer, "\u221e", 0, 0, 60155);
                GlStateManager.func_179121_F();
            }
        } else if (this.airship.func_180425_c().func_177956_o() >= EnumsVC.MainTierBalloon.byId(this.airship.getMainTierBalloon()).getMaxAltitude() - 5) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)((double)hudXIn + 108.5), (double)(hudYIn + 6), (double)0.0);
            GlStateManager.func_179139_a((double)0.75, (double)0.75, (double)0.75);
            this.func_73732_a(fontRenderer, Integer.toString(EnumsVC.MainTierBalloon.byId(this.airship.getMainTierBalloon()).getMaxAltitude()), 0, 0, 0xFF0000);
            GlStateManager.func_179121_F();
        } else if (this.airship.func_180425_c().func_177956_o() >= EnumsVC.MainTierBalloon.byId(this.airship.getMainTierBalloon()).getMaxAltitude() - 15) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)((double)hudXIn + 108.5), (double)(hudYIn + 6), (double)0.0);
            GlStateManager.func_179139_a((double)0.75, (double)0.75, (double)0.75);
            this.func_73732_a(fontRenderer, Integer.toString(EnumsVC.MainTierBalloon.byId(this.airship.getMainTierBalloon()).getMaxAltitude()), 0, 0, 0xF6FF00);
            GlStateManager.func_179121_F();
        } else {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)((double)hudXIn + 108.5), (double)(hudYIn + 6), (double)0.0);
            GlStateManager.func_179139_a((double)0.75, (double)0.75, (double)0.75);
            this.func_73732_a(fontRenderer, Integer.toString(EnumsVC.MainTierBalloon.byId(this.airship.getMainTierBalloon()).getMaxAltitude()), 0, 0, 196352);
            GlStateManager.func_179121_F();
        }
    }

    private void renderHUDFuelTimer(int hudXIn, int hudYIn) {
        int timer = this.airship.airshipFuelTick == 0 ? (this.airship.getStoredFuel() / 10 + 18 + this.airship.getFuelItemStackPowered() / 10) / 20 : (this.airship.getStoredFuel() / this.airship.airshipFuelTick + 18 + this.airship.getFuelItemStackPowered() / this.airship.airshipFuelTick) / 20;
        int remainder = timer % 3600;
        int minutes = remainder / 60;
        int seconds = remainder % 60;
        int hours = timer / 3600;
        String hrs = (hours < 10 ? "0" : "") + hours;
        String mins = (minutes < 10 ? "0" : "") + minutes;
        String secs = (seconds < 10 ? "0" : "") + seconds;
        if (this.airship.getModuleActiveSlot1() == EnumsVC.ModuleType.INFINITE_FUEL_LESSER.getMetadata() || this.airship.getModuleActiveSlot1() == EnumsVC.ModuleType.INFINITE_FUEL_NORMAL.getMetadata() || this.airship.getModuleActiveSlot1() == EnumsVC.ModuleType.INFINITE_FUEL_GREATER.getMetadata()) {
            String s1 = "\u221e:\u221e:\u221e";
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(hudXIn + 91), (double)((double)hudYIn + 22.5), (double)0.0);
            GlStateManager.func_179139_a((double)0.75, (double)0.75, (double)0.75);
            this.func_73732_a(fontRenderer, s1, 0, 0, 196352);
            GlStateManager.func_179121_F();
        } else {
            String s = hrs + ":" + mins + ":" + secs;
            String s2 = "*" + References.localNameVC("vc.hud.nofuel") + "*";
            if (hours > 0) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)((double)hudXIn + 91.5), (double)(hudYIn + 23), (double)0.0);
                GlStateManager.func_179139_a((double)0.75, (double)0.75, (double)0.75);
                this.func_73732_a(fontRenderer, s, 0, 0, 60155);
                GlStateManager.func_179121_F();
            } else if (minutes >= 15 && seconds >= 0) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)((double)hudXIn + 91.5), (double)(hudYIn + 23), (double)0.0);
                GlStateManager.func_179139_a((double)0.75, (double)0.75, (double)0.75);
                this.func_73732_a(fontRenderer, s, 0, 0, 60155);
                GlStateManager.func_179121_F();
            } else if (minutes >= 5 && seconds >= 0) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)((double)hudXIn + 91.5), (double)(hudYIn + 23), (double)0.0);
                GlStateManager.func_179139_a((double)0.75, (double)0.75, (double)0.75);
                this.func_73732_a(fontRenderer, s, 0, 0, 1571584);
                GlStateManager.func_179121_F();
            } else if (minutes >= 2 && seconds >= 0) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)((double)hudXIn + 91.5), (double)(hudYIn + 23), (double)0.0);
                GlStateManager.func_179139_a((double)0.75, (double)0.75, (double)0.75);
                this.func_73732_a(fontRenderer, s, 0, 0, 15596288);
                GlStateManager.func_179121_F();
            } else if (minutes >= 1 && seconds >= 0) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)((double)hudXIn + 91.5), (double)(hudYIn + 23), (double)0.0);
                GlStateManager.func_179139_a((double)0.75, (double)0.75, (double)0.75);
                this.func_73732_a(fontRenderer, s, 0, 0, 16493312);
                GlStateManager.func_179121_F();
            } else if (seconds >= 1) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)((double)hudXIn + 91.5), (double)(hudYIn + 23), (double)0.0);
                GlStateManager.func_179139_a((double)0.75, (double)0.75, (double)0.75);
                this.func_73732_a(fontRenderer, s, 0, 0, 0xFB0000);
                GlStateManager.func_179121_F();
            } else if (seconds >= 0) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)(hudXIn + 91), (float)(hudYIn + 23), (float)0.0f);
                GlStateManager.func_179139_a((double)0.75, (double)0.75, (double)0.75);
                this.func_73732_a(fontRenderer, s2, 0, 0, 0xFB0000);
                GlStateManager.func_179121_F();
            }
        }
    }

    static {
        HUD_TEXTURE = new ResourceLocation("vc", "textures/gui/viescraft_hud.png");
    }
}

