/*
 * Decompiled with CFR 0.152.
 */
package knightminer.animalcrops;

import knightminer.animalcrops.blocks.BlockAnimalBush;
import knightminer.animalcrops.blocks.BlockAnimalCrops;
import knightminer.animalcrops.blocks.BlockAnimalLily;
import knightminer.animalcrops.core.CommonProxy;
import knightminer.animalcrops.core.Config;
import knightminer.animalcrops.core.Utils;
import knightminer.animalcrops.items.ItemAnimalLily;
import knightminer.animalcrops.items.ItemAnimalSeeds;
import knightminer.animalcrops.tileentity.TileAnimalCrops;
import knightminer.animalcrops.world.WorldGenAnimalCrops;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="animalcrops", version="1.12.2-0.2.0", name="AnimalCrops", dependencies="required-after:forge@[14.23.1.2594,);", acceptedMinecraftVersions="[1.12.2]")
public class AnimalCrops {
    public static final String name = "AnimalCrops";
    public static final String modID = "animalcrops";
    public static final String version = "1.12.2-0.2.0";
    @SidedProxy(clientSide="knightminer.animalcrops.core.ClientProxy", serverSide="knightminer.animalcrops.core.CommonProxy")
    public static CommonProxy proxy;
    public static Block crops;
    public static Block lily;
    public static Block bush;
    public static ItemAnimalSeeds seeds;
    public static ItemAnimalSeeds lilySeeds;
    public static ItemBlock itemBush;
    public static final Logger log;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Config.preInit(event);
        proxy.preInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        Config.init(event);
        Utils.initReflection();
        if (Config.animalBush && Config.animalBushChance > 0) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenAnimalCrops(), (int)25);
        }
        proxy.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit();
    }

    static {
        log = LogManager.getLogger((String)modID);
    }

    @Mod.EventBusSubscriber(modid="animalcrops")
    public static class Registration {
        @SubscribeEvent
        public static void registerBlocks(RegistryEvent.Register<Block> event) {
            crops = new BlockAnimalCrops();
            crops.setRegistryName(new ResourceLocation(AnimalCrops.modID, "crops"));
            crops.func_149663_c("animalcrops.crops");
            event.getRegistry().register((IForgeRegistryEntry)crops);
            lily = new BlockAnimalLily();
            lily.setRegistryName(new ResourceLocation(AnimalCrops.modID, "lily"));
            lily.func_149663_c("animalcrops.lily");
            event.getRegistry().register((IForgeRegistryEntry)lily);
            if (Config.animalBush) {
                bush = new BlockAnimalBush();
                bush.setRegistryName(new ResourceLocation(AnimalCrops.modID, "bush"));
                bush.func_149663_c("animalcrops.bush");
                event.getRegistry().register((IForgeRegistryEntry)bush);
            }
            GameRegistry.registerTileEntity(TileAnimalCrops.class, (String)"animalcrops:crops");
        }

        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> event) {
            seeds = new ItemAnimalSeeds(crops);
            seeds.setRegistryName(new ResourceLocation(AnimalCrops.modID, "seeds"));
            seeds.func_77655_b("animalcrops.seeds");
            event.getRegistry().register((IForgeRegistryEntry)seeds);
            lilySeeds = new ItemAnimalLily(lily);
            lilySeeds.setRegistryName(new ResourceLocation(AnimalCrops.modID, "lily"));
            lilySeeds.func_77655_b("animalcrops.lily");
            event.getRegistry().register((IForgeRegistryEntry)lilySeeds);
            if (Config.animalBush) {
                itemBush = new ItemBlock(bush);
                itemBush.setRegistryName(bush.getRegistryName());
                itemBush.func_77655_b(bush.func_149739_a());
                event.getRegistry().register((IForgeRegistryEntry)itemBush);
            }
        }
    }
}

