/*
 * Decompiled with CFR 0.152.
 */
package knightminer.animalcrops.blocks;

import java.util.Arrays;
import java.util.List;
import knightminer.animalcrops.AnimalCrops;
import knightminer.animalcrops.core.Config;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IShearable;

public class BlockAnimalBush
extends BlockBush
implements IShearable {
    protected static final AxisAlignedBB BOUNDS = new AxisAlignedBB(0.01, 0.0, 0.01, 0.9, 1.0, 0.9);

    public BlockAnimalBush() {
        super(Material.field_151582_l);
        this.func_149711_c(0.0f);
        this.func_149672_a(SoundType.field_185850_c);
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Plains;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDS;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        int crops = Config.animals.size();
        int count = crops + Config.seaAnimals.size();
        if (count > 0) {
            int index = RANDOM.nextInt(count);
            if (index >= crops) {
                drops.add((Object)AnimalCrops.lilySeeds.makeSeed(Config.seaAnimals.get(index - crops)));
            } else {
                drops.add((Object)AnimalCrops.seeds.makeSeed(Config.animals.get(index)));
            }
        }
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        return Arrays.asList(new ItemStack((Block)this));
    }
}

