/*
 * Decompiled with CFR 0.152.
 */
package knightminer.animalcrops.blocks;

import java.util.Random;
import javax.annotation.Nonnull;
import knightminer.animalcrops.AnimalCrops;
import knightminer.animalcrops.core.Config;
import knightminer.animalcrops.core.Utils;
import knightminer.animalcrops.items.ItemAnimalSeeds;
import knightminer.animalcrops.tileentity.TileAnimalCrops;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockAnimalCrops
extends BlockCrops
implements ITileEntityProvider {
    public BlockAnimalCrops() {
        this.field_149758_A = true;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileAnimalCrops();
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileAnimalCrops) {
            ((TileAnimalCrops)te).setAnimal(Utils.getEntityID(stack.func_77978_p()));
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileAnimalCrops) {
            if (this.func_185527_x(state) >= this.func_185526_g()) {
                ((TileAnimalCrops)te).spawnAnimal();
            } else {
                ((TileAnimalCrops)te).setDead();
            }
        }
        super.func_180663_b(world, pos, state);
    }

    @Nonnull
    public ItemStack getPickBlock(@Nonnull IBlockState state, RayTraceResult target, @Nonnull World world, @Nonnull BlockPos pos, EntityPlayer player) {
        return this.getSeedItem((IBlockAccess)world, pos);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        if (this.func_185527_x(state) < this.func_185526_g() || Config.seedDropChance > 0 && RANDOM.nextInt(Config.seedDropChance) == 0) {
            drops.add((Object)this.getSeedItem(world, pos));
        }
    }

    private ItemStack getSeedItem(IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileAnimalCrops) {
            return this.getSeed().makeSeed(Utils.getEntityID(((TileAnimalCrops)te).getTileData()));
        }
        return new ItemStack((Item)this.getSeed());
    }

    public boolean removedByPlayer(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player, boolean willHarvest) {
        this.func_176206_d(world, pos, state);
        if (willHarvest) {
            this.func_180657_a(world, player, pos, state, world.func_175625_s(pos), player.func_184614_ca());
        }
        world.func_175698_g(pos);
        return false;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (Config.rightClickHarvest && this.func_185527_x(state) >= this.func_185526_g()) {
            if (!world.field_72995_K && Config.seedDropChance > 0 && RANDOM.nextInt(Config.seedDropChance) == 0) {
                TileEntity te = world.func_175625_s(pos);
                if (te instanceof TileAnimalCrops) {
                    ((TileAnimalCrops)te).spawnAndReset();
                }
                world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)state));
                world.func_175656_a(pos, state.func_177226_a((IProperty)field_176488_a, (Comparable)Integer.valueOf(0)));
            } else {
                world.func_175655_b(pos, false);
            }
            return true;
        }
        return false;
    }

    protected boolean func_185514_i(IBlockState state) {
        return state.func_177230_c() instanceof BlockGrass;
    }

    public boolean func_180671_f(World world, BlockPos pos, IBlockState state) {
        return (world.func_175699_k(pos) >= 8 || world.func_175678_i(pos)) && this.func_185514_i(world.func_180495_p(pos.func_177977_b()));
    }

    protected Item func_149865_P() {
        return Items.field_190931_a;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return Config.canBonemeal;
    }

    protected ItemAnimalSeeds getSeed() {
        return AnimalCrops.seeds;
    }

    protected int func_185529_b(World worldIn) {
        return MathHelper.func_76136_a((Random)worldIn.field_73012_v, (int)1, (int)3);
    }
}

