/*
 * Decompiled with CFR 0.152.
 */
package knightminer.animalcrops.core;

import java.util.Map;
import javax.annotation.Nonnull;
import knightminer.animalcrops.AnimalCrops;
import knightminer.animalcrops.client.RenderAnimalCrops;
import knightminer.animalcrops.core.CommonProxy;
import knightminer.animalcrops.core.Config;
import knightminer.animalcrops.core.Utils;
import knightminer.animalcrops.tileentity.TileAnimalCrops;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.EntityList;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ClientProxy
extends CommonProxy {
    private static final ResourceLocation CROPS_EGG = new ResourceLocation("animalcrops", "crops_egg");
    private static final ResourceLocation LILY_EGG = new ResourceLocation("animalcrops", "lily_egg");

    @Override
    public void preInit() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        ClientProxy.registerItemModel((Item)AnimalCrops.seeds);
        ClientProxy.registerItemModel((Item)AnimalCrops.lilySeeds);
        ClientProxy.registerItemModel((Item)AnimalCrops.itemBush);
        if (Config.fancyCropRendering) {
            ClientRegistry.bindTileEntitySpecialRenderer(TileAnimalCrops.class, (TileEntitySpecialRenderer)new RenderAnimalCrops());
        } else {
            ModelLoader.setCustomStateMapper((Block)AnimalCrops.crops, (IStateMapper)new NameStateMapper(CROPS_EGG));
            ModelLoader.setCustomStateMapper((Block)AnimalCrops.lily, (IStateMapper)new NameStateMapper(LILY_EGG));
        }
    }

    private static void registerItemModel(Item item) {
        if (item != null) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
        }
    }

    private static int getEggColor(NBTTagCompound tags, int index) {
        EntityList.EntityEggInfo egg = (EntityList.EntityEggInfo)EntityList.field_75627_a.get(Utils.getEntityID(tags));
        if (egg != null) {
            return index == 0 ? egg.field_75611_b : egg.field_75612_c;
        }
        return -1;
    }

    @SubscribeEvent
    public void registerBlockColors(ColorHandlerEvent.Block event) {
        if (!Config.fancyCropRendering) {
            event.getBlockColors().func_186722_a((state, world, pos, index) -> {
                TileEntity te;
                if ((index == 0 || index == 1) && (Integer)state.func_177229_b((IProperty)BlockCrops.field_176488_a) > 1 && (te = world.func_175625_s(pos)) instanceof TileAnimalCrops) {
                    return ClientProxy.getEggColor(te.getTileData(), index);
                }
                return -1;
            }, new Block[]{AnimalCrops.crops, AnimalCrops.lily});
        }
    }

    @SubscribeEvent
    public void registerItemColors(ColorHandlerEvent.Item event) {
        event.getItemColors().func_186730_a((stack, index) -> {
            if (index == 0 || index == 1) {
                return ClientProxy.getEggColor(stack.func_77978_p(), index);
            }
            return -1;
        }, new Item[]{AnimalCrops.seeds, AnimalCrops.lilySeeds});
    }

    public class NameStateMapper
    extends StateMapperBase {
        private ResourceLocation name;

        public NameStateMapper(ResourceLocation name) {
            this.name = name;
        }

        @Nonnull
        protected ModelResourceLocation func_178132_a(@Nonnull IBlockState state) {
            return new ModelResourceLocation(this.name, this.func_178131_a((Map)state.func_177228_b()));
        }
    }
}

