/*
 * Decompiled with CFR 0.152.
 */
package knightminer.animalcrops.core;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import knightminer.animalcrops.AnimalCrops;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public abstract class Utils {
    public static final String ENTITY_TAG = "entity";
    private static Method setSlimeSize;

    private Utils() {
    }

    public static ResourceLocation getEntityID(NBTTagCompound tags) {
        if (tags == null) {
            return null;
        }
        if (!tags.func_150297_b(ENTITY_TAG, 8)) {
            return null;
        }
        String entityID = tags.func_74779_i(ENTITY_TAG);
        ResourceLocation loc = new ResourceLocation(entityID);
        if (!entityID.contains(":")) {
            tags.func_74778_a(ENTITY_TAG, loc.toString());
        }
        return loc;
    }

    public static void initReflection() {
        try {
            setSlimeSize = ReflectionHelper.findMethod(EntitySlime.class, (String)"setSlimeSize", (String)"func_70799_a", (Class[])new Class[]{Integer.TYPE, Boolean.TYPE});
        }
        catch (ReflectionHelper.UnableToFindMethodException ex) {
            AnimalCrops.log.error("Exception finding EntitySlime::setSlimeSize", (Throwable)ex);
        }
    }

    public static void setSlimeSize(EntitySlime slime, int size) {
        if (setSlimeSize == null) {
            return;
        }
        try {
            setSlimeSize.invoke((Object)slime, size, true);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            AnimalCrops.log.error("Caught exception trying to set slime size", (Throwable)ex);
        }
    }
}

