/*
 * Decompiled with CFR 0.152.
 */
package knightminer.animalcrops.tileentity;

import javax.annotation.Nonnull;
import knightminer.animalcrops.AnimalCrops;
import knightminer.animalcrops.core.Config;
import knightminer.animalcrops.core.Utils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class TileAnimalCrops
extends TileEntity {
    public static final String ENTITY_DATA_TAG = "entity_data";
    private EntityLiving entity;

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    private boolean entityValid(ResourceLocation entityID) {
        return Config.seaAnimals.contains(entityID) || Config.animals.contains(entityID);
    }

    public EntityLiving getEntity(boolean updateNBT) {
        if (this.entity != null) {
            return this.entity;
        }
        NBTTagCompound data = this.getTileData();
        if (data.func_150297_b("entity", 8)) {
            EntitySlime slime;
            block11: {
                ResourceLocation entityID = new ResourceLocation(data.func_74779_i("entity"));
                if (!this.entityValid(entityID)) {
                    if (updateNBT) {
                        this.clearEntity(true);
                    }
                    return null;
                }
                Entity entityFromName = EntityList.func_188429_b((ResourceLocation)entityID, (World)this.field_145850_b);
                if (!(entityFromName instanceof EntityLiving)) {
                    entityFromName.func_70106_y();
                    this.clearEntity(true);
                    return null;
                }
                this.entity = (EntityLiving)entityFromName;
                if (data.func_150297_b(ENTITY_DATA_TAG, 10)) {
                    NBTTagCompound entityData = data.func_74775_l(ENTITY_DATA_TAG);
                    try {
                        this.entity.func_70020_e(entityData);
                        this.entity.field_70758_at = this.entity.field_70126_B = this.entity.field_70177_z;
                        this.entity.field_70760_ar = this.entity.field_70126_B;
                        return this.entity;
                    }
                    catch (Exception ex) {
                        AnimalCrops.log.error("Exception caught loading entity from NBT", (Throwable)ex);
                        if (!updateNBT) break block11;
                        data.func_82580_o(ENTITY_DATA_TAG);
                    }
                }
            }
            if (this.entity instanceof EntityAgeable) {
                ((EntityAgeable)this.entity).func_70873_a(-24000);
            }
            this.entity.func_180482_a(this.field_145850_b.func_175649_E(new BlockPos((Entity)this.entity)), null);
            if (this.entity instanceof EntitySlime && (slime = (EntitySlime)this.entity).func_70809_q() > 2) {
                Utils.setSlimeSize(slime, 2);
            }
            this.entity.field_70759_as = this.entity.field_70177_z = MathHelper.func_76142_g((float)((float)this.field_145850_b.field_73012_v.nextInt(4) * 90.0f));
            this.entity.field_70761_aq = this.entity.field_70177_z;
            if (updateNBT) {
                data.func_74782_a(ENTITY_DATA_TAG, (NBTBase)this.entity.func_189511_e(new NBTTagCompound()));
            }
            this.func_70296_d();
        }
        return this.entity;
    }

    private void clearEntity(boolean clearType) {
        this.entity = null;
        NBTTagCompound data = this.getTileData();
        if (clearType) {
            data.func_82580_o("entity");
        }
        data.func_82580_o(ENTITY_DATA_TAG);
        this.func_70296_d();
    }

    public void setAnimal(ResourceLocation entityID) {
        if (this.field_145850_b.field_72995_K || entityID == null) {
            return;
        }
        if (!this.entityValid(entityID)) {
            return;
        }
        this.getTileData().func_74778_a("entity", entityID.toString());
        if (Config.fancyCropRendering) {
            this.getEntity(true);
        }
        this.func_70296_d();
    }

    public void spawnAnimal() {
        if (this.getEntity(false) == null) {
            return;
        }
        this.entity.func_70107_b((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 0.5);
        this.entity.func_70029_a(this.field_145850_b);
        this.field_145850_b.func_72838_d((Entity)this.entity);
        this.entity.func_70642_aH();
    }

    public void spawnAndReset() {
        this.spawnAnimal();
        this.clearEntity(false);
        if (Config.fancyCropRendering) {
            this.getEntity(true);
            this.func_70296_d();
        }
    }

    public void setDead() {
        if (this.entity != null) {
            this.entity.func_70106_y();
        }
    }

    public void func_145834_a(World world) {
        super.func_145834_a(world);
        if (this.entity != null) {
            this.entity.func_70029_a(world);
        }
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = this.func_189515_b(new NBTTagCompound());
        return new SPacketUpdateTileEntity(this.func_174877_v(), this.func_145832_p(), tag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        NBTTagCompound tag = pkt.func_148857_g();
        this.func_145839_a(tag);
    }
}

