/*
 * Decompiled with CFR 0.152.
 */
package xt9.deepmoblearning.common.entity;

import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import xt9.deepmoblearning.DeepMobLearning;
import xt9.deepmoblearning.common.Registry;

public class EntityItemGlitchFragment
extends EntityItem {
    private ThreadLocalRandom rand = ThreadLocalRandom.current();
    private long progress = 0L;

    public EntityItemGlitchFragment(World worldIn) {
        super(worldIn);
    }

    public EntityItemGlitchFragment(World worldIn, double x, double y, double z, ItemStack stack) {
        super(worldIn, x, y, z);
        this.func_92058_a(stack);
        this.func_174867_a(15);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_70090_H()) {
            boolean isValidEntities;
            AxisAlignedBB box = new AxisAlignedBB(this.field_70165_t - 1.0, this.field_70163_u - 1.0, this.field_70161_v - 1.0, this.field_70165_t + 1.0, this.field_70163_u + 1.0, this.field_70161_v + 1.0);
            List goldEntities = this.field_70170_p.func_72872_a(EntityItem.class, box).stream().filter(entityItem -> this.isStackGold(entityItem.func_92059_d())).collect(Collectors.toList());
            List lapisEntities = this.field_70170_p.func_72872_a(EntityItem.class, box).stream().filter(entityItem -> this.isStackLapis(entityItem.func_92059_d())).collect(Collectors.toList());
            List fragmentEntities = this.field_70170_p.func_72872_a(EntityItem.class, box).stream().filter(entityItem -> this.isStackGlitchFragment(entityItem.func_92059_d())).collect(Collectors.toList());
            ++this.progress;
            boolean bl = isValidEntities = goldEntities.size() > 0 && lapisEntities.size() > 0 && fragmentEntities.size() > 0;
            if (this.field_70170_p.field_72995_K) {
                this.spawnFragmentParticles();
                if (isValidEntities) {
                    for (int i = 0; i < 3; ++i) {
                        this.spawnFragmentParticles();
                    }
                }
            }
            if (!isValidEntities) {
                this.progress = 0L;
                return;
            }
            if (!this.field_70170_p.field_72995_K && this.progress >= 35L) {
                EntityItem gold = (EntityItem)goldEntities.get(goldEntities.size() - 1);
                EntityItem lapis = (EntityItem)lapisEntities.get(lapisEntities.size() - 1);
                EntityItem fragment = (EntityItem)fragmentEntities.get(fragmentEntities.size() - 1);
                this.shrink(gold);
                this.shrink(lapis);
                this.shrink(fragment);
                this.spawnIngot();
            }
        }
    }

    private void spawnFragmentParticles() {
        DeepMobLearning.proxy.spawnSmokeParticle(this.field_70170_p, this.field_70165_t + this.rand.nextDouble(-0.25, 0.25), this.field_70163_u + this.rand.nextDouble(-0.1, 0.8), this.field_70161_v + this.rand.nextDouble(-0.25, 0.25), this.rand.nextDouble(-0.08, 0.08), this.rand.nextDouble(-0.08, 0.22), this.rand.nextDouble(-0.08, 0.08), "cyan");
    }

    private void spawnIngot() {
        EntityItem newItem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u + 0.6, this.field_70161_v, new ItemStack((Item)Registry.glitchInfusedIngot, 1));
        newItem.field_70159_w = this.rand.nextDouble(-0.2, 0.2);
        newItem.field_70181_x = 0.0;
        newItem.field_70179_y = this.rand.nextDouble(-0.2, 0.2);
        newItem.func_174869_p();
        this.field_70170_p.func_72838_d((Entity)newItem);
    }

    private void shrink(EntityItem entityItem) {
        entityItem.func_92059_d().func_190918_g(1);
        if (entityItem.func_92059_d().func_190916_E() <= 0) {
            entityItem.func_70106_y();
        }
    }

    private boolean isStackGlitchFragment(ItemStack item) {
        return ItemStack.func_179545_c((ItemStack)item, (ItemStack)new ItemStack((Item)Registry.glitchFragment)) && item.func_190916_E() > 0;
    }

    private boolean isStackGold(ItemStack item) {
        return ItemStack.func_179545_c((ItemStack)item, (ItemStack)new ItemStack(Items.field_151043_k)) && item.func_190916_E() > 0;
    }

    private boolean isStackLapis(ItemStack item) {
        return ItemStack.func_77989_b((ItemStack)item, (ItemStack)new ItemStack(Items.field_151100_aR, item.func_190916_E(), 4)) && item.func_190916_E() > 0;
    }
}

