/*
 * Decompiled with CFR 0.152.
 */
package xt9.deepmoblearning.common.events;

import java.util.Collection;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import xt9.deepmoblearning.common.capabilities.IPlayerTrial;
import xt9.deepmoblearning.common.capabilities.PlayerTrialProvider;
import xt9.deepmoblearning.common.items.ItemDataModel;
import xt9.deepmoblearning.common.items.ItemDeepLearner;
import xt9.deepmoblearning.common.items.ItemGlitchArmor;
import xt9.deepmoblearning.common.items.ItemGlitchSword;
import xt9.deepmoblearning.common.items.ItemTrialKey;
import xt9.deepmoblearning.common.mobmetas.MobMetaData;
import xt9.deepmoblearning.common.tiles.TileEntityTrialKeystone;
import xt9.deepmoblearning.common.trials.TrialFactory;
import xt9.deepmoblearning.common.trials.TrialRuleset;
import xt9.deepmoblearning.common.trials.affix.TrialAffixKey;
import xt9.deepmoblearning.common.util.DataModel;
import xt9.deepmoblearning.common.util.PlayerHelper;
import xt9.deepmoblearning.common.util.TrialKey;

@Mod.EventBusSubscriber
public class EntityDeathHandler {
    public static Integer blacklistCap = 1000;
    public static NonNullList<UUID> killedEntityUUIDBlacklist = NonNullList.func_191196_a();

    @SubscribeEvent
    public static void dropEvent(LivingDropsEvent event) {
        String affixKey;
        EntityLivingBase e = event.getEntityLiving();
        NBTTagCompound eData = e.getEntityData();
        World world = e.func_130014_f_();
        if (eData.func_74764_b("deepmoblearning:tilepos")) {
            event.setCanceled(true);
        } else if (eData.func_74764_b("deepmoblearning:mob_type") && (affixKey = eData.func_74779_i("deepmoblearning:mob_type")).equals("loot_hoarders")) {
            event.getDrops().clear();
            event.getDrops().add(new EntityItem(world, e.field_70165_t, e.field_70163_u, e.field_70161_v, e.func_184586_b(EnumHand.MAIN_HAND)));
        }
    }

    @SubscribeEvent
    public static void entityDeath(LivingDeathEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityDeathHandler.handlePlayerDeath(event);
        } else {
            EntityDeathHandler.handleMobDeath(event);
        }
    }

    private static void handlePlayerDeath(LivingDeathEvent event) {
        TileEntityTrialKeystone keystone;
        EntityPlayer player = (EntityPlayer)event.getEntityLiving();
        IPlayerTrial cap = (IPlayerTrial)player.getCapability(PlayerTrialProvider.PLAYER_TRIAL_CAP, null);
        BlockPos tilePos = BlockPos.func_177969_a((long)cap.getTilePos());
        TileEntity tile = event.getEntityLiving().func_130014_f_().func_175625_s(tilePos);
        if (tile instanceof TileEntityTrialKeystone && (keystone = (TileEntityTrialKeystone)tile).isTrialActive()) {
            keystone.playerDied((EntityPlayerMP)player);
        }
    }

    private static void handleMobDeath(LivingDeathEvent event) {
        if (killedEntityUUIDBlacklist.size() >= blacklistCap) {
            EntityDeathHandler.cullEntityBlacklist();
        }
        if (EntityDeathHandler.isEntityBlacklisted(event.getEntityLiving())) {
            return;
        }
        if (event.getEntityLiving().getEntityData().func_74764_b("deepmoblearning:tilepos")) {
            EntityDeathHandler.handleTrialMobDeath(event);
        }
        if (event.getSource().func_76346_g() instanceof EntityPlayer) {
            EntityDeathHandler.handlePlayerKilledEntity(event);
        }
        killedEntityUUIDBlacklist.add((Object)event.getEntityLiving().func_110124_au());
    }

    private static void cullEntityBlacklist() {
        UUID lastUUID = (UUID)killedEntityUUIDBlacklist.get(killedEntityUUIDBlacklist.size() - 1);
        killedEntityUUIDBlacklist.clear();
        killedEntityUUIDBlacklist.add((Object)lastUUID);
    }

    private static void handleTrialMobDeath(LivingDeathEvent event) {
        TileEntityTrialKeystone keystone;
        Long pos = event.getEntity().getEntityData().func_74763_f("deepmoblearning:tilepos");
        BlockPos tilePos = BlockPos.func_177969_a((long)pos);
        TileEntity tile = event.getEntityLiving().func_130014_f_().func_175625_s(tilePos);
        if (tile instanceof TileEntityTrialKeystone && (keystone = (TileEntityTrialKeystone)tile).isTrialActive()) {
            keystone.catchMobDeath();
        }
    }

    private static void handlePlayerKilledEntity(LivingDeathEvent event) {
        ItemStack sword;
        IPlayerTrial cap;
        EntityPlayerMP player = (EntityPlayerMP)event.getSource().func_76346_g();
        NonNullList inventory = NonNullList.func_191196_a();
        inventory.addAll((Collection)player.field_71071_by.field_70462_a);
        inventory.addAll((Collection)player.field_71071_by.field_184439_c);
        NonNullList<ItemStack> deepLearners = EntityDeathHandler.getDeepLearners((NonNullList<ItemStack>)inventory);
        NonNullList<ItemStack> trialKeys = EntityDeathHandler.getTrialKeys((NonNullList<ItemStack>)inventory);
        NonNullList updatedModels = NonNullList.func_191196_a();
        deepLearners.forEach(stack -> {
            NonNullList<ItemStack> models = EntityDeathHandler.updateAndReturnModels(stack, event, player);
            updatedModels.addAll(models);
        });
        if (updatedModels.size() == 0) {
            return;
        }
        if (ItemGlitchArmor.isSetEquippedByPlayer((EntityPlayer)player) && !(cap = (IPlayerTrial)player.getCapability(PlayerTrialProvider.PLAYER_TRIAL_CAP, null)).isTrialActive()) {
            ItemGlitchArmor.dropPristineMatter(event.getEntityLiving().field_70170_p, event.getEntityLiving().func_180425_c(), (ItemStack)updatedModels.get(0), (EntityPlayer)player);
        }
        if (player.func_184582_a(EntityEquipmentSlot.MAINHAND).func_77973_b() instanceof ItemGlitchSword && !(cap = (IPlayerTrial)player.getCapability(PlayerTrialProvider.PLAYER_TRIAL_CAP, null)).isTrialActive() && ItemGlitchSword.canIncreaseDamage(sword = player.func_184582_a(EntityEquipmentSlot.MAINHAND))) {
            ItemGlitchSword.increaseDamage(sword, player);
        }
        trialKeys.forEach(stack -> EntityDeathHandler.attuneTrialKey(stack, (ItemStack)updatedModels.get(0), event, player));
    }

    private static NonNullList<ItemStack> updateAndReturnModels(ItemStack deepLearner, LivingDeathEvent event, EntityPlayerMP player) {
        NonNullList<ItemStack> deepLearnerItems = ItemDeepLearner.getContainedItems(deepLearner);
        NonNullList result = NonNullList.func_191196_a();
        deepLearnerItems.forEach(stack -> {
            MobMetaData meta;
            if (stack.func_77973_b() instanceof ItemDataModel && (meta = DataModel.getMobMetaData(stack)).entityLivingMatchesMob(event.getEntityLiving())) {
                DataModel.increaseMobKillCount(stack, player);
                result.add(stack);
            }
            ItemDeepLearner.setContainedItems(deepLearner, deepLearnerItems);
        });
        return result;
    }

    private static boolean isEntityBlacklisted(EntityLivingBase entityLiving) {
        return killedEntityUUIDBlacklist.stream().filter(uuid -> uuid.toString().equals(entityLiving.func_110124_au().toString())).collect(Collectors.toList()).size() > 0;
    }

    private static void attuneTrialKey(ItemStack trialKey, ItemStack dataModel, LivingDeathEvent event, EntityPlayerMP player) {
        if (!TrialKey.isAttuned(trialKey) && !dataModel.func_190926_b()) {
            String mobKey = DataModel.getMobKey(dataModel);
            if (TrialFactory.isMobKeyValidForTrial(mobKey)) {
                TrialKey.attune(trialKey, dataModel, player);
                EntityDeathHandler.addAffixes(trialKey, dataModel);
            } else {
                MobMetaData meta = DataModel.getMobMetaData(dataModel);
                PlayerHelper.sendMessage(player, new TextComponentString("Can't attune the " + trialKey.func_82833_r() + ", There is no Trial for: " + meta.getName()));
            }
        }
    }

    private static void addAffixes(ItemStack trialKey, ItemStack dataModel) {
        int numberOfAffixes = TrialRuleset.getNumberOfAffixesPerTier(DataModel.getTier(dataModel));
        NonNullList affixes = NonNullList.func_191196_a();
        for (int i = 0; i < numberOfAffixes; ++i) {
            affixes.add((Object)TrialAffixKey.getRandomKey((NonNullList<String>)affixes));
        }
        TrialKey.setAffixList(trialKey, (NonNullList<String>)affixes);
    }

    private static NonNullList<ItemStack> getTrialKeys(NonNullList<ItemStack> inventory) {
        NonNullList result = NonNullList.func_191196_a();
        inventory.forEach(stack -> {
            if (stack.func_77973_b() instanceof ItemTrialKey) {
                result.add(stack);
            }
        });
        return result;
    }

    private static NonNullList<ItemStack> getDeepLearners(NonNullList<ItemStack> inventory) {
        NonNullList result = NonNullList.func_191196_a();
        inventory.forEach(stack -> {
            if (stack.func_77973_b() instanceof ItemDeepLearner) {
                result.add(stack);
            }
        });
        return result;
    }
}

