/*
 * Decompiled with CFR 0.152.
 */
package xt9.deepmoblearning.common.tiles;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import xt9.deepmoblearning.common.config.Config;
import xt9.deepmoblearning.common.energy.DeepEnergyStorage;
import xt9.deepmoblearning.common.handlers.BaseItemHandler;
import xt9.deepmoblearning.common.handlers.OutputHandler;
import xt9.deepmoblearning.common.handlers.PristineHandler;
import xt9.deepmoblearning.common.items.ItemPristineMatter;
import xt9.deepmoblearning.common.tiles.IGuiTile;
import xt9.deepmoblearning.common.util.MathHelper;
import xt9.deepmoblearning.common.util.Pagination;

public class TileEntityExtractionChamber
extends TileEntity
implements ITickable,
IGuiTile {
    private BaseItemHandler pristine = new PristineHandler();
    private BaseItemHandler output = new OutputHandler(16);
    private DeepEnergyStorage energyStorage = new DeepEnergyStorage(1000000, 25600, 0, 0);
    public boolean isCrafting = false;
    public int energy = 0;
    public int ticks = 0;
    public int percentDone = 0;
    public Pagination pageHandler = new Pagination(0, this.getLootFromPristine().size(), 9);
    private String currentPristineMatter = "";
    public ItemStack resultingItem = ItemStack.field_190927_a;
    public int energyCost = MathHelper.ensureRange(Config.rfCostExtractionChamber.getInt(), 1, 18000);

    public void func_73660_a() {
        ++this.ticks;
        if (!this.field_145850_b.field_72995_K) {
            if (this.pristineChanged()) {
                this.finishCraft(true);
                this.updatePageHandler(0);
                this.currentPristineMatter = ((ItemPristineMatter)this.getPristine().func_77973_b()).getMobKey();
                this.resultingItem = ItemStack.field_190927_a;
                this.updateState();
                return;
            }
            if (!this.isCrafting) {
                if (this.canStartCraft()) {
                    this.isCrafting = true;
                }
            } else {
                if (!this.canContinueCraft()) {
                    this.finishCraft(true);
                    return;
                }
                if (this.hasEnergyForNextTick()) {
                    this.energyStorage.voidEnergy(this.energyCost);
                    ++this.percentDone;
                }
                if (this.ticks % 100 == 0) {
                    this.updateState();
                }
                if (this.percentDone == 50) {
                    this.finishCraft(false);
                }
            }
            this.doStaggeredDiskSave(100);
        }
    }

    public void finishCraft(boolean abort) {
        this.isCrafting = false;
        this.percentDone = 0;
        if (!abort) {
            ItemStack remainder = this.output.setInFirstAvailableSlot(this.resultingItem);
            while (!remainder.func_190926_b()) {
                remainder = this.output.setInFirstAvailableSlot(remainder);
            }
            this.getPristine().func_190918_g(1);
        }
        this.func_70296_d();
        this.updateState();
    }

    public void updatePageHandler(int currentPage) {
        this.pageHandler.update(currentPage, this.getLootFromPristine().size());
    }

    public void updateState() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        this.field_145850_b.func_184138_a(this.func_174877_v(), state, state, 3);
    }

    private boolean canStartCraft() {
        return this.canContinueCraft() && this.canInsertItem();
    }

    private boolean canContinueCraft() {
        return !this.resultingItem.func_190926_b() && this.getPristine().func_77973_b() instanceof ItemPristineMatter;
    }

    public boolean pristineChanged() {
        return !this.getPristine().func_190926_b() && !this.currentPristineMatter.equals(((ItemPristineMatter)this.getPristine().func_77973_b()).getMobKey());
    }

    private boolean hasEnergyForNextTick() {
        return this.energyStorage.getEnergyStored() >= this.energyCost;
    }

    private boolean canInsertItem() {
        return this.output.canInsertItem(this.resultingItem);
    }

    public ItemStack getItemFromList(int index) {
        if (index >= 0 && index < this.getLootFromPristine().size()) {
            return (ItemStack)this.getLootFromPristine().get(index);
        }
        return ItemStack.field_190927_a;
    }

    public NonNullList<ItemStack> getLootFromPristine() {
        ItemStack stack = this.pristine.getStackInSlot(0);
        if (stack.func_77973_b() instanceof ItemPristineMatter) {
            return ((ItemPristineMatter)stack.func_77973_b()).getLootTable();
        }
        return NonNullList.func_191196_a();
    }

    public ItemStack getPristine() {
        return this.pristine.getStackInSlot(0);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 3, this.func_189515_b(new NBTTagCompound()));
    }

    public final NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74782_a("pristine", (NBTBase)this.pristine.serializeNBT());
        compound.func_74782_a("output", (NBTBase)this.output.serializeNBT());
        compound.func_74782_a("pageHandler", this.pageHandler.serializeNBT());
        compound.func_74782_a("resultingItem", (NBTBase)this.resultingItem.serializeNBT());
        compound.func_74757_a("isCrafting", this.isCrafting);
        compound.func_74768_a("crafingProgress", this.percentDone);
        compound.func_74778_a("currentPristine", this.currentPristineMatter);
        this.energyStorage.writeEnergy(compound);
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.pristine.deserializeNBT(compound.func_74775_l("pristine"));
        this.output.deserializeNBT(compound.func_74775_l("output"));
        this.pageHandler.deserializeNBT(compound.func_74775_l("pageHandler"));
        this.resultingItem = new ItemStack(compound.func_74775_l("resultingItem"));
        this.isCrafting = compound.func_150297_b("isCrafting", 1) ? compound.func_74767_n("isCrafting") : this.isCrafting;
        this.percentDone = compound.func_150297_b("crafingProgress", 3) ? compound.func_74762_e("crafingProgress") : 0;
        this.currentPristineMatter = compound.func_150297_b("currentPristine", 8) ? compound.func_74779_i("currentPristine") : "";
        this.energyStorage.readEnergy(compound);
        super.func_145839_a(compound);
    }

    private void doStaggeredDiskSave(int divisor) {
        if (this.ticks % divisor == 0 && this.energy != this.energyStorage.getEnergyStored()) {
            this.energy = this.energyStorage.getEnergyStored();
            this.func_70296_d();
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public boolean hasCapability(Capability capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityEnergy.ENERGY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == null) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)new CombinedInvWrapper(new IItemHandlerModifiable[]{this.pristine, this.output}));
            }
            if (facing == EnumFacing.UP) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.pristine);
            }
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.output);
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.energyStorage);
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public int getGuiID() {
        return 3;
    }
}

