/*
 * Decompiled with CFR 0.152.
 */
package xt9.deepmoblearning.plugins.jei;

import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import xt9.deepmoblearning.common.util.DataModel;
import xt9.deepmoblearning.common.util.Tier;
import xt9.deepmoblearning.plugins.jei.SimulationChamberRecipe;

public class SimulationChamberRecipeWrapper
implements IRecipeWrapper {
    private long ticks = 0L;
    private long lastWorldTime;
    private final ItemStack dataModel;
    private final NonNullList<ItemStack> inputs = NonNullList.func_191196_a();
    private final NonNullList<ItemStack> outputs = NonNullList.func_191196_a();

    public SimulationChamberRecipeWrapper(SimulationChamberRecipe recipe) {
        this.dataModel = recipe.dataModel;
        this.inputs.add((Object)this.dataModel);
        this.inputs.add((Object)recipe.input);
        this.outputs.add((Object)recipe.livingOutput);
        this.outputs.add((Object)recipe.pristineOutput);
    }

    public void getIngredients(@Nonnull IIngredients ingredients) {
        ingredients.setInputs(ItemStack.class, this.inputs);
        ingredients.setOutputs(ItemStack.class, this.outputs);
    }

    private void cycleTier() {
        int currentTier = DataModel.getTier(this.dataModel);
        if (Tier.isMaxTier(currentTier)) {
            DataModel.setTier(this.dataModel, 1);
        } else {
            DataModel.setTier(this.dataModel, currentTier + 1);
        }
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        this.renderPristineChance(minecraft);
        if (this.lastWorldTime == minecraft.field_71441_e.func_82737_E()) {
            return;
        }
        ++this.ticks;
        this.lastWorldTime = minecraft.field_71441_e.func_82737_E();
        if ((float)this.ticks % 30.0f == 0.0f) {
            this.cycleTier();
        }
    }

    public void renderPristineChance(Minecraft minecraft) {
        FontRenderer render = minecraft.field_71466_p;
        String tierName = Tier.getTierName(DataModel.getTier(this.dataModel), false);
        render.func_175063_a(tierName, (float)(70 - render.func_78256_a(tierName)), 30.0f, 0xFFFFFF);
        int pristineChance = DataModel.getPristineChance(this.dataModel);
        String chanceText = pristineChance + "%";
        render.func_175063_a(chanceText, 97.0f, 31.0f, 0xFFFFFF);
    }
}

