/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.reference;

import fi.dy.masa.enderutilities.EnderUtilities;
import gnu.trove.map.hash.TIntIntHashMap;

public class HotKeys {
    public static final String KEYBIND_CATEGORY_ENDERUTILITIES = "category.enderutilities";
    public static final String KEYBIND_NAME_ACTIVATE_UNSELECTED = "enderutilities.key.activate_unselected";
    public static final String KEYBIND_NAME_TOGGLE_MODE = "enderutilities.key.togglemode";
    public static final int DEFAULT_KEYBIND_ACTIVATE_UNSELECTED = 34;
    public static final int DEFAULT_KEYBIND_TOGGLE_MODE = 34;
    private static final TIntIntHashMap KEY_CODE_MAPPINGS = new TIntIntHashMap(16);
    public static final int BASE_KEY_MASK = 65535;
    public static final int KEYBIND_ID_TOGGLE_MODE = 1;
    public static final int KEYCODE_SCROLL = 4096;
    public static final int KEYCODE_MIDDLE_CLICK = 8192;
    public static final int MOD_NONE = 0;
    public static final int MOD_SHIFT = 65536;
    public static final int MOD_CTRL = 131072;
    public static final int MOD_ALT = 262144;
    public static final int MODIFIER_MASK = 983040;
    public static final int SCROLL_MODIFIER_REVERSE = 0x100000;
    public static final int KEYCODE_SNEAK = 0x1000000;
    public static final int KEYCODE_JUMP = 0x2000000;
    public static final int KEYCODE_CUSTOM_1 = 0x10000000;
    public static final int MOD_SHIFT_CTRL = 196608;
    public static final int MOD_SHIFT_ALT = 327680;
    public static final int MOD_SHIFT_CTRL_ALT = 458752;
    public static final int MOD_CTRL_ALT = 393216;

    public static boolean isModifierKey(int keyCode) {
        return KEY_CODE_MAPPINGS.containsKey(keyCode);
    }

    public static int getModifierMask(int keyCode) {
        return KEY_CODE_MAPPINGS.get(keyCode);
    }

    public static int getActiveModifierMask() {
        int modifier = 0;
        if (EnderUtilities.proxy.isShiftKeyDown()) {
            modifier |= 0x10000;
        }
        if (EnderUtilities.proxy.isControlKeyDown()) {
            modifier |= 0x20000;
        }
        if (EnderUtilities.proxy.isAltKeyDown()) {
            modifier |= 0x40000;
        }
        return modifier;
    }

    static {
        KEY_CODE_MAPPINGS.put(42, 65536);
        KEY_CODE_MAPPINGS.put(54, 65536);
        KEY_CODE_MAPPINGS.put(29, 131072);
        KEY_CODE_MAPPINGS.put(157, 131072);
        KEY_CODE_MAPPINGS.put(56, 262144);
        KEY_CODE_MAPPINGS.put(184, 262144);
    }

    public static enum EnumKey {
        TOGGLE(1),
        SCROLL(4096),
        MIDDLE_CLICK(8192),
        SNEAK(0x1000000),
        JUMP(0x2000000),
        CUSTOM_1(0x10000000);

        private final int keyCode;

        private EnumKey(int keyCode) {
            this.keyCode = keyCode;
        }

        public int getKeyCode() {
            return this.keyCode;
        }

        public static int getBaseKey(int value) {
            return value & 0xFFFF;
        }

        public static int getModifier(int value) {
            return value & 0xF0000;
        }

        public static boolean matches(int value, EnumKey key, int modifier) {
            return EnumKey.getBaseKey(value) == key.keyCode && EnumKey.getModifier(value) == modifier;
        }

        public boolean matches(int value, int modifier) {
            return this.matches(value, modifier, 0);
        }

        public boolean matches(int value, int modRequire, int modIgnore) {
            return EnumKey.getBaseKey(value) == this.keyCode && (EnumKey.getModifier(value) & ~modIgnore) == modRequire;
        }

        public static boolean keypressContainsShift(int value) {
            return (value & 0x10000) != 0;
        }

        public static boolean keypressContainsControl(int value) {
            return (value & 0x20000) != 0;
        }

        public static boolean keypressContainsAlt(int value) {
            return (value & 0x40000) != 0;
        }

        public static boolean keypressActionIsReversed(int value) {
            return (value & 0x100000) != 0;
        }
    }
}

