/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.findme.network;

import com.buuz135.findme.FindMe;
import com.buuz135.findme.network.PositionResponseMessage;
import com.buuz135.findme.proxy.FindMeConfig;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class PositionRequestMessage
implements IMessage {
    private ItemStack stack;

    public PositionRequestMessage(ItemStack stack) {
        this.stack = stack;
    }

    public PositionRequestMessage() {
    }

    public static List<BlockPos> getBlockPosInAABB(AxisAlignedBB axisAlignedBB) {
        ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
        for (double y = axisAlignedBB.field_72338_b; y < axisAlignedBB.field_72337_e; y += 1.0) {
            for (double x = axisAlignedBB.field_72340_a; x < axisAlignedBB.field_72336_d; x += 1.0) {
                for (double z = axisAlignedBB.field_72339_c; z < axisAlignedBB.field_72334_f; z += 1.0) {
                    blocks.add(new BlockPos(x, y, z));
                }
            }
        }
        return blocks;
    }

    public void fromBytes(ByteBuf buf) {
        PacketBuffer packetBuffer = new PacketBuffer(buf);
        this.stack = ItemStack.field_190927_a;
        try {
            this.stack = packetBuffer.func_150791_c();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void toBytes(ByteBuf buf) {
        PacketBuffer packetBuffer = new PacketBuffer(buf);
        packetBuffer.func_150788_a(this.stack);
    }

    public static class Handler
    implements IMessageHandler<PositionRequestMessage, PositionResponseMessage> {
        public PositionResponseMessage onMessage(PositionRequestMessage message, MessageContext ctx) {
            ctx.getServerHandler().field_147369_b.field_70170_p.func_73046_m().func_152344_a(() -> {
                AxisAlignedBB box = new AxisAlignedBB(ctx.getServerHandler().field_147369_b.func_180425_c()).func_186662_g((double)FindMeConfig.RADIUS_RANGE);
                ArrayList<BlockPos> blockPosList = new ArrayList<BlockPos>();
                block0: for (BlockPos blockPos : PositionRequestMessage.getBlockPosInAABB(box)) {
                    IInventory inventory;
                    int i;
                    IItemHandler handler;
                    TileEntity tileEntity = ctx.getServerHandler().field_147369_b.field_70170_p.func_175625_s(blockPos);
                    if (tileEntity == null) continue;
                    if (tileEntity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null) && (handler = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) != null) {
                        for (i = 0; i < handler.getSlots(); ++i) {
                            if (handler.getStackInSlot(i).func_190926_b() || !handler.getStackInSlot(i).func_77969_a(message.stack)) continue;
                            blockPosList.add(blockPos);
                            break;
                        }
                    }
                    if (!(tileEntity instanceof IInventory) || (inventory = (IInventory)tileEntity).func_191420_l()) continue;
                    for (i = 0; i < inventory.func_70302_i_(); ++i) {
                        if (inventory.func_70301_a(i).func_190926_b() || !inventory.func_70301_a(i).func_77969_a(message.stack)) continue;
                        blockPosList.add(blockPos);
                        continue block0;
                    }
                }
                if (!blockPosList.isEmpty()) {
                    FindMe.NETWORK.sendTo((IMessage)new PositionResponseMessage(blockPosList), ctx.getServerHandler().field_147369_b);
                }
            });
            return null;
        }
    }
}

