/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.worldutils;

import fi.dy.masa.worldutils.command.CommandWorldUtils;
import fi.dy.masa.worldutils.config.Configs;
import fi.dy.masa.worldutils.network.PacketHandler;
import fi.dy.masa.worldutils.proxy.IProxy;
import java.io.File;
import net.minecraft.command.ICommand;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="worldutils", name="World Utils", version="0.4.2", certificateFingerprint="2b03e1423915a189b8094816baa18f239d576dff", guiFactory="fi.dy.masa.worldutils.config.WorldUtilsGuiFactory", updateJSON="https://raw.githubusercontent.com/maruohon/worldutils/master/update.json", acceptableRemoteVersions="*", acceptedMinecraftVersions="1.12", dependencies="required-after:forge@[14.21.0.2373,);")
public class WorldUtils {
    @Mod.Instance(value="worldutils")
    public static WorldUtils instance;
    @SidedProxy(clientSide="fi.dy.masa.worldutils.proxy.ClientProxy", serverSide="fi.dy.masa.worldutils.proxy.ServerProxy")
    public static IProxy proxy;
    public static final Logger logger;
    public static String configDirPath;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Configs.loadConfigsFromFile(event.getSuggestedConfigurationFile());
        configDirPath = new File(event.getModConfigurationDirectory(), "worldutils").getAbsolutePath();
        PacketHandler.init();
        proxy.registerKeyBindings();
        proxy.registerEventHandlers();
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandWorldUtils());
    }

    @Mod.EventHandler
    public void onFingerPrintViolation(FMLFingerprintViolationEvent event) {
        if (!event.isDirectory()) {
            logger.warn("*********************************************************************************************");
            logger.warn("*****                                    WARNING                                        *****");
            logger.warn("*****                                                                                   *****");
            logger.warn("*****   The signature of the mod file '{}' does not match the expected fingerprint!     *****", (Object)event.getSource().getName());
            logger.warn("*****   This might mean that the mod file has been tampered with!                       *****");
            logger.warn("*****   If you did not download the mod {} directly from Curse/CurseForge,       *****", (Object)"World Utils");
            logger.warn("*****   or using one of the well known launchers, and you did not                       *****");
            logger.warn("*****   modify the mod file at all yourself, then it's possible,                        *****");
            logger.warn("*****   that it may contain malware or other unwanted things!                           *****");
            logger.warn("*********************************************************************************************");
        }
    }

    static {
        logger = LogManager.getLogger((String)"worldutils");
    }
}

