/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.worldutils.client.renderer.item;

import fi.dy.masa.worldutils.item.ItemChunkWand;
import fi.dy.masa.worldutils.registry.WorldUtilsItems;
import fi.dy.masa.worldutils.util.NBTUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class ChunkWandRenderer {
    protected final Minecraft mc = Minecraft.func_71410_x();
    protected final List<ChunkPos> positionsStored = new ArrayList<ChunkPos>();
    protected float partialTicksLast;

    public void renderSelectedArea(World world, EntityPlayer usingPlayer, ItemStack stack, EntityPlayer clientPlayer, float partialTicks) {
        ItemChunkWand wand = (ItemChunkWand)stack.func_77973_b();
        ItemChunkWand.Mode mode = ItemChunkWand.Mode.getMode(stack);
        if (partialTicks < this.partialTicksLast) {
            this.positionsStored.clear();
            this.positionsStored.addAll(wand.getStoredSelection(stack));
        }
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179140_f();
        GlStateManager.func_179129_p();
        GlStateManager.func_179094_E();
        GlStateManager.func_179090_x();
        ChunkPos posStart = wand.getPosition(stack, ItemChunkWand.Corner.START);
        ChunkPos posEnd = wand.getPosition(stack, ItemChunkWand.Corner.END);
        this.renderChunkOutlines(this.positionsStored, clientPlayer, posStart, posEnd, partialTicks, 0.3f, 1.0f, 0.3f);
        this.renderStartAndEndPositions(mode, clientPlayer, posStart, posEnd, partialTicks);
        GlStateManager.func_179121_F();
        GlStateManager.func_179098_w();
        GlStateManager.func_179089_o();
        GlStateManager.func_179132_a((boolean)true);
        this.partialTicksLast = partialTicks;
    }

    private void renderChunkOutlines(List<ChunkPos> positions, EntityPlayer player, ChunkPos posStart, ChunkPos posEnd, float partialTicks, float red, float green, float blue) {
        GlStateManager.func_187441_d((float)2.0f);
        float expand = 0.0f;
        for (int i = 0; i < positions.size(); ++i) {
            ChunkPos pos = positions.get(i);
            if (pos.equals((Object)posStart) || pos.equals((Object)posEnd)) continue;
            AxisAlignedBB aabb = this.createChunkAABB(pos, expand, partialTicks, player);
            RenderGlobal.func_189697_a((AxisAlignedBB)aabb, (float)red, (float)green, (float)blue, (float)1.0f);
        }
    }

    private void renderStartAndEndPositions(ItemChunkWand.Mode mode, EntityPlayer player, ChunkPos posStart, ChunkPos posEnd, float partialTicks) {
        this.renderStartAndEndPositions(mode, player, posStart, posEnd, partialTicks, 255, 255, 255);
    }

    private void renderStartAndEndPositions(ItemChunkWand.Mode mode, EntityPlayer player, ChunkPos posStart, ChunkPos posEnd, float partialTicks, int r, int g, int b) {
        AxisAlignedBB aabb;
        if (posStart != null && posEnd != null) {
            AxisAlignedBB aabb2 = this.createEnclosingChunkAABB(posStart, posEnd, player, partialTicks);
            RenderGlobal.func_189697_a((AxisAlignedBB)aabb2, (float)((float)r / 255.0f), (float)((float)g / 255.0f), (float)((float)b / 255.0f), (float)0.8f);
        }
        float expand = 0.0f;
        if (posStart != null) {
            GlStateManager.func_187441_d((float)3.0f);
            aabb = this.createChunkAABB(posStart, expand, partialTicks, player);
            RenderGlobal.func_189697_a((AxisAlignedBB)aabb, (float)1.0f, (float)0.2f, (float)0.2f, (float)1.0f);
        }
        if (posEnd != null) {
            GlStateManager.func_187441_d((float)3.0f);
            aabb = this.createChunkAABB(posEnd, expand, partialTicks, player);
            RenderGlobal.func_189697_a((AxisAlignedBB)aabb, (float)0.2f, (float)0.2f, (float)1.0f, (float)1.0f);
        }
    }

    public static void renderText(Minecraft mc, int posX, int posY, List<String> lines) {
        ScaledResolution scaledResolution = new ScaledResolution(mc);
        FontRenderer fontRenderer = mc.field_71466_p;
        int lineHeight = fontRenderer.field_78288_b + 2;
        int y = scaledResolution.func_78328_b() - lineHeight * lines.size();
        y += posY;
        boolean useTextBackground = true;
        boolean useFontShadow = true;
        int textBgColor = Integer.MIN_VALUE;
        for (String line : lines) {
            if (useTextBackground) {
                Gui.func_73734_a((int)(posX - 2), (int)(y - 2), (int)(posX + fontRenderer.func_78256_a(line) + 2), (int)(y + fontRenderer.field_78288_b), (int)textBgColor);
            }
            if (useFontShadow) {
                mc.field_71456_v.func_73731_b(fontRenderer, line, posX, y, -1);
            } else {
                fontRenderer.func_78276_b(line, posX, y, -1);
            }
            y += fontRenderer.field_78288_b + 2;
        }
    }

    public void renderHudChunkWand(EntityPlayer player) {
        ItemStack stack = player.func_184614_ca();
        if (stack.func_190926_b() || stack.func_77973_b() != WorldUtilsItems.CHUNK_WAND) {
            return;
        }
        ArrayList<String> lines = new ArrayList<String>();
        this.getText(lines, stack, player);
        ChunkWandRenderer.renderText(this.mc, 4, -12, lines);
    }

    private void getText(List<String> lines, ItemStack stack, EntityPlayer player) {
        String str;
        int index;
        ItemChunkWand wand = (ItemChunkWand)stack.func_77973_b();
        ItemChunkWand.Mode mode = ItemChunkWand.Mode.getMode(stack);
        String preGreen = TextFormatting.GREEN.toString();
        String rst = TextFormatting.RESET.toString() + TextFormatting.WHITE.toString();
        String preIta = TextFormatting.ITALIC.toString();
        if (mode == ItemChunkWand.Mode.BIOME_SET) {
            index = wand.getBiomeIndex(stack);
            int id = NBTUtils.getCompoundTag(stack, "ChunkWand", true).func_74771_c("BiomeId") & 0xFF;
            str = I18n.func_135052_a((String)"worldutils.tooltip.item.chunkwand.biome", (Object[])new Object[0]);
            Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(wand.getBiomeName(stack)));
            String name = biome != null ? biome.func_185359_l() : "N/A";
            String regName = biome != null ? biome.getRegistryName().toString() : "N/A";
            lines.add(String.format("%s [%s%d/%d%s]: (ID: %d) %s%s (%s) %s", str, preGreen, index + 1, ForgeRegistries.BIOMES.getEntries().size(), rst, id, rst, name, regName, rst));
        } else {
            index = wand.getTargetSelection(stack);
            int max = wand.getNumTargets(stack);
            str = I18n.func_135052_a((String)"worldutils.tooltip.item.chunkwand.targetworld", (Object[])new Object[0]);
            String name = wand.getWorldName(stack);
            lines.add(String.format("%s [%s%d/%d%s]: %s%s%s", str, preGreen, index + 1, max, rst, preIta, name, rst));
        }
        String modeName = mode.getDisplayName();
        str = I18n.func_135052_a((String)"worldutils.tooltip.item.mode", (Object[])new Object[0]);
        String strMode = String.format("%s [%s%d/%d%s]: %s%s%s", str, preGreen, mode.ordinal() + 1, ItemChunkWand.Mode.getModeCount(player), rst, preGreen, modeName, rst);
        lines.add(strMode);
    }

    private int getMaxY(EntityPlayer player) {
        return MathHelper.func_76125_a((int)Math.min((int)player.field_70163_u + 1, 120), (int)1, (int)255);
    }

    private AxisAlignedBB createEnclosingChunkAABB(ChunkPos posStart, ChunkPos posEnd, EntityPlayer player, float partialTicks) {
        int minX = Math.min(posStart.field_77276_a, posEnd.field_77276_a);
        int minZ = Math.min(posStart.field_77275_b, posEnd.field_77275_b);
        int maxX = Math.max(posStart.field_77276_a, posEnd.field_77276_a) + 1;
        int maxZ = Math.max(posStart.field_77275_b, posEnd.field_77275_b) + 1;
        int yMax = this.getMaxY(player);
        return this.createChunkAABB(minX, 0, minZ, maxX, yMax, maxZ, 0.0, partialTicks, player);
    }

    private AxisAlignedBB createChunkAABB(ChunkPos pos, double expand, double partialTicks, EntityPlayer player) {
        return this.createChunkAABB(pos.field_77276_a, pos.field_77275_b, expand, partialTicks, player);
    }

    private AxisAlignedBB createChunkAABB(int chunkX, int chunkZ, double expand, double partialTicks, EntityPlayer player) {
        int yMax = this.getMaxY(player);
        return this.createChunkAABB(chunkX, 0, chunkZ, chunkX + 1, yMax, chunkZ + 1, expand, partialTicks, player);
    }

    private AxisAlignedBB createChunkAABB(int minChunkX, int minY, int minChunkZ, int maxChunkX, int maxY, int maxChunkZ, double expand, double partialTicks, EntityPlayer player) {
        double dx = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * partialTicks;
        double dy = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * partialTicks;
        double dz = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * partialTicks;
        return new AxisAlignedBB((double)(minChunkX * 16) - dx - expand, (double)minY - dy - expand, (double)(minChunkZ * 16) - dz - expand, (double)(maxChunkX * 16) - dx + expand, (double)maxY - dy + expand, (double)(maxChunkZ * 16) - dz + expand);
    }
}

