/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.worldutils.command;

import fi.dy.masa.worldutils.command.CommandWorldUtils;
import fi.dy.masa.worldutils.command.ISubCommand;
import fi.dy.masa.worldutils.util.BlockData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;

public abstract class SubCommand
implements ISubCommand {
    public static final String EMPTY_STRING = "";
    protected final CommandWorldUtils baseCommand;
    protected final ArrayList<String> subSubCommands = new ArrayList();

    public SubCommand(CommandWorldUtils baseCommand) {
        this.baseCommand = baseCommand;
        this.subSubCommands.add("help");
    }

    public CommandWorldUtils getBaseCommand() {
        return this.baseCommand;
    }

    @Override
    public List<String> getSubSubCommands() {
        return this.subSubCommands;
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (this.getSubSubCommands().size() > 1 && args.length == 1 || args.length == 2 && args[0].equals("help")) {
            return CommandBase.func_175762_a((String[])args, this.getSubSubCommands());
        }
        return this.getTabCompletionsSub(server, sender, args, targetPos);
    }

    protected List<String> getTabCompletionsSub(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        return Collections.emptyList();
    }

    @Override
    public void printHelpGeneric(ICommandSender sender) {
        this.sendMessage(sender, "worldutils.commands.help.generic.availablevariants", String.join((CharSequence)", ", this.subSubCommands));
    }

    @Override
    public void printFullHelp(ICommandSender sender, String[] args) {
        this.printHelpGeneric(sender);
    }

    protected String getUsageStringCommon() {
        return "/" + this.getBaseCommand().func_71517_b() + " " + this.getName();
    }

    @Override
    public void execute(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 1) {
            this.printHelpGeneric(sender);
        } else if (args.length == 1) {
            if (args[0].equals("help")) {
                this.printHelpGeneric(sender);
            } else if (!this.subSubCommands.contains(args[0])) {
                SubCommand.throwCommand("worldutils.commands.error.unknowncommandvariant", args[0]);
            }
        } else if (args.length >= 2 && args[0].equals("help")) {
            if (this.subSubCommands.contains(args[1])) {
                this.printFullHelp(sender, SubCommand.dropFirstStrings(args, 1));
            } else {
                SubCommand.throwCommand("worldutils.commands.error.unknowncommandargument", args[1]);
            }
        }
    }

    public static String[] dropFirstStrings(String[] input, int toDrop) {
        return CommandWorldUtils.dropFirstStrings(input, toDrop);
    }

    protected void sendMessage(ICommandSender sender, String message, Object ... params) {
        CommandWorldUtils.sendMessage(sender, message, params);
    }

    public static void throwUsage(String message, Object ... params) throws CommandException {
        CommandWorldUtils.throwUsage(message, params);
    }

    public static void throwNumber(String message, Object ... params) throws CommandException {
        CommandWorldUtils.throwNumber(message, params);
    }

    public static void throwCommand(String message, Object ... params) throws CommandException {
        CommandWorldUtils.throwCommand(message, params);
    }

    protected void printBlockData(String blockStr, ICommandSender sender) throws CommandException {
        BlockData type = BlockData.parseBlockTypeFromString(blockStr);
        if (type != null && type.isValid()) {
            this.sendMessage(sender, "worldutils.commands.blockreplace.block.print.valid", type.toString());
        } else {
            SubCommand.throwCommand("worldutils.commands.blockreplace.block.print.invalid", blockStr);
        }
    }

    protected int getDimension(String usage, String[] args, ICommandSender sender) throws CommandException {
        int dimension;
        int n = dimension = sender instanceof EntityPlayer ? ((EntityPlayer)sender).func_130014_f_().field_73011_w.getDimension() : 0;
        if (args.length == 1) {
            dimension = CommandBase.func_175755_a((String)args[0]);
        } else if (args.length > 1) {
            SubCommand.throwUsage(usage, new Object[0]);
        }
        return dimension;
    }
}

