/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.worldutils.command;

import fi.dy.masa.worldutils.WorldUtils;
import fi.dy.masa.worldutils.command.CommandWorldUtils;
import fi.dy.masa.worldutils.command.SubCommand;
import fi.dy.masa.worldutils.data.BlockTools;
import fi.dy.masa.worldutils.event.tasks.TaskScheduler;
import fi.dy.masa.worldutils.event.tasks.TaskWorldProcessor;
import fi.dy.masa.worldutils.util.BlockData;
import fi.dy.masa.worldutils.util.BlockUtils;
import fi.dy.masa.worldutils.util.RegistryUtils;
import fi.dy.masa.worldutils.util.VanillaBlocks;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class SubCommandBlockReplace
extends SubCommand {
    private static List<String> blockNames = new ArrayList<String>();
    private static List<IBlockState> blockStates = new ArrayList<IBlockState>();
    private static String replacement = "minecraft:air";

    public SubCommandBlockReplace(CommandWorldUtils baseCommand) {
        super(baseCommand);
        this.subSubCommands.add("blocknamelist");
        this.subSubCommands.add("blockstatelist");
        this.subSubCommands.add("execute-all-chunks");
        this.subSubCommands.add("execute-loaded-chunks");
        this.subSubCommands.add("execute-unloaded-chunks");
        this.subSubCommands.add("replacement");
        this.subSubCommands.add("stoptask");
    }

    @Override
    public String getName() {
        return "blockreplace";
    }

    @Override
    public void printHelpGeneric(ICommandSender sender) {
        this.sendMessage(sender, "worldutils.commands.help.generic.runhelpforallcommands", this.getUsageStringCommon() + " help");
    }

    @Override
    public void printFullHelp(ICommandSender sender, String[] args) {
        this.printHelpBlockNameList(sender);
        this.printHelpBlockStateList(sender);
        this.printHelpReplacement(sender);
        sender.func_145747_a((ITextComponent)new TextComponentString(this.getUsageStringCommon() + " execute-all-chunks <keep-listed | replace-listed> [dimension id]"));
        sender.func_145747_a((ITextComponent)new TextComponentString(this.getUsageStringCommon() + " execute-loaded-chunks <keep-listed | replace-listed> [dimension id]"));
        sender.func_145747_a((ITextComponent)new TextComponentString(this.getUsageStringCommon() + " execute-unloaded-chunks <keep-listed | replace-listed> [dimension id]"));
        sender.func_145747_a((ITextComponent)new TextComponentString(this.getUsageStringCommon() + " stoptask"));
    }

    private void printHelpBlockNameList(ICommandSender sender) {
        sender.func_145747_a((ITextComponent)new TextComponentString(this.getUsageStringCommon() + " blocknamelist add <block | id>[@meta] ... Ex: minecraft:ice minecraft:wool@5"));
        sender.func_145747_a((ITextComponent)new TextComponentString(this.getUsageStringCommon() + " blocknamelist add <block[prop1=val1,prop2=val2]> ... Ex: minecraft:stone[variant=granite]"));
        sender.func_145747_a((ITextComponent)new TextComponentString(this.getUsageStringCommon() + " blocknamelist add-all-from-mod <modId> [modId] ..."));
        sender.func_145747_a((ITextComponent)new TextComponentString(this.getUsageStringCommon() + " blocknamelist add-with-spaces <block> (same as add, but for names that include spaces)"));
        sender.func_145747_a((ITextComponent)new TextComponentString(this.getUsageStringCommon() + " blocknamelist add-all-removed-blocks"));
        sender.func_145747_a((ITextComponent)new TextComponentString(this.getUsageStringCommon() + " blocknamelist add-all-removed-blocks-from-mod <modId>"));
        sender.func_145747_a((ITextComponent)new TextComponentString(this.getUsageStringCommon() + " blocknamelist clear"));
        sender.func_145747_a((ITextComponent)new TextComponentString(this.getUsageStringCommon() + " blocknamelist list"));
        sender.func_145747_a((ITextComponent)new TextComponentString(this.getUsageStringCommon() + " blocknamelist remove stringonthelist1 stringonthelist2 ..."));
        sender.func_145747_a((ITextComponent)new TextComponentString(this.getUsageStringCommon() + " blocknamelist remove-with-spaces string parts of the name"));
    }

    private void printHelpBlockStateList(ICommandSender sender) {
        sender.func_145747_a((ITextComponent)new TextComponentString(this.getUsageStringCommon() + " blockstatelist add-all-vanilla <version> (where version = 1.5 ... 1.10)"));
        sender.func_145747_a((ITextComponent)new TextComponentString(this.getUsageStringCommon() + " blockstatelist clear"));
        sender.func_145747_a((ITextComponent)new TextComponentString(this.getUsageStringCommon() + " blockstatelist list"));
    }

    private void printHelpReplacement(ICommandSender sender) {
        sender.func_145747_a((ITextComponent)new TextComponentString(this.getUsageStringCommon() + " replacement set <block | id>[@meta] Ex: minecraft:ice minecraft:wool@5"));
        sender.func_145747_a((ITextComponent)new TextComponentString(this.getUsageStringCommon() + " replacement set <block[prop1=val1,prop2=val2]> Ex: minecraft:stone[variant=granite]"));
        sender.func_145747_a((ITextComponent)new TextComponentString(this.getUsageStringCommon() + " replacement print"));
    }

    @Override
    protected List<String> getTabCompletionsSub(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length < 1) {
            return Collections.emptyList();
        }
        String cmd = args[0];
        args = CommandWorldUtils.dropFirstStrings(args, 1);
        if (cmd.equals("blocknamelist")) {
            if (args.length == 1) {
                return CommandBase.func_71530_a((String[])args, (String[])new String[]{"add", "add-all-from-mod", "add-all-removed-blocks", "add-all-removed-blocks-from-mod", "add-with-spaces", "clear", "list", "remove", "remove-with-spaces"});
            }
            if (args.length >= 2) {
                cmd = args[0];
                if (cmd.equals("add")) {
                    return CommandBase.func_175762_a((String[])args, BlockUtils.getAllBlockNames());
                }
                if (cmd.equals("remove")) {
                    return CommandBase.func_175762_a((String[])args, blockNames);
                }
            }
        } else if (cmd.equals("blockstatelist")) {
            if (args.length == 1) {
                return CommandBase.func_71530_a((String[])args, (String[])new String[]{"add-all-vanilla", "clear", "list"});
            }
        } else {
            if ((cmd.equals("execute-all-chunks") || cmd.equals("execute-loaded-chunks") || cmd.equals("execute-unloaded-chunks")) && args.length == 1) {
                return CommandBase.func_71530_a((String[])args, (String[])new String[]{"keep-listed", "replace-listed"});
            }
            if (cmd.equals("replacement")) {
                if (args.length == 1) {
                    return CommandBase.func_71530_a((String[])args, (String[])new String[]{"print", "set"});
                }
                if (args.length >= 2 && (cmd = args[0]).equals("set")) {
                    ArrayList<String> options = new ArrayList<String>();
                    for (ResourceLocation rl : Block.field_149771_c.func_148742_b()) {
                        options.add(rl.toString());
                    }
                    return CommandBase.func_175762_a((String[])args, options);
                }
            }
        }
        return Collections.emptyList();
    }

    @Override
    public void execute(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 1 || args[0].equals("help")) {
            this.printFullHelp(sender, args);
            return;
        }
        String cmd = args[0];
        args = CommandWorldUtils.dropFirstStrings(args, 1);
        if (cmd.equals("blocknamelist") && args.length >= 1) {
            this.executeBlockNameList(args, sender);
        } else if (cmd.equals("blockstatelist") && args.length >= 1) {
            this.executeBlockStateList(args, sender);
        } else if (cmd.equals("replacement") && args.length >= 1) {
            cmd = args[0];
            args = CommandWorldUtils.dropFirstStrings(args, 1);
            if (cmd.equals("print") && args.length == 0) {
                this.printBlockData(replacement, sender);
            } else if (cmd.equals("set") && args.length >= 1) {
                replacement = String.join((CharSequence)" ", args);
                this.printBlockData(replacement, sender);
            } else {
                this.printHelpReplacement(sender);
            }
        } else if ((cmd.equals("execute-all-chunks") || cmd.equals("execute-loaded-chunks") || cmd.equals("execute-unloaded-chunks")) && args.length >= 1 && args.length <= 2 && (args[0].equals("keep-listed") || args[0].equals("replace-listed"))) {
            String usage = this.getUsageStringCommon() + " " + cmd + " [dimension id]";
            int dimension = this.getDimension(usage, CommandWorldUtils.dropFirstStrings(args, 1), sender);
            boolean keepListedBlocks = args[0].equals("keep-listed");
            BlockTools.LoadedType loaded = BlockTools.LoadedType.UNLOADED;
            if (cmd.equals("execute-all-chunks")) {
                loaded = BlockTools.LoadedType.ALL;
            } else if (cmd.equals("execute-loaded-chunks")) {
                loaded = BlockTools.LoadedType.LOADED;
            }
            this.sendMessage(sender, "worldutils.commands.blockreplace.execute.start", new Object[0]);
            BlockTools.replaceBlocks(dimension, replacement, blockNames, blockStates, keepListedBlocks, loaded, sender);
        } else if (cmd.equals("stoptask")) {
            if (TaskScheduler.getInstance().removeTask(TaskWorldProcessor.class)) {
                this.sendMessage(sender, "worldutils.commands.info.taskstopped", new Object[0]);
            } else {
                SubCommandBlockReplace.throwCommand("worldutils.commands.error.notaskfound", new Object[0]);
            }
        } else {
            this.printFullHelp(sender, args);
        }
    }

    private void executeBlockNameList(String[] args, ICommandSender sender) throws CommandException {
        String cmd = args[0];
        args = CommandWorldUtils.dropFirstStrings(args, 1);
        if (cmd.equals("clear") && args.length == 0) {
            blockNames.clear();
            this.sendMessage(sender, "worldutils.commands.blockreplace.blocknamelist.cleared", new Object[0]);
        } else if (cmd.equals("list") && args.length == 0) {
            WorldUtils.logger.info("----------------------------------");
            WorldUtils.logger.info("  Blocks on the name list:");
            WorldUtils.logger.info("----------------------------------");
            for (String str : blockNames) {
                WorldUtils.logger.info(str);
                sender.func_145747_a((ITextComponent)new TextComponentString(str));
            }
            WorldUtils.logger.info("-------------- END ---------------");
            this.sendMessage(sender, "worldutils.commands.generic.list.print", new Object[0]);
        } else if (cmd.equals("add") && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                this.addBlockNameToListIfValid(args[i], sender);
            }
        } else if (cmd.equals("add-with-spaces") && args.length > 0) {
            this.addBlockNameToListIfValid(String.join((CharSequence)" ", args), sender);
        } else if (cmd.equals("add-all-from-mod") && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                blockNames.addAll(BlockUtils.getAllBlockNamesInMod(args[i]));
                this.sendMessage(sender, "worldutils.commands.blockreplace.blocknamelist.mod.add", args[i]);
            }
        } else if (cmd.equals("add-all-removed-blocks") && args.length == 0) {
            for (ResourceLocation rl : ForgeRegistries.BLOCKS.getKeys()) {
                if (!RegistryUtils.isDummied(ForgeRegistries.BLOCKS, rl)) continue;
                this.addBlockNameToListIfValid(rl.toString(), sender);
            }
        } else if (cmd.equals("add-all-removed-blocks-from-mod") && args.length > 0) {
            for (ResourceLocation rl : ForgeRegistries.BLOCKS.getKeys()) {
                if (!rl.func_110624_b().equals(args[0]) || !RegistryUtils.isDummied(ForgeRegistries.BLOCKS, rl)) continue;
                this.addBlockNameToListIfValid(rl.toString(), sender);
            }
        } else if (cmd.equals("remove") && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                if (blockNames.remove(args[i])) {
                    this.sendMessage(sender, "worldutils.commands.generic.list.remove.success", args[i]);
                    continue;
                }
                this.sendMessage(sender, "worldutils.commands.generic.list.remove.failure", args[i]);
            }
        } else if (cmd.equals("remove-with-spaces") && args.length > 0) {
            String str = String.join((CharSequence)" ", args);
            if (blockNames.remove(str)) {
                this.sendMessage(sender, "worldutils.commands.generic.list.remove.success", str);
            } else {
                this.sendMessage(sender, "worldutils.commands.generic.list.remove.failure", str);
            }
        } else {
            this.printHelpBlockNameList(sender);
        }
    }

    private void executeBlockStateList(String[] args, ICommandSender sender) throws CommandException {
        String cmd = args[0];
        args = CommandWorldUtils.dropFirstStrings(args, 1);
        if (cmd.equals("add-all-vanilla") && args.length > 0) {
            VanillaBlocks.VanillaVersion version = VanillaBlocks.VanillaVersion.fromVersion(args[0]);
            if (version == null) {
                SubCommandBlockReplace.throwCommand("worldutils.commands.error.invalidgameversion", args[0]);
            }
            blockStates.addAll(VanillaBlocks.getSerializableVanillaBlockStatesInVersion(version));
            this.sendMessage(sender, "worldutils.commands.blockreplace.blockstatelist.add", args[0]);
        } else if (cmd.equals("clear") && args.length == 0) {
            blockStates.clear();
            this.sendMessage(sender, "worldutils.commands.blockreplace.blockstatelist.cleared", new Object[0]);
        } else if (cmd.equals("list") && args.length == 0) {
            WorldUtils.logger.info("----------------------------------");
            WorldUtils.logger.info("  Blocks on the IBlockState list:");
            WorldUtils.logger.info("----------------------------------");
            for (IBlockState state : blockStates) {
                WorldUtils.logger.info((Object)state);
            }
            WorldUtils.logger.info("-------------- END ---------------");
            this.sendMessage(sender, "worldutils.commands.blockreplace.blockstatelist.print", new Object[0]);
        } else {
            this.printHelpBlockStateList(sender);
        }
    }

    private void addBlockNameToListIfValid(String name, ICommandSender sender) throws CommandException {
        BlockData type = BlockData.parseBlockTypeFromString(name);
        if (type != null && type.isValid()) {
            blockNames.add(name);
            this.sendMessage(sender, "worldutils.commands.generic.list.add", name + " => " + type.toString());
        } else {
            SubCommandBlockReplace.throwCommand("worldutils.commands.generic.list.add.failure.invalid", name);
        }
    }
}

