/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.worldutils.command;

import fi.dy.masa.worldutils.command.CommandWorldUtils;
import fi.dy.masa.worldutils.command.SubCommand;
import fi.dy.masa.worldutils.data.BlockDump;
import fi.dy.masa.worldutils.data.DataDump;
import java.io.File;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;

public class SubCommandDump
extends SubCommand {
    public SubCommandDump(CommandWorldUtils baseCommand) {
        super(baseCommand);
        this.subSubCommands.add("blocks");
    }

    @Override
    public String getName() {
        return "dump";
    }

    @Override
    public void execute(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        super.execute(server, sender, args);
        if (args.length == 1) {
            File file;
            List<String> data = this.getData(args[0]);
            if (data.isEmpty()) {
                SubCommandDump.throwUsage("worldutils.commands.error.unknowncommandvariant", args[0]);
            }
            if ((file = DataDump.dumpDataToFile(args[0], data)) != null) {
                this.sendMessage(sender, "worldutils.commands.generic.output.to.file", file.getName());
            }
        } else {
            SubCommandDump.throwUsage(this.getUsageStringCommon() + " blocks", new Object[0]);
        }
    }

    protected List<String> getData(String type) {
        if (type.equals("blocks")) {
            return BlockDump.getFormattedBlockDump();
        }
        return null;
    }
}

