/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.worldutils.command;

import fi.dy.masa.worldutils.WorldUtils;
import fi.dy.masa.worldutils.command.CommandWorldUtils;
import fi.dy.masa.worldutils.command.SubCommand;
import fi.dy.masa.worldutils.data.EntityTools;
import fi.dy.masa.worldutils.util.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import org.apache.commons.lang3.tuple.Pair;

public class SubCommandEntities
extends SubCommand {
    private static List<String> removeList = new ArrayList<String>();
    private static List<Pair<String, String>> renamePairs = new ArrayList<Pair<String, String>>();
    private String preparedFrom = "";
    private String preparedTo = "";

    public SubCommandEntities(CommandWorldUtils baseCommand) {
        super(baseCommand);
        this.subSubCommands.add("list-all");
        this.subSubCommands.add("list-duplicates-all");
        this.subSubCommands.add("list-duplicates-only");
        this.subSubCommands.add("read-all");
        this.subSubCommands.add("remove");
        this.subSubCommands.add("remove-duplicate-uuids");
        this.subSubCommands.add("rename");
    }

    @Override
    public String getName() {
        return "entities";
    }

    @Override
    public void printFullHelp(ICommandSender sender, String[] args) {
        this.sendMessage(sender, this.getUsageStringCommon() + " list-all", new Object[0]);
        this.sendMessage(sender, this.getUsageStringCommon() + " list-duplicates-all", new Object[0]);
        this.sendMessage(sender, this.getUsageStringCommon() + " list-duplicates-only", new Object[0]);
        this.sendMessage(sender, this.getUsageStringCommon() + " read-all [dimension id]", new Object[0]);
        this.sendMessage(sender, this.getUsageStringCommon() + " remove-duplicate-uuids [dimension id]", new Object[0]);
        this.printHelpRemove(sender);
        this.printHelpRename(sender);
    }

    private void printHelpRemove(ICommandSender sender) {
        this.sendMessage(sender, this.getUsageStringCommon() + " remove add <name> [name] ...", new Object[0]);
        this.sendMessage(sender, this.getUsageStringCommon() + " remove add-with-spaces <name with spaces>", new Object[0]);
        this.sendMessage(sender, this.getUsageStringCommon() + " remove remove <name> [name] ...", new Object[0]);
        this.sendMessage(sender, this.getUsageStringCommon() + " remove remove-with-spaces <name with spaces>", new Object[0]);
        this.sendMessage(sender, this.getUsageStringCommon() + " remove list", new Object[0]);
        this.sendMessage(sender, this.getUsageStringCommon() + " remove clear", new Object[0]);
        this.sendMessage(sender, this.getUsageStringCommon() + " remove execute-for-entities [dimension id]", new Object[0]);
        this.sendMessage(sender, this.getUsageStringCommon() + " remove execute-for-tileentities [dimension id]", new Object[0]);
    }

    private void printHelpRename(ICommandSender sender) {
        this.sendMessage(sender, this.getUsageStringCommon() + " rename add <name-from> <name-to>", new Object[0]);
        this.sendMessage(sender, this.getUsageStringCommon() + " rename add-prepared", new Object[0]);
        this.sendMessage(sender, this.getUsageStringCommon() + " rename remove <name-from> [name-from] ...", new Object[0]);
        this.sendMessage(sender, this.getUsageStringCommon() + " rename remove-with-spaces <name with spaces>", new Object[0]);
        this.sendMessage(sender, this.getUsageStringCommon() + " rename prepare-from <name with spaces>", new Object[0]);
        this.sendMessage(sender, this.getUsageStringCommon() + " rename prepare-to <name with spaces>", new Object[0]);
        this.sendMessage(sender, this.getUsageStringCommon() + " rename list", new Object[0]);
        this.sendMessage(sender, this.getUsageStringCommon() + " rename clear", new Object[0]);
        this.sendMessage(sender, this.getUsageStringCommon() + " rename execute-for-entities [dimension id]", new Object[0]);
        this.sendMessage(sender, this.getUsageStringCommon() + " rename execute-for-tileentities [dimension id]", new Object[0]);
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length < 1) {
            return Collections.emptyList();
        }
        String cmd = args[0];
        String[] argsOrig = args;
        args = CommandWorldUtils.dropFirstStrings(args, 1);
        if (cmd.equals("remove")) {
            if (args.length == 1) {
                return CommandBase.func_71530_a((String[])args, (String[])new String[]{"add", "add-with-spaces", "clear", "execute-for-entities", "execute-for-tileentities", "list", "remove", "remove-with-spaces"});
            }
            cmd = args[0];
            args = CommandWorldUtils.dropFirstStrings(args, 1);
            if (cmd.equals("remove") && args.length >= 1) {
                return CommandBase.func_175762_a((String[])args, removeList);
            }
        } else if (cmd.equals("rename")) {
            if (args.length == 1) {
                return CommandBase.func_71530_a((String[])args, (String[])new String[]{"add", "add-prepared", "clear", "execute-for-entities", "execute-for-tileentities", "list", "prepare-from", "prepare-to", "remove", "remove-with-spaces"});
            }
            cmd = args[0];
            args = CommandWorldUtils.dropFirstStrings(args, 1);
            if ((cmd.equals("remove") || cmd.equals("remove-with-spaces")) && args.length >= 1) {
                ArrayList<Object> names = new ArrayList<Object>();
                for (Pair<String, String> pair : renamePairs) {
                    names.add(pair.getLeft());
                }
                return CommandBase.func_175762_a((String[])args, names);
            }
        }
        return super.getTabCompletions(server, sender, argsOrig, targetPos);
    }

    @Override
    public void execute(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 1) {
            this.printHelpGeneric(sender);
            return;
        }
        String cmd = args[0];
        args = SubCommandEntities.dropFirstStrings(args, 1);
        if (cmd.equals("help")) {
            this.printFullHelp(sender, args);
        } else if (cmd.equals("list-all")) {
            File file = FileUtils.dumpDataToFile("entities", EntityTools.instance().getAllEntitiesOutput(true));
            if (file != null) {
                this.sendMessage(sender, "worldutils.commands.info.outputtofile", file.getName());
            }
        } else if (cmd.equals("list-duplicates-all") || cmd.equals("list-duplicates-only")) {
            File file = cmd.equals("list-duplicates-all") ? FileUtils.dumpDataToFile("entity_duplicates_all", EntityTools.instance().getDuplicateEntitiesOutput(true, true)) : FileUtils.dumpDataToFile("entity_duplicates_only", EntityTools.instance().getDuplicateEntitiesOutput(false, true));
            if (file != null) {
                this.sendMessage(sender, "worldutils.commands.info.outputtofile", file.getName());
            }
        } else if (cmd.equals("read-all")) {
            String usage = this.getUsageStringCommon() + " " + cmd + " [dimension id]";
            int dimension = this.getDimension(usage, args, sender);
            this.sendMessage(sender, "worldutils.commands.entities.readall.start", new Object[0]);
            EntityTools.instance().readEntities(dimension, sender);
        } else if (cmd.equals("remove-duplicate-uuids")) {
            String usage = this.getUsageStringCommon() + " " + cmd + " [dimension id]";
            int dimension = this.getDimension(usage, args, sender);
            this.sendMessage(sender, "worldutils.commands.entities.removeallduplicates.start", new Object[0]);
            EntityTools.instance().removeAllDuplicateEntities(dimension, sender);
        } else if (cmd.equals("remove")) {
            this.executeRemove(server, sender, args);
        } else if (cmd.equals("rename")) {
            this.executeRename(server, sender, args);
        } else {
            SubCommandEntities.throwCommand("worldutils.commands.error.unknowncommandargument", cmd);
        }
    }

    private void executeRemove(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 1) {
            this.printHelpRemove(sender);
            return;
        }
        String cmd = args[0];
        args = SubCommandEntities.dropFirstStrings(args, 1);
        if (cmd.equals("add")) {
            for (int i = 0; i < args.length; ++i) {
                removeList.add(args[i]);
                this.sendMessage(sender, "worldutils.commands.generic.list.add", args[i]);
            }
        } else if (cmd.equals("add-with-spaces")) {
            String str = String.join((CharSequence)" ", args);
            removeList.add(str);
            this.sendMessage(sender, "worldutils.commands.generic.list.add", str);
        } else if (cmd.equals("clear")) {
            removeList.clear();
            this.sendMessage(sender, "worldutils.commands.generic.list.clear", new Object[0]);
        } else if (cmd.equals("execute-for-entities") || cmd.equals("execute-for-tileentities")) {
            String usage = this.getUsageStringCommon() + " " + cmd + " [dimension id]";
            int dimension = this.getDimension(usage, args, sender);
            EntityTools.EntityRenamer.Type type = cmd.equals("execute-for-tileentities") ? EntityTools.EntityRenamer.Type.TILE_ENTITIES : EntityTools.EntityRenamer.Type.ENTITIES;
            this.sendMessage(sender, "worldutils.commands.entities.remove.start", new Object[0]);
            EntityTools.instance().removeEntities(dimension, removeList, type, sender);
        } else if (cmd.equals("list")) {
            WorldUtils.logger.info("----------------------------------");
            WorldUtils.logger.info("  Names on the remove list:");
            WorldUtils.logger.info("----------------------------------");
            for (String str : removeList) {
                WorldUtils.logger.info(str);
                sender.func_145747_a((ITextComponent)new TextComponentString(str));
            }
            WorldUtils.logger.info("-------------- END ---------------");
            this.sendMessage(sender, "worldutils.commands.generic.list.print", new Object[0]);
        } else if (cmd.equals("remove")) {
            for (int i = 0; i < args.length; ++i) {
                if (removeList.remove(args[i])) {
                    this.sendMessage(sender, "worldutils.commands.generic.list.remove.success", args[i]);
                    continue;
                }
                this.sendMessage(sender, "worldutils.commands.generic.list.remove.failure", args[i]);
            }
        } else if (cmd.equals("remove-with-spaces")) {
            String str = String.join((CharSequence)" ", args);
            if (removeList.remove(str)) {
                this.sendMessage(sender, "worldutils.commands.generic.list.remove.success", str);
            } else {
                this.sendMessage(sender, "worldutils.commands.generic.list.remove.failure", str);
            }
        }
    }

    private void executeRename(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 1) {
            this.printHelpRename(sender);
            return;
        }
        String cmd = args[0];
        args = SubCommandEntities.dropFirstStrings(args, 1);
        if (cmd.equals("add-prepared") || cmd.equals("add") && args.length == 2) {
            String name2;
            String name1;
            if (cmd.equals("add-prepared")) {
                name1 = this.preparedFrom;
                name2 = this.preparedTo;
            } else {
                name1 = args[0];
                name2 = args[1];
            }
            renamePairs.add((Pair<String, String>)Pair.of((Object)name1, (Object)name2));
            this.sendMessage(sender, "worldutils.commands.generic.list.add", name1 + " => " + name2);
        } else if (cmd.equals("prepare-from") && args.length >= 1) {
            this.preparedFrom = String.join((CharSequence)" ", args);
            this.sendMessage(sender, "worldutils.commands.entities.prepare.from", this.preparedFrom);
        } else if (cmd.equals("prepare-to") && args.length >= 1) {
            this.preparedTo = String.join((CharSequence)" ", args);
            this.sendMessage(sender, "worldutils.commands.entities.prepare.to", this.preparedTo);
        } else if (cmd.equals("clear")) {
            renamePairs.clear();
            this.sendMessage(sender, "worldutils.commands.generic.list.clear", new Object[0]);
        } else if (cmd.equals("execute-for-entities") || cmd.equals("execute-for-tileentities")) {
            String usage = this.getUsageStringCommon() + " " + cmd + " [dimension id]";
            int dimension = this.getDimension(usage, args, sender);
            EntityTools.EntityRenamer.Type type = cmd.equals("execute-for-tileentities") ? EntityTools.EntityRenamer.Type.TILE_ENTITIES : EntityTools.EntityRenamer.Type.ENTITIES;
            this.sendMessage(sender, "worldutils.commands.entities.rename.start", new Object[0]);
            EntityTools.instance().renameEntities(dimension, renamePairs, type, sender);
        } else if (cmd.equals("list")) {
            WorldUtils.logger.info("----------------------------------");
            WorldUtils.logger.info("  Names on the rename list:");
            WorldUtils.logger.info("----------------------------------");
            for (Pair<String, String> pair : renamePairs) {
                String str = (String)pair.getLeft() + " => " + (String)pair.getRight();
                WorldUtils.logger.info(str);
                sender.func_145747_a((ITextComponent)new TextComponentString(str));
            }
            WorldUtils.logger.info("-------------- END ---------------");
            this.sendMessage(sender, "worldutils.commands.generic.list.print", new Object[0]);
        } else if (cmd.equals("remove")) {
            for (int a = 0; a < args.length; ++a) {
                int size = renamePairs.size();
                for (int i = 0; i < size; ++i) {
                    Pair<String, String> pair = renamePairs.get(i);
                    if (!args[a].equals(pair.getLeft())) continue;
                    renamePairs.remove(i);
                    this.sendMessage(sender, "worldutils.commands.generic.list.remove.success", (String)pair.getLeft() + " => " + (String)pair.getRight());
                    break;
                }
                if (size != renamePairs.size()) continue;
                this.sendMessage(sender, "worldutils.commands.generic.list.remove.failure", args[a]);
            }
        } else if (cmd.equals("remove-with-spaces")) {
            String str = String.join((CharSequence)" ", args);
            int size = renamePairs.size();
            for (int i = 0; i < size; ++i) {
                Pair<String, String> pair = renamePairs.get(i);
                if (!str.equals(pair.getLeft())) continue;
                renamePairs.remove(i);
                this.sendMessage(sender, "worldutils.commands.generic.list.remove.success", (String)pair.getLeft() + " => " + (String)pair.getRight());
                return;
            }
            this.sendMessage(sender, "worldutils.commands.generic.list.remove.failure", str);
        }
    }
}

