/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.worldutils.command;

import fi.dy.masa.worldutils.command.CommandWorldUtils;
import fi.dy.masa.worldutils.command.SubCommand;
import fi.dy.masa.worldutils.data.BlockTools;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class SubCommandInspectBlock
extends SubCommand {
    public SubCommandInspectBlock(CommandWorldUtils baseCommand) {
        super(baseCommand);
    }

    @Override
    public String getName() {
        return "inspectblock";
    }

    @Override
    public void printHelpGeneric(ICommandSender sender) {
        this.sendMessage(sender, "worldutils.commands.help.generic.runhelpforallcommands", this.getUsageStringCommon() + " help");
    }

    @Override
    public void printFullHelp(ICommandSender sender, String[] args) {
        sender.func_145747_a((ITextComponent)new TextComponentString(this.getUsageString()));
    }

    private String getUsageString() {
        return this.getUsageStringCommon() + " <dump | print> <x> <y> <z> [dimension id]";
    }

    @Override
    protected List<String> getTabCompletionsSub(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos lookPos) {
        if (args.length == 1) {
            return CommandBase.func_71530_a((String[])args, (String[])new String[]{"dump", "print"});
        }
        return CommandBase.func_175771_a((String[])args, (int)1, (BlockPos)lookPos);
    }

    @Override
    public void execute(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        BlockPos pos;
        if (args.length < 4 || !args[0].equals("print") && !args[0].equals("dump")) {
            SubCommandInspectBlock.throwUsage(this.getUsageString(), new Object[0]);
        }
        boolean dumpToFile = args[0].equals("dump");
        args = SubCommandInspectBlock.dropFirstStrings(args, 1);
        Entity senderEntity = sender.func_174793_f();
        if (senderEntity != null) {
            Vec3d senderPos = senderEntity.func_174791_d();
            pos = new BlockPos((int)CommandBase.func_175770_a((double)senderPos.field_72450_a, (String)args[0], (boolean)false).func_179628_a(), (int)CommandBase.func_175770_a((double)senderPos.field_72448_b, (String)args[1], (boolean)false).func_179628_a(), (int)CommandBase.func_175770_a((double)senderPos.field_72449_c, (String)args[2], (boolean)false).func_179628_a());
        } else {
            pos = new BlockPos(CommandBase.func_175755_a((String)args[0]), CommandBase.func_175755_a((String)args[1]), CommandBase.func_175755_a((String)args[2]));
        }
        args = SubCommandInspectBlock.dropFirstStrings(args, 3);
        int dim = this.getDimension(this.getUsageString(), args, sender);
        WorldServer world = DimensionManager.getWorld((int)dim);
        if (world != null && !world.func_175701_a(pos)) {
            SubCommandInspectBlock.throwCommand("worldutils.commands.error.invalid_block_position", new Object[0]);
        }
        if (BlockTools.inspectBlock(dim, pos, dumpToFile, sender)) {
            if (dumpToFile) {
                this.sendMessage(sender, "worldutils.commands.inspectblock.success.file", new Object[0]);
            } else {
                this.sendMessage(sender, "worldutils.commands.inspectblock.success.console", new Object[0]);
            }
        } else {
            SubCommandInspectBlock.throwCommand("worldutils.commands.error.inspectblock.fail", new Object[0]);
        }
    }
}

