/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.worldutils.command;

import fi.dy.masa.worldutils.command.CommandWorldUtils;
import fi.dy.masa.worldutils.command.SubCommand;
import fi.dy.masa.worldutils.data.BlockTools;
import fi.dy.masa.worldutils.util.BlockData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class SubCommandSetBlock
extends SubCommand {
    public SubCommandSetBlock(CommandWorldUtils baseCommand) {
        super(baseCommand);
    }

    @Override
    public String getName() {
        return "setblock";
    }

    @Override
    public void printHelpGeneric(ICommandSender sender) {
        this.sendMessage(sender, "worldutils.commands.help.generic.runhelpforallcommands", this.getUsageStringCommon() + " help");
    }

    @Override
    public void printFullHelp(ICommandSender sender, String[] args) {
        sender.func_145747_a((ITextComponent)new TextComponentString(this.getUsageString()));
    }

    private String getUsageString() {
        return this.getUsageStringCommon() + " <x> <y> <z> <block> [dimension id]";
    }

    @Override
    protected List<String> getTabCompletionsSub(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos lookPos) {
        if (args.length != 4) {
            return Collections.emptyList();
        }
        ArrayList<String> options = new ArrayList<String>();
        for (ResourceLocation rl : ForgeRegistries.BLOCKS.getKeys()) {
            options.add(rl.toString());
        }
        return CommandBase.func_175762_a((String[])args, options);
    }

    @Override
    public void execute(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        BlockPos pos;
        if (args.length < 4) {
            SubCommandSetBlock.throwUsage(this.getUsageString(), new Object[0]);
        }
        Entity senderEntity = sender.func_174793_f();
        String blockStr = args[3];
        if (senderEntity != null) {
            Vec3d senderPos = senderEntity.func_174791_d();
            pos = new BlockPos((int)CommandBase.func_175770_a((double)senderPos.field_72450_a, (String)args[0], (boolean)false).func_179628_a(), (int)CommandBase.func_175770_a((double)senderPos.field_72448_b, (String)args[1], (boolean)false).func_179628_a(), (int)CommandBase.func_175770_a((double)senderPos.field_72449_c, (String)args[2], (boolean)false).func_179628_a());
        } else {
            pos = new BlockPos(CommandBase.func_175755_a((String)args[0]), CommandBase.func_175755_a((String)args[1]), CommandBase.func_175755_a((String)args[2]));
        }
        args = SubCommandSetBlock.dropFirstStrings(args, 4);
        int dim = this.getDimension(this.getUsageString(), args, sender);
        WorldServer world = DimensionManager.getWorld((int)dim);
        if (world != null && world.func_175667_e(pos)) {
            SubCommandSetBlock.throwCommand("worldutils.commands.error.setblock.block_loaded", new Object[0]);
        } else if (world != null && !world.func_175701_a(pos)) {
            SubCommandSetBlock.throwCommand("worldutils.commands.error.invalid_block_position", new Object[0]);
        }
        BlockData blockData = BlockData.parseBlockTypeFromString(blockStr);
        if (blockData != null && blockData.isValid()) {
            if (BlockTools.setBlock(dim, pos, blockData)) {
                this.sendMessage(sender, "worldutils.commands.setblock.success", dim, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), blockData.toString());
            } else {
                SubCommandSetBlock.throwCommand("worldutils.commands.error.setblock.fail", dim, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), blockData.toString());
            }
        } else {
            SubCommandSetBlock.throwCommand("worldutils.commands.blockreplace.block.print.invalid", blockStr);
        }
    }
}

