/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.worldutils.compat.journeymap;

import fi.dy.masa.worldutils.util.ChunkUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.ChunkPos;
import org.apache.commons.lang3.StringUtils;

public class ChunkChangeTracker {
    private static final ChunkChangeTracker INSTANCE = new ChunkChangeTracker();
    private final Set<ChunkPos> changedChunks = new HashSet<ChunkPos>();
    private final Set<ChunkPos> importedBiomes = new HashSet<ChunkPos>();
    private final Set<ChunkPos> setBiomes = new HashSet<ChunkPos>();
    private String ignoredWorld = "";
    private boolean newChanges;

    private ChunkChangeTracker() {
    }

    public static ChunkChangeTracker instance() {
        return INSTANCE;
    }

    public void setIgnoredWorld(String ignore) {
        this.ignoredWorld = ignore;
    }

    public boolean hasNewChanges() {
        return this.newChanges;
    }

    public Set<ChunkPos> getChangedChunksForType(ChunkUtils.ChangeType type) {
        this.newChanges = false;
        if (type == ChunkUtils.ChangeType.CHUNK_CHANGE) {
            return this.changedChunks;
        }
        if (type == ChunkUtils.ChangeType.BIOME_IMPORT) {
            return this.importedBiomes;
        }
        return this.setBiomes;
    }

    private void readChangesFromNBT(Set<ChunkPos> setIn, NBTTagCompound nbt, String tagName) {
        NBTTagList list = nbt.func_150295_c(tagName, 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            boolean ignored = this.ignoredWorld.equals(tag.func_74779_i("world"));
            int[] arr = tag.func_74759_k("chunks");
            for (int j = 0; j < arr.length - 1; j += 2) {
                if (ignored) continue;
                setIn.add(new ChunkPos(arr[j], arr[j + 1]));
            }
        }
    }

    public void readAllChangesFromNBT(NBTTagCompound nbt) {
        if (nbt == null || StringUtils.isBlank((CharSequence)nbt.func_74779_i("user"))) {
            return;
        }
        this.changedChunks.clear();
        this.importedBiomes.clear();
        this.setBiomes.clear();
        this.readChangesFromNBT(this.changedChunks, nbt, "chunks_changed");
        this.readChangesFromNBT(this.importedBiomes, nbt, "biomes_imported");
        this.readChangesFromNBT(this.setBiomes, nbt, "biomes_set");
        this.newChanges = true;
    }

    public void addIncrementalChanges(ChunkUtils.ChangeType type, Collection<ChunkPos> chunks, String worldName) {
        Set<ChunkPos> set = this.getChangedChunksForType(type);
        for (ChunkPos pos : chunks) {
            if (this.ignoredWorld.equals(worldName)) {
                set.remove(pos);
            } else {
                set.add(pos);
            }
            if (type != ChunkUtils.ChangeType.CHUNK_CHANGE) continue;
            this.importedBiomes.remove(pos);
            this.setBiomes.remove(pos);
        }
        this.newChanges = true;
    }
}

