/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.worldutils.compat.journeymap;

import fi.dy.masa.worldutils.WorldUtils;
import fi.dy.masa.worldutils.compat.journeymap.ChunkChangeTracker;
import fi.dy.masa.worldutils.config.Configs;
import fi.dy.masa.worldutils.util.ChunkUtils;
import java.util.EnumSet;
import java.util.Set;
import journeymap.client.api.ClientPlugin;
import journeymap.client.api.IClientAPI;
import journeymap.client.api.IClientPlugin;
import journeymap.client.api.display.Displayable;
import journeymap.client.api.display.PolygonOverlay;
import journeymap.client.api.event.ClientEvent;
import journeymap.client.api.model.MapPolygon;
import journeymap.client.api.model.ShapeProperties;
import journeymap.client.api.util.PolygonHelper;
import net.minecraft.util.math.ChunkPos;

@ClientPlugin
public class JourneymapClientPlugin
implements IClientPlugin {
    private IClientAPI api;

    public void initialize(IClientAPI jmClientApi) {
        this.api = jmClientApi;
        this.api.subscribe("worldutils", EnumSet.of(ClientEvent.Type.DISPLAY_UPDATE, ClientEvent.Type.MAPPING_STARTED, ClientEvent.Type.MAPPING_STOPPED));
    }

    public String getModId() {
        return "worldutils";
    }

    public void onEvent(ClientEvent event) {
        try {
            switch (event.type) {
                case MAPPING_STOPPED: {
                    this.api.removeAll("worldutils");
                    break;
                }
                case MAPPING_STARTED: 
                case DISPLAY_UPDATE: {
                    this.updatePolygons(event.dimension);
                    break;
                }
            }
        }
        catch (Exception e) {
            WorldUtils.logger.warn("Exception while updating map overlay");
        }
    }

    private void updatePolygons(int dimension) throws Exception {
        this.api.removeAll("worldutils");
        Set<ChunkPos> chunksChanged = ChunkChangeTracker.instance().getChangedChunksForType(ChunkUtils.ChangeType.CHUNK_CHANGE);
        Set<ChunkPos> chunksBiomesImported = ChunkChangeTracker.instance().getChangedChunksForType(ChunkUtils.ChangeType.BIOME_IMPORT);
        Set<ChunkPos> chunksBiomesSet = ChunkChangeTracker.instance().getChangedChunksForType(ChunkUtils.ChangeType.BIOME_SET);
        int colorChanged = Configs.colorChangedChunks;
        int colorBiomesImported = Configs.colorBiomesImported;
        int colorBiomesSet = Configs.colorBiomesSet;
        int colorBoth = Configs.colorChangedChunksAndChangedBiomes;
        ShapeProperties shapeChanged = new ShapeProperties().setStrokeWidth(1.5f).setFillOpacity(0.2f).setFillColor(colorChanged).setStrokeColor(colorChanged);
        ShapeProperties shapeBiomesImported = new ShapeProperties().setStrokeWidth(1.5f).setFillOpacity(0.2f).setFillColor(colorBiomesImported).setStrokeColor(colorBiomesImported);
        ShapeProperties shapeBiomesSet = new ShapeProperties().setStrokeWidth(1.5f).setFillOpacity(0.2f).setFillColor(colorBiomesSet).setStrokeColor(colorBiomesSet);
        ShapeProperties shapeBoth = new ShapeProperties().setStrokeWidth(1.5f).setFillOpacity(0.2f).setFillColor(colorBoth).setStrokeColor(colorBoth);
        for (ChunkPos chunk : chunksChanged) {
            if (chunksBiomesImported.contains(chunk) || chunksBiomesSet.contains(chunk)) {
                this.api.show((Displayable)this.createPolygon(dimension, chunk, shapeBoth));
                continue;
            }
            this.api.show((Displayable)this.createPolygon(dimension, chunk, shapeChanged));
        }
        for (ChunkPos chunk : chunksBiomesImported) {
            if (chunksChanged.contains(chunk)) continue;
            this.api.show((Displayable)this.createPolygon(dimension, chunk, shapeBiomesImported));
        }
        for (ChunkPos chunk : chunksBiomesSet) {
            if (chunksChanged.contains(chunk)) continue;
            this.api.show((Displayable)this.createPolygon(dimension, chunk, shapeBiomesSet));
        }
    }

    private PolygonOverlay createPolygon(int dimension, ChunkPos pos, ShapeProperties shape) {
        String displayId = "chunk_" + pos.toString();
        MapPolygon polygon = PolygonHelper.createChunkPolygon((int)pos.field_77276_a, (int)256, (int)pos.field_77275_b);
        PolygonOverlay overlay = new PolygonOverlay("worldutils", displayId, dimension, shape, polygon, null);
        return overlay;
    }
}

