/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.worldutils.data;

import fi.dy.masa.worldutils.data.DataDump;
import fi.dy.masa.worldutils.util.ModNameUtils;
import fi.dy.masa.worldutils.util.RegistryUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class BlockDump
extends DataDump {
    private BlockDump() {
        super(8);
    }

    @Override
    protected List<String> getLines() {
        ArrayList<String> lines = new ArrayList<String>();
        this.generateFormatStrings();
        lines.add(this.lineSeparator);
        lines.add("*** WARNING ***");
        lines.add("The block and item IDs are dynamic and will be different on each world!");
        lines.add("DO NOT use them for anything \"proper\"!! (other than manual editing/fixing of raw world data or something)");
        lines.add("*** ALSO ***");
        lines.add("The server doesn't have a list of sub block and sub items");
        lines.add("(= items with different damage value or blocks with different metadata).");
        lines.add("That is why the block and item list dumps only contain one entry per block/item class (separate ID) when run on a server.");
        lines.add("NOTE: The metadata value displayed is from the ItemStacks from getSubBlocks(), it's NOT necessarily the metadata value in world!!");
        lines.add("NOTE: For blocks, Subtypes = true is only based on the number of returned ItemStacks from getSubBlocks() being > 1");
        lines.add("NOTE: For blocks, Subtypes = ? means that Item.getItemFromBlock(block) returned null or the command was run on the server side");
        this.getFormattedData(lines);
        return lines;
    }

    public void addData(Block block, ResourceLocation rl, boolean subTypesKnown, boolean hasSubTypes, @Nonnull ItemStack stack) {
        String blockId = String.valueOf(Block.func_149682_b((Block)block));
        String modName = ModNameUtils.getModName(rl);
        String registryName = rl.toString();
        String displayName = !stack.func_190926_b() ? stack.func_82833_r() : block.func_149732_F();
        Item item = Item.func_150898_a((Block)block);
        String itemId = item != Items.field_190931_a ? String.format("%5d", Item.func_150891_b((Item)item)) : "-";
        String itemMeta = stack.func_190926_b() ? "-" : String.format("%5d", stack.func_77960_j());
        String subTypes = subTypesKnown ? String.valueOf(hasSubTypes) : "?";
        String exists = RegistryUtils.isDummied(ForgeRegistries.BLOCKS, rl) ? "false" : "true";
        this.addData(modName, registryName, blockId, subTypes, itemId, itemMeta, displayName, exists);
    }

    public static List<String> getFormattedBlockDump() {
        BlockDump blockDump = new BlockDump();
        for (Map.Entry entry : ForgeRegistries.BLOCKS.getEntries()) {
            blockDump.addData((Block)entry.getValue(), (ResourceLocation)entry.getKey(), false, false, ItemStack.field_190927_a);
        }
        blockDump.addTitle("Mod name", "Registry name", "BlockID", "Subtypes", "Item ID", "Item meta", "Display name", "Exists");
        blockDump.setColumnAlignment(2, DataDump.Alignment.RIGHT);
        blockDump.setColumnAlignment(3, DataDump.Alignment.RIGHT);
        blockDump.setColumnAlignment(4, DataDump.Alignment.RIGHT);
        blockDump.setColumnAlignment(5, DataDump.Alignment.RIGHT);
        blockDump.setUseColumnSeparator(true);
        return blockDump.getLines();
    }
}

