/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.worldutils.data;

import com.google.common.collect.Lists;
import fi.dy.masa.worldutils.WorldUtils;
import fi.dy.masa.worldutils.command.CommandWorldUtils;
import fi.dy.masa.worldutils.data.blockreplacer.BlockReplacerPairs;
import fi.dy.masa.worldutils.data.blockreplacer.BlockReplacerSet;
import fi.dy.masa.worldutils.event.tasks.TaskScheduler;
import fi.dy.masa.worldutils.event.tasks.TaskWorldProcessor;
import fi.dy.masa.worldutils.util.BlockData;
import fi.dy.masa.worldutils.util.BlockInfo;
import fi.dy.masa.worldutils.util.FileUtils;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.NibbleArray;
import org.apache.commons.lang3.tuple.Pair;

public class BlockTools {
    public static void replaceBlocks(int dimension, String replacement, List<String> blockNames, List<IBlockState> blockStates, boolean keepListedBlocks, LoadedType loaded, ICommandSender sender) throws CommandException {
        BlockReplacerSet replacer = new BlockReplacerSet(replacement, keepListedBlocks, loaded);
        replacer.addBlocksFromBlockStates(blockStates);
        replacer.addBlocksFromStrings(blockNames);
        if (keepListedBlocks) {
            replacer.addBlocksFromBlockStates(Lists.newArrayList((Object[])new IBlockState[]{Blocks.field_150350_a.func_176223_P()}));
        }
        TaskScheduler.getInstance().scheduleTask(new TaskWorldProcessor(dimension, replacer, sender), 1);
    }

    public static void replaceBlocksInPairs(int dimension, List<Pair<String, String>> blockPairs, LoadedType loaded, ICommandSender sender) throws CommandException {
        BlockReplacerPairs replacer = new BlockReplacerPairs(loaded);
        replacer.addBlockPairs(blockPairs);
        TaskScheduler.getInstance().scheduleTask(new TaskWorldProcessor(dimension, replacer, sender), 1);
    }

    public static boolean setBlock(int dimension, BlockPos blockPos, BlockData blockData) throws CommandException {
        int chunkZ;
        int chunkX;
        NBTTagCompound chunkNBT;
        FileUtils.Region region = BlockTools.getRegion(dimension, blockPos);
        if (region.getRegionFile() == null) {
            CommandWorldUtils.throwCommand("worldutils.commands.error.setblock.region_not_found", new Object[0]);
        }
        if ((chunkNBT = BlockTools.getChunkNBT(region, chunkX = blockPos.func_177958_n() >> 4, chunkZ = blockPos.func_177952_p() >> 4)) != null && chunkNBT.func_150297_b("Level", 10)) {
            if (BlockTools.setBlock(chunkNBT, blockPos, blockData)) {
                BlockTools.saveChunkNBT(region, chunkX, chunkZ, chunkNBT);
                return true;
            }
        } else {
            CommandWorldUtils.throwCommand("worldutils.commands.error.setblock.chunk_not_found", new Object[0]);
        }
        return false;
    }

    public static boolean inspectBlock(int dimension, BlockPos blockPos, boolean dumpToFile, ICommandSender sender) throws CommandException {
        int chunkZ;
        int chunkX;
        NBTTagCompound chunkNBT;
        FileUtils.Region region = BlockTools.getRegion(dimension, blockPos);
        if (region.getRegionFile() == null) {
            CommandWorldUtils.throwCommand("worldutils.commands.error.setblock.region_not_found", new Object[0]);
        }
        if ((chunkNBT = BlockTools.getChunkNBT(region, chunkX = blockPos.func_177958_n() >> 4, chunkZ = blockPos.func_177952_p() >> 4)) != null && chunkNBT.func_150297_b("Level", 10)) {
            int modified = BlockTools.getChunkModificationTimestamp(region.getFileName(), chunkX, chunkZ);
            if (BlockTools.inspectBlock(chunkNBT, blockPos, dumpToFile, sender, modified)) {
                return true;
            }
        } else {
            CommandWorldUtils.throwCommand("worldutils.commands.error.setblock.chunk_not_found", new Object[0]);
        }
        return false;
    }

    private static int getChunkModificationTimestamp(String regionFilePath, int chunkX, int chunkZ) {
        try {
            RandomAccessFile raf = new RandomAccessFile(regionFilePath, "r");
            raf.seek(4096 + ((chunkX & 0x1F) + (chunkZ & 0x1F) * 32) * 4);
            int timestamp = raf.readInt();
            raf.close();
            return timestamp;
        }
        catch (Exception e) {
            WorldUtils.logger.warn("BlockTools#getChunkModificationTimestamp(): Failed to read chunk modification timestamp from region file '{}'", (Object)regionFilePath);
            return 0;
        }
    }

    @Nullable
    private static FileUtils.Region getRegion(int dimension, BlockPos blockPos) throws CommandException {
        File worldDir = FileUtils.getWorldSaveLocation(dimension);
        if (worldDir == null) {
            CommandWorldUtils.throwCommand("worldutils.commands.error.invaliddimension", dimension);
        }
        return FileUtils.Region.fromRegionCoords(worldDir, blockPos.func_177958_n() >> 9, blockPos.func_177952_p() >> 9, false);
    }

    @Nullable
    private static NBTTagCompound getChunkNBT(FileUtils.Region region, int chunkX, int chunkZ) {
        DataInputStream dataIn = region.getRegionFile().func_76704_a(chunkX & 0x1F, chunkZ & 0x1F);
        if (dataIn == null) {
            WorldUtils.logger.warn("BlockTools#getChunkNBT(): Failed to get chunk data input stream for chunk ({}, {}) from file '{}'", (Object)chunkX, (Object)chunkZ, (Object)region.getFileName());
            return null;
        }
        try {
            NBTTagCompound chunkNBT = CompressedStreamTools.func_74794_a((DataInputStream)dataIn);
            dataIn.close();
            return chunkNBT;
        }
        catch (IOException e) {
            WorldUtils.logger.warn("BlockTools#getChunkNBT(): Failed to read chunk NBT data for chunk ({}, {}) from file '{}'", (Object)chunkX, (Object)chunkZ, (Object)region.getFileName(), (Object)e);
            return null;
        }
    }

    private static void saveChunkNBT(FileUtils.Region region, int chunkX, int chunkZ, NBTTagCompound chunkNBT) {
        if (chunkNBT != null && chunkNBT.func_150297_b("Level", 10)) {
            DataOutputStream dataOut = region.getRegionFile().func_76710_b(chunkX & 0x1F, chunkZ & 0x1F);
            if (dataOut == null) {
                WorldUtils.logger.warn("BlockTools#saveChunkNBT(): Failed to get chunk data output stream for chunk ({}, {}) in file '{}'", (Object)chunkX, (Object)chunkZ, (Object)region.getFileName());
                return;
            }
            try {
                CompressedStreamTools.func_74800_a((NBTTagCompound)chunkNBT, (DataOutput)dataOut);
                dataOut.close();
            }
            catch (IOException e) {
                WorldUtils.logger.warn("BlockTools#saveChunkNBT(): Failed to write chunk data for chunk ({}, {}) in file '{}'", (Object)chunkX, (Object)chunkZ, (Object)region.getFileName(), (Object)e);
            }
        }
    }

    private static boolean setBlock(NBTTagCompound chunkNBT, BlockPos pos, BlockData blockData) throws CommandException {
        if (chunkNBT != null && chunkNBT.func_150297_b("Level", 10)) {
            NBTTagCompound level = chunkNBT.func_74775_l("Level");
            NBTTagList sectionsList = level.func_150295_c("Sections", 10);
            int yPos = pos.func_177956_o() >> 4;
            if (sectionsList.func_74745_c() > yPos) {
                int stateId = blockData.getBlockStateId();
                NBTTagCompound sectionTag = sectionsList.func_150305_b(yPos);
                byte[] blockArray = sectionTag.func_74770_j("Blocks");
                NibbleArray metaNibble = new NibbleArray(sectionTag.func_74770_j("Data"));
                NibbleArray addNibble = null;
                byte blockId = (byte)(stateId & 0xFF);
                byte add = (byte)(stateId >>> 8 & 0xF);
                byte meta = (byte)(stateId >>> 12 & 0xF);
                int x = pos.func_177958_n() & 0xF;
                int y = pos.func_177956_o() & 0xF;
                int z = pos.func_177952_p() & 0xF;
                blockArray[y << 8 | z << 4 | x] = blockId;
                metaNibble.func_76581_a(x, y, z, (int)meta);
                if (sectionTag.func_150297_b("Add", 7)) {
                    addNibble = new NibbleArray(sectionTag.func_74770_j("Add"));
                    addNibble.func_76581_a(x, y, z, (int)add);
                } else if (add != 0) {
                    addNibble = new NibbleArray();
                    addNibble.func_76581_a(x, y, z, (int)add);
                    sectionTag.func_74773_a("Add", addNibble.func_177481_a());
                }
                BlockTools.removeTileEntityAndTileTick(level, pos);
                return true;
            }
            Integer sec = sectionsList.func_74745_c();
            Integer maxY = sec * 16 - 1;
            CommandWorldUtils.throwCommand("worldutils.commands.error.chunk_section_doesnt_exist", sec, maxY);
        }
        return false;
    }

    private static boolean inspectBlock(NBTTagCompound chunkNBT, BlockPos pos, boolean dumpToFile, ICommandSender sender, int modified) throws CommandException {
        if (chunkNBT != null && chunkNBT.func_150297_b("Level", 10)) {
            NBTTagCompound level = chunkNBT.func_74775_l("Level");
            NBTTagList sectionsList = level.func_150295_c("Sections", 10);
            int yPos = pos.func_177956_o() >> 4;
            if (sectionsList.func_74745_c() > yPos) {
                NBTTagCompound sectionTag = sectionsList.func_150305_b(yPos);
                byte[] blockArray = sectionTag.func_74770_j("Blocks");
                NibbleArray metaNibble = new NibbleArray(sectionTag.func_74770_j("Data"));
                int x = pos.func_177958_n() & 0xF;
                int y = pos.func_177956_o() & 0xF;
                int z = pos.func_177952_p() & 0xF;
                int meta = metaNibble.func_76582_a(x, y, z);
                int blockId = blockArray[y << 8 | z << 4 | x] & 0xFF;
                if (sectionTag.func_150297_b("Add", 7)) {
                    NibbleArray addNibble = new NibbleArray(sectionTag.func_74770_j("Add"));
                    blockId |= addNibble.func_76582_a(x, y, z) << 8;
                }
                NBTTagCompound tileNBT = BlockTools.getTileNBT(level, pos);
                BlockInfo.outputBlockInfo(blockId, meta, tileNBT, dumpToFile, sender, modified);
                return true;
            }
            Integer sec = sectionsList.func_74745_c();
            Integer maxY = sec * 16 - 1;
            CommandWorldUtils.throwCommand("worldutils.commands.error.chunk_section_doesnt_exist", sec, maxY);
        }
        return false;
    }

    @Nullable
    private static NBTTagCompound getTileNBT(NBTTagCompound level, BlockPos pos) {
        NBTTagList list = level.func_150295_c("TileEntities", 10);
        if (list != null) {
            int size = list.func_74745_c();
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            for (int i = 0; i < size; ++i) {
                NBTTagCompound tag = list.func_150305_b(i);
                if (tag.func_74762_e("x") != x || tag.func_74762_e("y") != y || tag.func_74762_e("z") != z) continue;
                return list.func_150305_b(i);
            }
        }
        return null;
    }

    private static void removeTileEntityAndTileTick(NBTTagCompound level, BlockPos pos) {
        NBTTagList list = level.func_150295_c("TileEntities", 10);
        if (list != null) {
            BlockTools.removeTileEntry(list, pos);
        }
        if ((list = level.func_150295_c("TileTicks", 10)) != null) {
            BlockTools.removeTileEntry(list, pos);
        }
    }

    private static void removeTileEntry(NBTTagList list, BlockPos pos) {
        int size = list.func_74745_c();
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        for (int i = 0; i < size; ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            if (tag.func_74762_e("x") != x || tag.func_74762_e("y") != y || tag.func_74762_e("z") != z) continue;
            list.func_74744_a(i);
            break;
        }
    }

    public static enum LoadedType {
        ALL,
        UNLOADED,
        LOADED;

    }
}

