/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.worldutils.data;

import fi.dy.masa.worldutils.WorldUtils;
import fi.dy.masa.worldutils.data.EntityData;
import fi.dy.masa.worldutils.data.IChunkDataHandler;
import fi.dy.masa.worldutils.data.IWorldDataHandler;
import fi.dy.masa.worldutils.event.TickHandler;
import fi.dy.masa.worldutils.event.tasks.ITask;
import fi.dy.masa.worldutils.event.tasks.TaskScheduler;
import fi.dy.masa.worldutils.event.tasks.TaskWorldProcessor;
import fi.dy.masa.worldutils.util.FileUtils;
import fi.dy.masa.worldutils.util.PositionUtils;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.gen.ChunkProviderServer;
import org.apache.commons.lang3.tuple.Pair;

public class EntityTools {
    private static final EntityTools INSTANCE = new EntityTools();
    private final EntityDataReader entityDataReader = new EntityDataReader();

    private EntityTools() {
    }

    public static EntityTools instance() {
        return INSTANCE;
    }

    public void readEntities(int dimension, ICommandSender sender) throws CommandException {
        this.entityDataReader.init(dimension);
        TaskScheduler.getInstance().scheduleTask(new TaskWorldProcessor(dimension, this.entityDataReader, sender), 1);
    }

    public void removeAllDuplicateEntities(int dimension, ICommandSender sender) throws CommandException {
        EntityDataReader reader = new EntityDataReader(dimension, true);
        reader.init(dimension);
        TaskScheduler.getInstance().scheduleTask(new TaskWorldProcessor(dimension, reader, sender), 1);
    }

    public void removeEntities(int dimension, List<String> toRemove, EntityRenamer.Type type, ICommandSender sender) throws CommandException {
        EntityRemover remover = new EntityRemover(toRemove, type);
        remover.init(dimension);
        TaskScheduler.getInstance().scheduleTask(new TaskWorldProcessor(dimension, remover, sender), 1);
    }

    public void renameEntities(int dimension, List<Pair<String, String>> renamePairs, EntityRenamer.Type type, ICommandSender sender) throws CommandException {
        EntityRenamer renamer = new EntityRenamer(renamePairs, type);
        renamer.init(dimension);
        TaskScheduler.getInstance().scheduleTask(new TaskWorldProcessor(dimension, renamer, sender), 1);
    }

    private static List<EntityData> getDuplicateEntitiesIncludingFirst(List<EntityData> dataIn, boolean sortFirst) {
        int size;
        ArrayList<EntityData> list = new ArrayList<EntityData>();
        if (sortFirst) {
            Collections.sort(dataIn);
        }
        if ((size = dataIn.size()) == 0) {
            return list;
        }
        EntityData current = dataIn.get(0);
        boolean dupe = false;
        for (int i = 1; i < size; ++i) {
            EntityData next = dataIn.get(i);
            if (next.getUUID().equals(current.getUUID())) {
                if (!dupe) {
                    list.add(current);
                }
                list.add(next);
                dupe = true;
            } else {
                dupe = false;
            }
            current = next;
        }
        return list;
    }

    private static List<EntityData> getDuplicateEntitiesExcludingFirst(List<EntityData> dataIn, boolean sortFirst) {
        int size;
        ArrayList<EntityData> list = new ArrayList<EntityData>();
        if (sortFirst) {
            Collections.sort(dataIn);
        }
        if ((size = dataIn.size()) == 0) {
            return list;
        }
        EntityData current = dataIn.get(0);
        for (int i = 1; i < size; ++i) {
            EntityData next = dataIn.get(i);
            if (next.getUUID().equals(current.getUUID())) {
                list.add(next);
            }
            current = next;
        }
        return list;
    }

    public List<String> getDuplicateEntitiesOutput(boolean includeFirst, boolean sortFirst) {
        List<EntityData> dupes = includeFirst ? EntityTools.getDuplicateEntitiesIncludingFirst(this.entityDataReader.getEntities(), sortFirst) : EntityTools.getDuplicateEntitiesExcludingFirst(this.entityDataReader.getEntities(), sortFirst);
        return this.getFormattedOutputLines(dupes, sortFirst);
    }

    public List<String> getAllEntitiesOutput(boolean sortFirst) {
        return this.getFormattedOutputLines(this.entityDataReader.getEntities(), sortFirst);
    }

    private List<String> getFormattedOutputLines(List<EntityData> dataIn, boolean sortFirst) {
        ArrayList<String> lines = new ArrayList<String>();
        if (sortFirst) {
            Collections.sort(dataIn);
        }
        int longestId = 0;
        for (EntityData entry : dataIn) {
            int len = entry.getId().length();
            if (len <= longestId) continue;
            longestId = len;
        }
        String format = "%s %" + longestId + "s @ {DIM: %3d pos: x = %8.2f, y = %8.2f, z = %8.2f chunk: (%5d, %5d) region: r.%d.%d.mca}";
        for (EntityData entry : dataIn) {
            String str = this.getFormattedOutput(entry, format);
            if (entry.getUUID().getLeastSignificantBits() == 0L && entry.getUUID().getMostSignificantBits() == 0L) {
                WorldUtils.logger.warn("Entity: {} UUID: most = 0, least = 0 => {}", (Object)entry.getId(), (Object)entry.getUUID().toString());
            }
            lines.add(str);
        }
        return lines;
    }

    private String getFormattedOutput(EntityData data, String format) {
        return String.format(format, data.getUUID().toString(), data.getId(), data.getDimension(), data.getPosition().field_72450_a, data.getPosition().field_72448_b, data.getPosition().field_72449_c, data.getChunkPosition().field_77276_a, data.getChunkPosition().field_77275_b, data.getChunkPosition().field_77276_a >> 5, data.getChunkPosition().field_77275_b >> 5);
    }

    public static class EntityRenamer
    implements IWorldDataHandler {
        private final Map<String, String> renamePairs = new HashMap<String, String>();
        private ChunkProviderServer provider;
        private int regionCount;
        private int chunkCount;
        private int entityCount;
        private final String tagName;

        public EntityRenamer(List<Pair<String, String>> renamePairs, Type type) {
            for (Pair<String, String> pair : renamePairs) {
                this.renamePairs.put((String)pair.getLeft(), (String)pair.getRight());
            }
            this.tagName = type == Type.TILE_ENTITIES ? "TileEntities" : "Entities";
        }

        @Override
        public void init(int dimension) {
            this.regionCount = 0;
            this.chunkCount = 0;
            this.entityCount = 0;
        }

        @Override
        public void setChunkProvider(@Nullable ChunkProviderServer provider) {
            this.provider = provider;
        }

        @Override
        public int processRegion(FileUtils.Region region, boolean simulate) {
            ++this.regionCount;
            return 0;
        }

        @Override
        public int processChunk(FileUtils.Region region, int chunkX, int chunkZ, boolean simulate) {
            int count = 0;
            DataInputStream data = region.getRegionFile().func_76704_a(chunkX, chunkZ);
            if (data == null) {
                WorldUtils.logger.warn("EntityRenamer#processChunk(): Failed to get chunk data input stream for chunk ({}, {}) from file '{}'", (Object)chunkX, (Object)chunkZ, (Object)region.getFileName());
                return 0;
            }
            try {
                NBTTagCompound chunkNBT = CompressedStreamTools.func_74794_a((DataInputStream)data);
                data.close();
                if (chunkNBT == null) {
                    WorldUtils.logger.warn("EntityRenamer#processChunk(): Failed to read chunk NBT data for chunk ({}, {}) from file '{}'", (Object)chunkX, (Object)chunkZ, (Object)region.getFileName());
                    return 0;
                }
                NBTTagCompound level = chunkNBT.func_74775_l("Level");
                if (level.func_150297_b(this.tagName, 9)) {
                    ChunkPos chunkPos = new ChunkPos(level.func_74762_e("xPos"), level.func_74762_e("zPos"));
                    if (this.provider != null && this.provider.func_73149_a(chunkPos.field_77276_a, chunkPos.field_77275_b)) {
                        return 0;
                    }
                    NBTTagList list = level.func_150295_c(this.tagName, 10);
                    for (int i = 0; i < list.func_74745_c(); ++i) {
                        NBTTagCompound entity = list.func_150305_b(i);
                        String id = entity.func_74779_i("id");
                        if (!this.renamePairs.containsKey(id)) continue;
                        if (!simulate) {
                            entity.func_74778_a("id", this.renamePairs.get(id));
                        }
                        ++count;
                    }
                    if (!simulate && count > 0) {
                        DataOutputStream dataOut = region.getRegionFile().func_76710_b(chunkX, chunkZ);
                        CompressedStreamTools.func_74800_a((NBTTagCompound)chunkNBT, (DataOutput)dataOut);
                        dataOut.close();
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++this.chunkCount;
            this.entityCount += count;
            return count;
        }

        @Override
        public void finish(ICommandSender sender, boolean simulate) {
            String chatOutput = String.format("Renamed a total of %d %s in %d chunks in %d region files", this.entityCount, this.tagName, this.chunkCount, this.regionCount);
            sender.func_145747_a((ITextComponent)new TextComponentString(chatOutput));
            WorldUtils.logger.info(chatOutput);
            if (this.provider != null) {
                chatOutput = String.format("There were %d chunks currently loaded, the %s in those chunks were not renamed!!", this.provider.func_73152_e(), this.tagName);
                sender.func_145747_a((ITextComponent)new TextComponentString(chatOutput));
                WorldUtils.logger.info(chatOutput);
            }
        }

        public static enum Type {
            ENTITIES,
            TILE_ENTITIES;

        }
    }

    public class EntityRemover
    implements IWorldDataHandler {
        private final Set<String> toRemove = new HashSet<String>();
        private ChunkProviderServer provider;
        private int regionCount;
        private int chunkCount;
        private int entityCount;
        private final String tagName;

        public EntityRemover(List<String> toRemove, EntityRenamer.Type type) {
            this.toRemove.addAll(toRemove);
            this.tagName = type == EntityRenamer.Type.TILE_ENTITIES ? "TileEntities" : "Entities";
        }

        @Override
        public void init(int dimension) {
            this.regionCount = 0;
            this.chunkCount = 0;
            this.entityCount = 0;
        }

        @Override
        public void setChunkProvider(@Nullable ChunkProviderServer provider) {
            this.provider = provider;
        }

        @Override
        public int processRegion(FileUtils.Region region, boolean simulate) {
            ++this.regionCount;
            return 0;
        }

        @Override
        public int processChunk(FileUtils.Region region, int chunkX, int chunkZ, boolean simulate) {
            int count = 0;
            DataInputStream data = region.getRegionFile().func_76704_a(chunkX, chunkZ);
            if (data == null) {
                WorldUtils.logger.warn("EntityRemover#processChunk(): Failed to get chunk data input stream for chunk ({}, {}) from file '{}'", (Object)chunkX, (Object)chunkZ, (Object)region.getFileName());
                return 0;
            }
            try {
                NBTTagCompound chunkNBT = CompressedStreamTools.func_74794_a((DataInputStream)data);
                data.close();
                if (chunkNBT == null) {
                    WorldUtils.logger.warn("EntityRemover#processChunk(): Failed to read chunk NBT data for chunk ({}, {}) from file '{}'", (Object)chunkX, (Object)chunkZ, (Object)region.getFileName());
                    return 0;
                }
                NBTTagCompound level = chunkNBT.func_74775_l("Level");
                if (level.func_150297_b(this.tagName, 9)) {
                    ChunkPos chunkPos = new ChunkPos(level.func_74762_e("xPos"), level.func_74762_e("zPos"));
                    if (this.provider != null && this.provider.func_73149_a(chunkPos.field_77276_a, chunkPos.field_77275_b)) {
                        return 0;
                    }
                    NBTTagList list = level.func_150295_c(this.tagName, 10);
                    for (int i = 0; i < list.func_74745_c(); ++i) {
                        NBTTagCompound entity = list.func_150305_b(i);
                        if (!this.toRemove.contains(entity.func_74779_i("id"))) continue;
                        if (!simulate) {
                            list.func_74744_a(i);
                            --i;
                        }
                        ++count;
                    }
                    if (!simulate && count > 0) {
                        DataOutputStream dataOut = region.getRegionFile().func_76710_b(chunkX, chunkZ);
                        CompressedStreamTools.func_74800_a((NBTTagCompound)chunkNBT, (DataOutput)dataOut);
                        dataOut.close();
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++this.chunkCount;
            this.entityCount += count;
            return count;
        }

        @Override
        public void finish(ICommandSender sender, boolean simulate) {
            String chatOutput = String.format("Removed a total of %d %s from %d chunks in %d region files", this.entityCount, this.tagName, this.chunkCount, this.regionCount);
            sender.func_145747_a((ITextComponent)new TextComponentString(chatOutput));
            WorldUtils.logger.info(chatOutput);
            if (this.provider != null) {
                chatOutput = String.format("There were %d chunks currently loaded, the %s in those chunks were not removed!!", this.provider.func_73152_e(), this.tagName);
                sender.func_145747_a((ITextComponent)new TextComponentString(chatOutput));
                WorldUtils.logger.info(chatOutput);
            }
        }
    }

    public class EntityDuplicateRemover
    implements IChunkDataHandler,
    ITask {
        private final File worldDir;
        private final int dimension;
        private final Map<ChunkPos, Map<ChunkPos, List<EntityData>>> entitiesByRegion;
        private Iterator<Map.Entry<ChunkPos, Map<ChunkPos, List<EntityData>>>> regionIter;
        private Iterator<Map.Entry<ChunkPos, List<EntityData>>> chunkIter;
        private Map.Entry<ChunkPos, Map<ChunkPos, List<EntityData>>> regionEntry;
        private List<EntityData> toRemoveCurrentChunk;
        private FileUtils.Region region;
        private int entityCount;
        private int regionCount;
        private int chunkCount;
        private int tickCount;

        public EntityDuplicateRemover(int dimension, List<EntityData> dupes) {
            this.dimension = dimension;
            this.worldDir = FileUtils.getWorldSaveLocation(dimension);
            this.entitiesByRegion = this.sortEntitiesByRegionAndChunk(dupes);
            this.regionIter = this.entitiesByRegion.entrySet().iterator();
        }

        @Override
        public void init() {
        }

        @Override
        public boolean canExecute() {
            return this.worldDir != null;
        }

        @Override
        public boolean execute() {
            ++this.tickCount;
            while (!this.checkTickTime()) {
                if (this.chunkIter == null || !this.chunkIter.hasNext()) {
                    if (!this.regionIter.hasNext()) {
                        return true;
                    }
                    this.regionEntry = this.regionIter.next();
                    this.region = FileUtils.Region.fromRegionCoords(this.worldDir, this.regionEntry.getKey());
                    this.chunkIter = this.regionEntry.getValue().entrySet().iterator();
                    ++this.regionCount;
                }
                if (!this.chunkIter.hasNext()) continue;
                Map.Entry<ChunkPos, List<EntityData>> chunkEntry = this.chunkIter.next();
                this.toRemoveCurrentChunk = chunkEntry.getValue();
                this.entityCount += FileUtils.handleChunkInRegion(this.region, chunkEntry.getKey(), this, false);
                ++this.chunkCount;
            }
            return false;
        }

        @Override
        public void stop() {
            WorldUtils.logger.info("DIM {}: Removed a total of {} duplicate entities from {} chunks in {} regions", (Object)this.dimension, (Object)this.entityCount, (Object)this.chunkCount, (Object)this.regionCount);
        }

        @Override
        public int processChunkData(ChunkPos chunkPos, NBTTagCompound chunkNBT, boolean simulate) {
            int entityCount = 0;
            NBTTagCompound level = chunkNBT.func_74775_l("Level");
            if (level.func_150297_b("Entities", 9)) {
                NBTTagList list = level.func_150295_c("Entities", 10);
                block0: for (EntityData data : this.toRemoveCurrentChunk) {
                    int size = list.func_74745_c();
                    for (int i = 0; i < size; ++i) {
                        NBTTagCompound entity = list.func_150305_b(i);
                        if (entity.func_74763_f("UUIDMost") != data.getUUID().getMostSignificantBits() || entity.func_74763_f("UUIDLeast") != data.getUUID().getLeastSignificantBits() || !entity.func_74779_i("id").equals(data.getId())) continue;
                        if (!simulate) {
                            list.func_74744_a(i);
                        }
                        ++entityCount;
                        continue block0;
                    }
                }
            }
            WorldUtils.logger.info("In region {}, chunk [{}, {}] - removed {} duplicate entities", (Object)this.region.getName(), (Object)chunkPos.field_77276_a, (Object)chunkPos.field_77275_b, (Object)entityCount);
            return entityCount;
        }

        private Map<ChunkPos, Map<ChunkPos, List<EntityData>>> sortEntitiesByRegionAndChunk(List<EntityData> listIn) {
            HashMap entitiesByRegion = new HashMap();
            for (EntityData entry : listIn) {
                PositionUtils.addDataForChunkInLists(entitiesByRegion, entry.getChunkPosition(), entry);
            }
            return entitiesByRegion;
        }

        private boolean checkTickTime() {
            long timeCurrent = System.currentTimeMillis();
            if (timeCurrent - TickHandler.instance().getTickStartTime() >= 48L) {
                if (this.tickCount % 100 == 0) {
                    WorldUtils.logger.info("EntityDuplicateRemover progress: Handled {} chunks in {} region files...", (Object)this.chunkCount, (Object)this.regionCount);
                }
                return true;
            }
            return false;
        }
    }

    private class EntityDataReader
    implements IWorldDataHandler {
        private ChunkProviderServer provider;
        private final int dimension;
        private int regionCount;
        private int chunkCount;
        private int entityCount;
        private final boolean removeDuplicates;
        private List<EntityData> entities = new ArrayList<EntityData>();

        public EntityDataReader() {
            this.dimension = 0;
            this.removeDuplicates = false;
        }

        public EntityDataReader(int dimension, boolean removeDuplicates) {
            this.dimension = dimension;
            this.removeDuplicates = removeDuplicates;
        }

        public List<EntityData> getEntities() {
            return this.entities;
        }

        @Override
        public void init(int dimension) {
            this.entities.clear();
            this.regionCount = 0;
            this.chunkCount = 0;
            this.entityCount = 0;
        }

        @Override
        public void setChunkProvider(@Nullable ChunkProviderServer provider) {
            this.provider = provider;
        }

        @Override
        public int processRegion(FileUtils.Region region, boolean simulate) {
            ++this.regionCount;
            return 0;
        }

        @Override
        public int processChunk(FileUtils.Region region, int chunkX, int chunkZ, boolean simulate) {
            int count = 0;
            DataInputStream data = region.getRegionFile().func_76704_a(chunkX, chunkZ);
            if (data == null) {
                WorldUtils.logger.warn("EntityDataReader#processChunk(): Failed to get chunk data input stream for chunk ({}, {}) from file '{}'", (Object)chunkX, (Object)chunkZ, (Object)region.getFileName());
                return 0;
            }
            try {
                NBTTagCompound chunkNBT = CompressedStreamTools.func_74794_a((DataInputStream)data);
                data.close();
                if (chunkNBT == null) {
                    WorldUtils.logger.warn("EntityDataReader#processChunk(): Failed to read chunk NBT data for chunk ({}, {}) from file '{}'", (Object)chunkX, (Object)chunkZ, (Object)region.getFileName());
                    return 0;
                }
                NBTTagCompound level = chunkNBT.func_74775_l("Level");
                if (level.func_150297_b("Entities", 9)) {
                    ChunkPos chunkPos = new ChunkPos(level.func_74762_e("xPos"), level.func_74762_e("zPos"));
                    if (this.provider != null && this.provider.func_73149_a(chunkPos.field_77276_a, chunkPos.field_77275_b)) {
                        return 0;
                    }
                    NBTTagList list = level.func_150295_c("Entities", 10);
                    for (int i = 0; i < list.func_74745_c(); ++i) {
                        NBTTagCompound entity = list.func_150305_b(i);
                        NBTTagList posList = entity.func_150295_c("Pos", 6);
                        int dim = entity.func_74762_e("Dimension");
                        Vec3d pos = new Vec3d(posList.func_150309_d(0), posList.func_150309_d(1), posList.func_150309_d(2));
                        UUID uuid = new UUID(entity.func_74763_f("UUIDMost"), entity.func_74763_f("UUIDLeast"));
                        this.entities.add(new EntityData(dim, entity.func_74779_i("id"), pos, chunkPos, uuid));
                        ++count;
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++this.chunkCount;
            this.entityCount += count;
            return count;
        }

        @Override
        public void finish(ICommandSender sender, boolean simulate) {
            String chatOutput;
            if (this.entityCount > 0) {
                chatOutput = String.format("Read a total of %d entities from %d chunks in %d region files", this.entityCount, this.chunkCount, this.regionCount);
                sender.func_145747_a((ITextComponent)new TextComponentString(chatOutput));
                WorldUtils.logger.info(chatOutput);
            }
            if (this.provider != null) {
                chatOutput = String.format("There were %d chunks currently loaded, the entity list does not include entities in those chunks!!", this.provider.func_73152_e());
                sender.func_145747_a((ITextComponent)new TextComponentString(chatOutput));
                WorldUtils.logger.info(chatOutput);
            }
            if (this.removeDuplicates) {
                List dupes = EntityTools.getDuplicateEntitiesExcludingFirst(this.getEntities(), true);
                EntityDuplicateRemover remover = new EntityDuplicateRemover(this.dimension, dupes);
                TaskScheduler.getInstance().scheduleTask(remover, 1);
            }
        }
    }
}

