/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.worldutils.data;

import fi.dy.masa.worldutils.WorldUtils;
import fi.dy.masa.worldutils.data.IWorldDataHandler;
import fi.dy.masa.worldutils.data.TileTickData;
import fi.dy.masa.worldutils.event.tasks.TaskScheduler;
import fi.dy.masa.worldutils.event.tasks.TaskWorldProcessor;
import fi.dy.masa.worldutils.util.FileUtils;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.gen.ChunkProviderServer;
import org.apache.commons.lang3.tuple.Pair;

public class TileTickTools {
    private static final TileTickTools INSTANCE = new TileTickTools();
    private final TileTickReader tileTickReader = new TileTickReader();
    private final Set<String> toRemoveMods = new HashSet<String>();
    private final Set<String> toRemoveNames = new HashSet<String>();

    private TileTickTools() {
    }

    public static TileTickTools instance() {
        return INSTANCE;
    }

    private static Pair<ResourceLocation, String> getBlockIdentifiers(NBTTagCompound tag, String name) {
        if (tag.func_150297_b("i", 8)) {
            return TileTickTools.getBlockIdentifiers(tag.func_74779_i("i"));
        }
        return TileTickTools.getBlockIdentifiers(tag.func_74762_e("i"));
    }

    private static Pair<ResourceLocation, String> getBlockIdentifiers(int id) {
        Block block = Block.func_149729_e((int)id);
        if (block != null && block.getRegistryName() != null) {
            ResourceLocation rl = block.getRegistryName();
            return Pair.of((Object)rl, (Object)rl.toString());
        }
        return Pair.of(null, (Object)String.valueOf(id));
    }

    private static Pair<ResourceLocation, String> getBlockIdentifiers(String name) {
        return Pair.of((Object)new ResourceLocation(name), (Object)name);
    }

    private Set<String> getRemoveSet(Operation operation) {
        if (operation == Operation.REMOVE_BY_MOD) {
            return this.toRemoveMods;
        }
        if (operation == Operation.REMOVE_BY_NAME) {
            return this.toRemoveNames;
        }
        return Collections.emptySet();
    }

    public void resetFilters(Operation operation) {
        this.getRemoveSet(operation).clear();
    }

    public void addFilter(String name, Operation operation) {
        this.getRemoveSet(operation).add(name);
    }

    public void removeFilter(String name, Operation operation) {
        this.getRemoveSet(operation).remove(name);
    }

    public Set<String> getFilters(Operation operation) {
        return this.getRemoveSet(operation);
    }

    public void startTask(int dimension, Operation operation, boolean forceRescan, ICommandSender sender) throws CommandException {
        if (operation == Operation.READ || operation == Operation.FIND_INVALID) {
            if (operation == Operation.READ || forceRescan || this.tileTickReader.getAllTileTicks().size() == 0) {
                this.tileTickReader.init(dimension);
                this.tileTickReader.setOperation(operation);
                TaskScheduler.getInstance().scheduleTask(new TaskWorldProcessor(dimension, this.tileTickReader, sender), 1);
            }
        } else if (operation == Operation.REMOVE_ALL) {
            TaskScheduler.getInstance().scheduleTask(new TaskWorldProcessor(dimension, new TileTickRemoverAll(), sender), 1);
        } else if (operation == Operation.REMOVE_BY_MOD) {
            Set<String> toRemove = this.getRemoveSet(operation);
            TileTickRemoverByModOrName remover = new TileTickRemoverByModOrName(Operation.REMOVE_BY_MOD, toRemove);
            TaskScheduler.getInstance().scheduleTask(new TaskWorldProcessor(dimension, remover, sender), 1);
        } else if (operation == Operation.REMOVE_BY_NAME) {
            Set<String> toRemove = this.getRemoveSet(operation);
            TileTickRemoverByModOrName remover = new TileTickRemoverByModOrName(Operation.REMOVE_BY_NAME, toRemove);
            TaskScheduler.getInstance().scheduleTask(new TaskWorldProcessor(dimension, remover, sender), 1);
        } else if (operation == Operation.REMOVE_INVALID) {
            TileTickRemoverByModOrName remover = new TileTickRemoverByModOrName(Operation.REMOVE_INVALID, Collections.emptySet());
            TaskScheduler.getInstance().scheduleTask(new TaskWorldProcessor(dimension, remover, sender), 1);
        }
    }

    public List<String> getAllTileTicksOutput(boolean sortFirst) {
        return this.getFormattedOutputLines(this.tileTickReader.getAllTileTicks(), sortFirst);
    }

    public List<String> getInvalidTileTicksOutput(boolean sortFirst) {
        return this.getFormattedOutputLines(this.tileTickReader.getInvalidTicksList(), sortFirst);
    }

    private List<String> getFormattedOutputLines(List<TileTickData> dataIn, boolean sortFirst) {
        ArrayList<String> lines = new ArrayList<String>();
        if (sortFirst) {
            Collections.sort(dataIn);
        }
        int longestId = 0;
        for (TileTickData entry : dataIn) {
            int len = entry.blockId.length();
            if (len <= longestId) continue;
            longestId = len;
        }
        String format = "%-" + longestId + "s - delay: %4d, priority: %2d @ {pos: x = %6d, y = %3d, z = %6d chunk: (%5d, %5d) region: r.%d.%d.mca}";
        for (TileTickData entry : dataIn) {
            lines.add(this.getFormattedOutput(entry, format));
        }
        return lines;
    }

    private String getFormattedOutput(TileTickData data, String format) {
        return String.format(format, data.blockId, data.delay, data.priority, data.blockPos.func_177958_n(), data.blockPos.func_177956_o(), data.blockPos.func_177952_p(), data.chunkPos.field_77276_a, data.chunkPos.field_77275_b, data.chunkPos.field_77276_a >> 5, data.chunkPos.field_77275_b >> 5);
    }

    private class TileTickRemoverByModOrName
    extends TileTickRemoverAll {
        private final Operation operation;
        private final Set<String> toRemove;

        public TileTickRemoverByModOrName(Operation operation, Set<String> toRemove) {
            this.operation = operation;
            this.toRemove = toRemove;
        }

        @Override
        public int processChunk(FileUtils.Region region, int chunkX, int chunkZ, boolean simulate) {
            int count;
            block17: {
                DataInputStream data = region.getRegionFile().func_76704_a(chunkX, chunkZ);
                count = 0;
                if (data == null) {
                    WorldUtils.logger.warn("TileTickRemoverByModOrName#processChunk(): Failed to get chunk data input stream for chunk ({}, {}) from file '{}'", (Object)chunkX, (Object)chunkZ, (Object)region.getFileName());
                    return 0;
                }
                try {
                    int i;
                    NBTTagCompound chunkNBT = CompressedStreamTools.func_74794_a((DataInputStream)data);
                    data.close();
                    if (chunkNBT == null) {
                        WorldUtils.logger.warn("TileTickRemoverByModOrName#processChunk(): Failed to read chunk NBT data for chunk ({}, {}) from file '{}'", (Object)chunkX, (Object)chunkZ, (Object)region.getFileName());
                        return 0;
                    }
                    NBTTagCompound level = chunkNBT.func_74775_l("Level");
                    if (!level.func_150297_b("TileTicks", 9)) break block17;
                    if (this.provider != null && this.provider.func_73149_a(level.func_74762_e("xPos"), level.func_74762_e("zPos"))) {
                        return 0;
                    }
                    NBTTagList list = level.func_150295_c("TileTicks", 10);
                    int size = list.func_74745_c();
                    if (this.operation == Operation.REMOVE_BY_MOD) {
                        for (i = 0; i < size; ++i) {
                            NBTTagCompound tag = list.func_150305_b(i);
                            Pair pair = TileTickTools.getBlockIdentifiers(tag, "i");
                            ResourceLocation rl = (ResourceLocation)pair.getLeft();
                            if (rl == null || !this.toRemove.contains(rl.func_110624_b())) continue;
                            if (!simulate) {
                                list.func_74744_a(i);
                                --i;
                                --size;
                            }
                            ++count;
                        }
                    } else if (this.operation == Operation.REMOVE_BY_NAME) {
                        for (i = 0; i < size; ++i) {
                            String name;
                            NBTTagCompound tag = list.func_150305_b(i);
                            String string = name = tag.func_150297_b("i", 8) ? tag.func_74779_i("i") : String.valueOf(tag.func_74762_e("i"));
                            if (!this.toRemove.contains(name)) continue;
                            if (!simulate) {
                                list.func_74744_a(i);
                                --i;
                                --size;
                            }
                            ++count;
                        }
                    } else if (this.operation == Operation.REMOVE_INVALID) {
                        for (i = 0; i < size; ++i) {
                            NBTTagCompound tag = list.func_150305_b(i);
                            if ((!tag.func_150297_b("i", 8) || Block.field_149771_c.func_82594_a((Object)new ResourceLocation(tag.func_74779_i("i"))) != Blocks.field_150350_a) && (!tag.func_150297_b("i", 3) || Block.func_149729_e((int)tag.func_74762_e("i")) != Blocks.field_150350_a)) continue;
                            if (!simulate) {
                                list.func_74744_a(i);
                                --i;
                                --size;
                            }
                            ++count;
                        }
                    }
                    if (!simulate && count > 0) {
                        DataOutputStream dataOut = region.getRegionFile().func_76710_b(chunkX, chunkZ);
                        CompressedStreamTools.func_74800_a((NBTTagCompound)chunkNBT, (DataOutput)dataOut);
                        dataOut.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            ++this.chunkCount;
            this.processedCount += count;
            return count;
        }
    }

    private class TileTickRemoverAll
    implements IWorldDataHandler {
        protected ChunkProviderServer provider;
        protected int regionCount;
        protected int chunkCount;
        protected int processedCount;

        private TileTickRemoverAll() {
        }

        @Override
        public void init(int dimension) {
        }

        @Override
        public void setChunkProvider(ChunkProviderServer provider) {
            this.provider = provider;
        }

        @Override
        public int processRegion(FileUtils.Region region, boolean simulate) {
            ++this.regionCount;
            return 0;
        }

        @Override
        public int processChunk(FileUtils.Region region, int chunkX, int chunkZ, boolean simulate) {
            int count = 0;
            DataInputStream data = region.getRegionFile().func_76704_a(chunkX, chunkZ);
            if (data == null) {
                WorldUtils.logger.warn("TileTickRemoverAll#processChunk(): Failed to get chunk data input stream for chunk ({}, {}) from file '{}'", (Object)chunkX, (Object)chunkZ, (Object)region.getFileName());
                return 0;
            }
            try {
                NBTTagCompound chunkNBT = CompressedStreamTools.func_74794_a((DataInputStream)data);
                data.close();
                if (chunkNBT == null) {
                    WorldUtils.logger.warn("TileTickRemoverAll#processChunk(): Failed to read chunk NBT data for chunk ({}, {}) from file '{}'", (Object)chunkX, (Object)chunkZ, (Object)region.getFileName());
                    return 0;
                }
                NBTTagCompound level = chunkNBT.func_74775_l("Level");
                if (level.func_150297_b("TileTicks", 9)) {
                    if (this.provider != null && this.provider.func_73149_a(level.func_74762_e("xPos"), level.func_74762_e("zPos"))) {
                        return 0;
                    }
                    count = level.func_150295_c("TileTicks", 10).func_74745_c();
                    if (count > 0 && !simulate) {
                        level.func_74782_a("TileTicks", (NBTBase)new NBTTagList());
                        DataOutputStream dataOut = region.getRegionFile().func_76710_b(chunkX, chunkZ);
                        CompressedStreamTools.func_74800_a((NBTTagCompound)chunkNBT, (DataOutput)dataOut);
                        dataOut.close();
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++this.chunkCount;
            this.processedCount += count;
            return count;
        }

        @Override
        public void finish(ICommandSender sender, boolean simulate) {
            if (this.processedCount > 0) {
                WorldUtils.logger.info("Removed a total of {} tile ticks from {} chunks in {} region files", (Object)this.processedCount, (Object)this.chunkCount, (Object)this.regionCount);
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("worldutils.commands.tileticks.remover.info", new Object[]{this.processedCount, this.chunkCount, this.regionCount}));
            }
            if (this.provider != null && this.provider.func_73152_e() > 0) {
                int loaded = this.provider.func_73152_e();
                WorldUtils.logger.info("There were {} chunks currently loaded, the tile ticks were NOT removed from those chunks", (Object)loaded);
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("worldutils.commands.tileticks.remover.loaded", new Object[]{loaded}));
            }
        }
    }

    private class TileTickReader
    implements IWorldDataHandler {
        protected ChunkProviderServer provider;
        protected List<TileTickData> tileTicks = new ArrayList<TileTickData>();
        protected List<TileTickData> invalidTicks = new ArrayList<TileTickData>();
        protected Set<String> foundIds = new HashSet<String>();
        protected Operation operation = Operation.READ;
        protected int regionCount;
        protected int chunkCount;
        protected int processedCount;
        protected boolean running;

        private TileTickReader() {
        }

        public List<TileTickData> getAllTileTicks() {
            if (this.running) {
                return Collections.emptyList();
            }
            return this.tileTicks;
        }

        public List<TileTickData> getInvalidTicksList() {
            if (this.running) {
                return Collections.emptyList();
            }
            return this.invalidTicks;
        }

        private void findAllInvalid() {
            this.invalidTicks.clear();
            for (TileTickData data : this.tileTicks) {
                if (data.resource != null && Block.field_149771_c.func_82594_a((Object)data.resource) != Blocks.field_150350_a) continue;
                this.invalidTicks.add(data);
            }
        }

        public void setOperation(Operation operation) {
            this.operation = operation;
        }

        @Override
        public void init(int dimension) {
            this.tileTicks.clear();
            this.regionCount = 0;
            this.chunkCount = 0;
            this.processedCount = 0;
            this.operation = Operation.READ;
            this.running = true;
        }

        @Override
        public void setChunkProvider(@Nullable ChunkProviderServer provider) {
            this.provider = provider;
        }

        @Override
        public int processRegion(FileUtils.Region region, boolean simulate) {
            ++this.regionCount;
            return 0;
        }

        @Override
        public int processChunk(FileUtils.Region region, int chunkX, int chunkZ, boolean simulate) {
            DataInputStream data = region.getRegionFile().func_76704_a(chunkX, chunkZ);
            int count = 0;
            if (data == null) {
                WorldUtils.logger.warn("TileTickReader#processChunk(): Failed to get chunk data input stream for chunk ({}, {}) from file '{}'", (Object)chunkX, (Object)chunkZ, (Object)region.getFileName());
                return 0;
            }
            try {
                NBTTagCompound chunkNBT = CompressedStreamTools.func_74794_a((DataInputStream)data);
                data.close();
                if (chunkNBT == null) {
                    WorldUtils.logger.warn("TileTickReader#processChunk(): Failed to read chunk NBT data for chunk ({}, {}) from file '{}'", (Object)chunkX, (Object)chunkZ, (Object)region.getFileName());
                    return 0;
                }
                NBTTagCompound level = chunkNBT.func_74775_l("Level");
                if (level.func_150297_b("TileTicks", 9)) {
                    ChunkPos chunkPos = new ChunkPos(level.func_74762_e("xPos"), level.func_74762_e("zPos"));
                    if (this.provider != null && this.provider.func_73149_a(chunkPos.field_77276_a, chunkPos.field_77275_b)) {
                        return 0;
                    }
                    NBTTagList list = level.func_150295_c("TileTicks", 10);
                    for (int i = 0; i < list.func_74745_c(); ++i) {
                        NBTTagCompound tag = list.func_150305_b(i);
                        int x = tag.func_74762_e("x");
                        int y = tag.func_74762_e("y");
                        int z = tag.func_74762_e("z");
                        int delay = tag.func_74762_e("t");
                        int priority = tag.func_74762_e("p");
                        Pair pair = TileTickTools.getBlockIdentifiers(tag, "i");
                        this.tileTicks.add(new TileTickData(chunkPos, new BlockPos(x, y, z), (ResourceLocation)pair.getLeft(), (String)pair.getRight(), delay, priority));
                        this.foundIds.add((String)pair.getRight());
                        ++count;
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++this.chunkCount;
            this.processedCount += count;
            return count;
        }

        @Override
        public void finish(ICommandSender sender, boolean simulate) {
            this.running = false;
            WorldUtils.logger.info("Read a total of {} tile ticks from {} chunks in {} region files", (Object)this.processedCount, (Object)this.chunkCount, (Object)this.regionCount);
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("worldutils.commands.tileticks.reader.info", new Object[]{this.processedCount, this.chunkCount, this.regionCount}));
            if (this.provider != null && this.provider.func_73152_e() > 0) {
                int loaded = this.provider.func_73152_e();
                WorldUtils.logger.info("There were {} chunks currently loaded, the tile tick list does not include data from those chunks!", (Object)loaded);
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("worldutils.commands.tileticks.reader.loaded", new Object[]{loaded}));
            }
            if (this.operation == Operation.FIND_INVALID) {
                this.findAllInvalid();
                WorldUtils.logger.info("Found {} invalid scheduled tile ticks in the world", (Object)this.invalidTicks.size());
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("worldutils.commands.tileticks.readingandfindinginvalid.complete", new Object[]{this.invalidTicks.size()}));
            }
        }
    }

    public static enum Operation {
        READ,
        FIND_INVALID,
        REMOVE_INVALID,
        REMOVE_BY_MOD,
        REMOVE_BY_NAME,
        REMOVE_ALL;

    }
}

