/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.worldutils.data.blockreplacer;

import fi.dy.masa.worldutils.WorldUtils;
import fi.dy.masa.worldutils.data.BlockTools;
import fi.dy.masa.worldutils.data.IWorldDataHandler;
import fi.dy.masa.worldutils.util.FileUtils;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraft.world.gen.ChunkProviderServer;

public abstract class BlockReplacerBase
implements IWorldDataHandler {
    protected ChunkProviderServer provider;
    protected final BlockTools.LoadedType loadedChunks;
    protected int regionCount;
    protected int chunkCountUnloaded;
    protected int chunkCountLoaded;
    protected int replaceCountUnloaded;
    protected int replaceCountLoaded;
    protected final boolean[] blocksToReplaceLookup = new boolean[65536];
    protected final IBlockState[] replacementBlockStates = new IBlockState[65536];
    protected final int[] replacementBlockStateIds = new int[65536];
    protected boolean validState;

    protected BlockReplacerBase(BlockTools.LoadedType loaded) {
        this.loadedChunks = loaded;
    }

    @Override
    public void init(int dimension) {
        this.regionCount = 0;
        this.chunkCountUnloaded = 0;
        this.chunkCountLoaded = 0;
        this.replaceCountUnloaded = 0;
        this.replaceCountLoaded = 0;
    }

    @Override
    public void setChunkProvider(ChunkProviderServer provider) {
        this.provider = provider;
    }

    @Override
    public int processRegion(FileUtils.Region region, boolean simulate) {
        ++this.regionCount;
        return 0;
    }

    @Override
    public int processChunk(FileUtils.Region region, int chunkX, int chunkZ, boolean simulate) {
        NBTTagCompound chunkNBT;
        if (!this.validState) {
            return 0;
        }
        DataInputStream dataIn = region.getRegionFile().func_76704_a(chunkX, chunkZ);
        int count = 0;
        if (dataIn == null) {
            WorldUtils.logger.warn("BlockReplacerBase#processChunk(): Failed to get chunk data input stream for chunk ({}, {}) from file '{}'", (Object)chunkX, (Object)chunkZ, (Object)region.getFileName());
            return 0;
        }
        try {
            chunkNBT = CompressedStreamTools.func_74794_a((DataInputStream)dataIn);
            dataIn.close();
        }
        catch (IOException e) {
            WorldUtils.logger.warn("BlockReplacerBase#processChunk(): Failed to read chunk NBT data for chunk ({}, {}) from file '{}'", (Object)chunkX, (Object)chunkZ, (Object)region.getFileName(), (Object)e);
            return 0;
        }
        if (chunkNBT != null && chunkNBT.func_150297_b("Level", 10)) {
            NBTTagCompound level = chunkNBT.func_74775_l("Level");
            ChunkPos chunkPos = new ChunkPos(level.func_74762_e("xPos"), level.func_74762_e("zPos"));
            if (this.provider != null && this.provider.func_73149_a(chunkPos.field_77276_a, chunkPos.field_77275_b)) {
                if (this.loadedChunks == BlockTools.LoadedType.ALL || this.loadedChunks == BlockTools.LoadedType.LOADED) {
                    count = this.processLoadedChunk(chunkPos.field_77276_a, chunkPos.field_77275_b);
                    this.replaceCountLoaded += count;
                    ++this.chunkCountLoaded;
                }
            } else if (this.loadedChunks == BlockTools.LoadedType.ALL || this.loadedChunks == BlockTools.LoadedType.UNLOADED) {
                count = this.processUnloadedChunk(region, chunkNBT, chunkX, chunkZ);
                this.replaceCountUnloaded += count;
                ++this.chunkCountUnloaded;
            }
        }
        return count;
    }

    private int processUnloadedChunk(FileUtils.Region region, NBTTagCompound chunkNBT, int chunkX, int chunkZ) {
        boolean chunkDirty = false;
        int count = 0;
        boolean[] replacedPositions = new boolean[65536];
        NBTTagCompound level = chunkNBT.func_74775_l("Level");
        NBTTagList sectionsList = level.func_150295_c("Sections", 10);
        for (int sec = 0; sec < sectionsList.func_74745_c(); ++sec) {
            int countLast = count;
            NBTTagCompound sectionTag = sectionsList.func_150305_b(sec);
            int sectionStart = sectionTag.func_74762_e("Y") * 4096;
            byte[] blockArray = sectionTag.func_74770_j("Blocks");
            int[] blockStateIds = new int[4096];
            NibbleArray metaNibble = new NibbleArray(sectionTag.func_74770_j("Data"));
            if (sectionTag.func_150297_b("Add", 7)) {
                NibbleArray addNibble = new NibbleArray(sectionTag.func_74770_j("Add"));
                for (int i = 0; i < 4096; ++i) {
                    int id = ((metaNibble.func_177480_a(i) & 0xF) << 12 | (addNibble.func_177480_a(i) & 0xF) << 8 | blockArray[i] & 0xFF) & 0xFFFF;
                    if (this.blocksToReplaceLookup[id]) {
                        blockStateIds[i] = this.replacementBlockStateIds[id];
                        replacedPositions[sectionStart + i] = true;
                        ++count;
                        continue;
                    }
                    blockStateIds[i] = id;
                }
            } else {
                for (int i = 0; i < 4096; ++i) {
                    int id = ((metaNibble.func_177480_a(i) & 0xF) << 12 | blockArray[i] & 0xFF) & 0xFFFF;
                    if (this.blocksToReplaceLookup[id]) {
                        blockStateIds[i] = this.replacementBlockStateIds[id];
                        replacedPositions[sectionStart + i] = true;
                        ++count;
                        continue;
                    }
                    blockStateIds[i] = id;
                }
            }
            if (count == countLast) continue;
            boolean needsAdd = false;
            byte[] metaArray = new byte[2048];
            byte[] addArray = new byte[2048];
            int i = 0;
            int bi = 0;
            while (i < 2048) {
                blockArray[bi] = (byte)(blockStateIds[bi] & 0xFF);
                blockArray[bi + 1] = (byte)(blockStateIds[bi + 1] & 0xFF);
                metaArray[i] = (byte)(blockStateIds[bi] >> 12 & 0xF | blockStateIds[bi + 1] >> 8 & 0xF0);
                addArray[i] = (byte)(blockStateIds[bi] >> 8 & 0xF | blockStateIds[bi + 1] >> 4 & 0xF0);
                needsAdd |= addArray[i] != 0;
                ++i;
                bi += 2;
            }
            sectionTag.func_74773_a("Blocks", blockArray);
            sectionTag.func_74773_a("Data", metaArray);
            if (needsAdd) {
                sectionTag.func_74773_a("Add", addArray);
            } else {
                sectionTag.func_82580_o("Add");
            }
            chunkDirty = true;
            countLast = count;
        }
        if (chunkDirty) {
            this.removeTileEntitiesAndTileTicks(level, replacedPositions);
            DataOutputStream dataOut = region.getRegionFile().func_76710_b(chunkX, chunkZ);
            if (dataOut == null) {
                WorldUtils.logger.warn("BlockReplacerBase#processChunk(): Failed to get chunk data output stream for chunk ({}, {}) in file '{}'", (Object)chunkX, (Object)chunkZ, (Object)region.getFileName());
                return 0;
            }
            try {
                CompressedStreamTools.func_74800_a((NBTTagCompound)chunkNBT, (DataOutput)dataOut);
                dataOut.close();
            }
            catch (IOException e) {
                WorldUtils.logger.warn("BlockReplacerBase#processChunk(): Failed to write chunk data for chunk ({}, {}) in file '{}'", (Object)chunkX, (Object)chunkZ, (Object)region.getFileName(), (Object)e);
            }
        }
        return count;
    }

    private void removeTileEntitiesAndTileTicks(NBTTagCompound level, boolean[] replacedPositions) {
        NBTTagList list = level.func_150295_c("TileEntities", 10);
        if (list != null) {
            this.removeTileEntry(list, replacedPositions);
        }
        if ((list = level.func_150295_c("TileTicks", 10)) != null) {
            this.removeTileEntry(list, replacedPositions);
        }
    }

    private void removeTileEntry(NBTTagList list, boolean[] replacedPositions) {
        int size = list.func_74745_c();
        for (int i = 0; i < size; ++i) {
            int z;
            NBTTagCompound tag = list.func_150305_b(i);
            int x = tag.func_74762_e("x");
            int y = tag.func_74762_e("y");
            int pos = (y & 0xFF) << 8 | ((z = tag.func_74762_e("z")) & 0xF) << 4 | x & 0xF;
            if (!replacedPositions[pos]) continue;
            list.func_74744_a(i);
            --i;
            --size;
        }
    }

    protected int processLoadedChunk(int chunkX, int chunkZ) {
        Chunk chunk = this.provider.func_186026_b(chunkX, chunkZ);
        World world = chunk.func_177412_p();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(0, 0, 0);
        int maxY = chunk.func_76625_h() + 15;
        int minX = chunkX << 4;
        int minZ = chunkZ << 4;
        int maxX = minX + 15;
        int maxZ = minZ + 15;
        int count = 0;
        for (int y = maxY; y >= 0; --y) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int x = minX; x <= maxX; ++x) {
                    pos.func_181079_c(x, y, z);
                    int id = Block.func_176210_f((IBlockState)world.func_180495_p((BlockPos)pos));
                    if (!this.blocksToReplaceLookup[id]) continue;
                    world.func_180501_a((BlockPos)pos, this.replacementBlockStates[id], 2);
                    ++count;
                }
            }
        }
        return count;
    }

    @Override
    public void finish(ICommandSender sender, boolean simulate) {
        WorldUtils.logger.info("Replaced a total of {} blocks in {} unloaded chunks and {} blocks in {} loaded chunks, touching {} region files", (Object)this.replaceCountUnloaded, (Object)this.chunkCountUnloaded, (Object)this.replaceCountLoaded, (Object)this.chunkCountLoaded, (Object)this.regionCount);
        sender.func_145747_a((ITextComponent)new TextComponentTranslation("worldutils.commands.blockreplace.execute.finished", new Object[]{this.replaceCountUnloaded, this.chunkCountUnloaded, this.replaceCountLoaded, this.chunkCountLoaded, this.regionCount}));
    }
}

