/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.worldutils.data.blockreplacer;

import fi.dy.masa.worldutils.WorldUtils;
import fi.dy.masa.worldutils.data.BlockTools;
import fi.dy.masa.worldutils.data.blockreplacer.BlockReplacerBase;
import fi.dy.masa.worldutils.util.BlockData;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import org.apache.commons.lang3.tuple.Pair;

public class BlockReplacerPairs
extends BlockReplacerBase {
    public BlockReplacerPairs(BlockTools.LoadedType loaded) {
        super(loaded);
        Arrays.fill(this.blocksToReplaceLookup, false);
    }

    public void addBlockPairs(List<Pair<String, String>> blockPairs) {
        boolean addedData = false;
        for (Pair<String, String> pair : blockPairs) {
            BlockData dataFrom = BlockData.parseBlockTypeFromString((String)pair.getLeft());
            BlockData dataTo = BlockData.parseBlockTypeFromString((String)pair.getRight());
            if (dataFrom != null && dataFrom.isValid() && dataTo != null && dataTo.isValid()) {
                int idFrom = dataFrom.getBlockStateId();
                int idTo = dataTo.getBlockStateId();
                this.blocksToReplaceLookup[idFrom] = true;
                this.replacementBlockStateIds[idFrom] = idTo;
                this.replacementBlockStates[idFrom] = Block.func_176220_d((int)idTo);
                addedData = true;
                continue;
            }
            WorldUtils.logger.warn("Failed to parse block from string '{}' or '{}'", pair.getLeft(), pair.getRight());
        }
        this.validState |= addedData;
    }
}

