/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.worldutils.data.blockreplacer;

import fi.dy.masa.worldutils.WorldUtils;
import fi.dy.masa.worldutils.data.BlockTools;
import fi.dy.masa.worldutils.data.blockreplacer.BlockReplacerBase;
import fi.dy.masa.worldutils.util.BlockData;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;

public class BlockReplacerSet
extends BlockReplacerBase {
    protected final boolean keepListedBlocks;
    protected final BlockData replacementBlockData;

    public BlockReplacerSet(String replacement, boolean keepListedBlocks, BlockTools.LoadedType loaded) {
        super(loaded);
        Arrays.fill(this.blocksToReplaceLookup, keepListedBlocks);
        this.keepListedBlocks = keepListedBlocks;
        this.replacementBlockData = BlockData.parseBlockTypeFromString(replacement);
        if (this.replacementBlockData != null && this.replacementBlockData.isValid()) {
            int id = this.replacementBlockData.getBlockStateId();
            IBlockState state = Block.func_176220_d((int)id);
            Arrays.fill(this.replacementBlockStateIds, id);
            Arrays.fill(this.replacementBlockStates, state);
        } else {
            WorldUtils.logger.warn("Failed to parse block from string '{}'", (Object)replacement);
            IBlockState state = Blocks.field_150350_a.func_176223_P();
            int id = Block.func_176210_f((IBlockState)state);
            Arrays.fill(this.replacementBlockStateIds, id);
            Arrays.fill(this.replacementBlockStates, state);
        }
    }

    public void addBlocksFromBlockStates(List<IBlockState> blockStates) {
        boolean replace = !this.keepListedBlocks;
        for (IBlockState state : blockStates) {
            this.blocksToReplaceLookup[Block.func_176210_f((IBlockState)state)] = replace;
        }
        this.validState |= this.replacementBlockData != null && this.replacementBlockData.isValid() && !blockStates.isEmpty();
    }

    public void addBlocksFromStrings(List<String> blockEntries) {
        boolean replace = !this.keepListedBlocks;
        boolean hasData = false;
        for (String str : blockEntries) {
            BlockData data = BlockData.parseBlockTypeFromString(str);
            if (data != null && data.isValid()) {
                hasData = true;
                for (int id : data.getBlockStateIds()) {
                    this.blocksToReplaceLookup[id] = replace;
                }
                continue;
            }
            WorldUtils.logger.warn("Failed to parse block from string '{}'", (Object)str);
        }
        this.validState |= this.replacementBlockData != null && this.replacementBlockData.isValid() && hasData;
    }
}

