/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.worldutils.event;

import fi.dy.masa.worldutils.item.base.IKeyBound;
import fi.dy.masa.worldutils.network.MessageKeyPressed;
import fi.dy.masa.worldutils.network.PacketHandler;
import fi.dy.masa.worldutils.reference.Keybindings;
import fi.dy.masa.worldutils.util.EntityUtils;
import gnu.trove.map.hash.TIntIntHashMap;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class InputEventHandler {
    public static final TIntIntHashMap KEY_CODE_MAPPINGS = new TIntIntHashMap(16);
    private static int scrollingMask = 0;
    private static int modifierMask = 0;

    public static void resetModifiers() {
        scrollingMask = 0;
        modifierMask = 0;
    }

    public static boolean isHoldingKeyboundItem(EntityPlayer player) {
        return EntityUtils.isHoldingItemOfType((EntityLivingBase)player, IKeyBound.class);
    }

    @SubscribeEvent
    public void onKeyInputEvent(InputEvent.KeyInputEvent event) {
        EntityPlayerSP player = FMLClientHandler.instance().getClientPlayerEntity();
        int eventKey = Keyboard.getEventKey();
        boolean keyState = Keyboard.getEventKeyState();
        if (KEY_CODE_MAPPINGS.containsKey(eventKey)) {
            int mask = KEY_CODE_MAPPINGS.get(eventKey);
            if (keyState) {
                modifierMask |= mask;
                if (InputEventHandler.isHoldingKeyboundItem((EntityPlayer)player)) {
                    scrollingMask |= mask;
                }
            } else {
                modifierMask &= ~mask;
                scrollingMask &= ~mask;
            }
        }
        if (FMLClientHandler.instance().getClient().field_71415_G && eventKey == Keybindings.keyToggleMode.func_151463_i() && keyState && InputEventHandler.isHoldingKeyboundItem((EntityPlayer)player)) {
            int keyCode = 1 | modifierMask;
            PacketHandler.INSTANCE.sendToServer((IMessage)new MessageKeyPressed(keyCode));
        }
    }

    @SubscribeEvent
    public void onMouseEvent(MouseEvent event) {
        int dWheel = event.getDwheel();
        if (dWheel != 0) {
            EntityPlayerSP player;
            dWheel /= 120;
            if (scrollingMask != 0 && InputEventHandler.isHoldingKeyboundItem((EntityPlayer)(player = FMLClientHandler.instance().getClientPlayerEntity()))) {
                int key = 0x1000 | scrollingMask;
                if (dWheel > 0) {
                    key |= 0x100000;
                }
                if (event.isCancelable()) {
                    event.setCanceled(true);
                }
                PacketHandler.INSTANCE.sendToServer((IMessage)new MessageKeyPressed(key));
            }
        }
    }

    @SubscribeEvent
    public void onGuiOpenEvent(GuiOpenEvent event) {
        InputEventHandler.resetModifiers();
    }

    static {
        KEY_CODE_MAPPINGS.put(42, 65536);
        KEY_CODE_MAPPINGS.put(54, 65536);
        KEY_CODE_MAPPINGS.put(29, 131072);
        KEY_CODE_MAPPINGS.put(157, 131072);
        KEY_CODE_MAPPINGS.put(56, 262144);
        KEY_CODE_MAPPINGS.put(184, 262144);
    }
}

