/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.worldutils.event;

import fi.dy.masa.worldutils.item.ItemChunkWand;
import fi.dy.masa.worldutils.network.MessageChunkChanges;
import fi.dy.masa.worldutils.network.MessageKeyPressed;
import fi.dy.masa.worldutils.network.PacketHandler;
import fi.dy.masa.worldutils.registry.WorldUtilsItems;
import fi.dy.masa.worldutils.util.ChunkUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;

public class PlayerEventHandler {
    @SubscribeEvent
    public void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        EntityPlayer player = event.getEntityPlayer();
        ItemStack stack = player.func_184614_ca();
        if (stack.func_190926_b()) {
            return;
        }
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        EnumFacing face = event.getFace();
        if (stack.func_77973_b() == WorldUtilsItems.CHUNK_WAND) {
            ((ItemChunkWand)stack.func_77973_b()).onLeftClickBlock(player, world, stack, pos, player.field_71093_bK, face);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLeftClickAir(PlayerInteractEvent.LeftClickEmpty event) {
        ItemStack stack;
        if (event.getSide() == Side.CLIENT && !(stack = event.getEntityPlayer().func_184614_ca()).func_190926_b() && stack.func_77973_b() == WorldUtilsItems.CHUNK_WAND) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new MessageKeyPressed(0x10000000));
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            PlayerEventHandler.sendChunkChanges(event.player.func_130014_f_(), (EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        WorldServer world;
        if (event.player instanceof EntityPlayerMP && (world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(event.toDim)) != null) {
            PlayerEventHandler.sendChunkChanges((World)world, (EntityPlayerMP)event.player);
        }
    }

    private static void sendChunkChanges(World world, EntityPlayerMP player) {
        NBTTagCompound nbt = ChunkUtils.instance().writeToNBT(world, player.func_70005_c_());
        if (!nbt.func_82582_d()) {
            PacketHandler.INSTANCE.sendTo((IMessage)new MessageChunkChanges(nbt), player);
        }
    }
}

