/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.worldutils.event.tasks;

import fi.dy.masa.worldutils.WorldUtils;
import fi.dy.masa.worldutils.command.SubCommand;
import fi.dy.masa.worldutils.data.IWorldDataHandler;
import fi.dy.masa.worldutils.event.TickHandler;
import fi.dy.masa.worldutils.event.tasks.ITask;
import fi.dy.masa.worldutils.event.tasks.TaskScheduler;
import fi.dy.masa.worldutils.util.FileUtils;
import java.io.File;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class TaskWorldProcessor
implements ITask {
    private final ICommandSender commandSender;
    private final IWorldDataHandler worldHandler;
    private final File[] regionFiles;
    private File currentRegionFile;
    private FileUtils.Region currentRegion;
    private State state = State.REGION;
    private final int dimension;
    private int regionIndex = 0;
    private int chunkIndex = 0;
    private int regionCount = 1;
    private int chunkCount = 0;
    private int tickCount = 0;

    public TaskWorldProcessor(int dimension, IWorldDataHandler handler, ICommandSender sender) throws CommandException {
        if (TaskScheduler.getInstance().hasTasks()) {
            SubCommand.throwCommand("worldutils.commands.error.taskalreadyrunning", new Object[0]);
        }
        this.dimension = dimension;
        this.worldHandler = handler;
        this.commandSender = sender;
        File regionDir = FileUtils.getRegionDirectory(dimension);
        if (regionDir != null && regionDir.exists() && regionDir.isDirectory()) {
            this.regionFiles = regionDir.listFiles(FileUtils.ANVIL_REGION_FILE_FILTER);
        } else {
            this.regionFiles = null;
            WorldUtils.logger.warn("Dimension {} could not be loaded or does not exist!", (Object)dimension);
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("worldutils.commands.error.invaliddimension", new Object[]{dimension}));
        }
    }

    @Override
    public void init() {
        this.currentRegionFile = this.regionFiles != null && this.regionFiles.length > 0 ? this.regionFiles[0] : null;
        this.currentRegion = this.currentRegionFile != null ? FileUtils.Region.fromRegionFile(this.currentRegionFile) : null;
    }

    @Override
    public boolean canExecute() {
        return this.currentRegion != null;
    }

    @Override
    public boolean execute() {
        WorldServer world = DimensionManager.getWorld((int)this.dimension);
        ++this.tickCount;
        if (world != null) {
            this.worldHandler.setChunkProvider(world.func_72863_F());
        } else {
            this.worldHandler.setChunkProvider(null);
        }
        if (this.state == State.REGION) {
            block11: {
                do {
                    if (this.checkTickTime()) {
                        return false;
                    }
                    if (this.worldHandler.processRegion(this.currentRegion, false) == 0) break block11;
                } while (!this.advanceRegion());
                return true;
            }
            this.state = State.CHUNKS;
        }
        if (this.state == State.CHUNKS) {
            while (this.chunkIndex < 1024) {
                if (this.checkTickTime()) {
                    return false;
                }
                int chunkX = this.chunkIndex & 0x1F;
                int chunkZ = this.chunkIndex >> 5;
                if (this.currentRegion.getRegionFile().func_76709_c(chunkX, chunkZ)) {
                    this.worldHandler.processChunk(this.currentRegion, chunkX, chunkZ, false);
                    ++this.chunkCount;
                }
                ++this.chunkIndex;
            }
            if (this.chunkIndex >= 1024 && this.advanceRegion()) {
                return true;
            }
        }
        if (this.tickCount % 100 == 0) {
            WorldUtils.logger.info("TaskWorldProcessor progress: Handled {} chunks in {} region files...", (Object)this.chunkCount, (Object)this.regionCount);
        }
        return false;
    }

    private boolean checkTickTime() {
        long timeCurrent = System.currentTimeMillis();
        if (timeCurrent - TickHandler.instance().getTickStartTime() >= 48L) {
            if (this.tickCount % 100 == 0) {
                WorldUtils.logger.info("TaskWorldProcessor progress: Handled {} chunks in {} region files...", (Object)this.chunkCount, (Object)this.regionCount);
            }
            return true;
        }
        return false;
    }

    private boolean advanceRegion() {
        ++this.regionIndex;
        this.state = State.REGION;
        if (this.regionIndex < this.regionFiles.length) {
            this.currentRegionFile = this.regionFiles[this.regionIndex];
            this.currentRegion = FileUtils.Region.fromRegionFile(this.currentRegionFile);
            ++this.regionCount;
            this.chunkIndex = 0;
            return false;
        }
        return true;
    }

    @Override
    public void stop() {
        this.worldHandler.finish(this.commandSender, false);
        WorldUtils.logger.info("TaskWorldProcessor exiting, handled {} chunks in {} region files", (Object)this.chunkCount, (Object)this.regionCount);
    }

    private static enum State {
        REGION,
        CHUNKS;

    }
}

